/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityNodeHelper
extends ElementEditHelper {
    public static final String IN_PARTITION = "IN_PARTITION";
    public static final String IN_INTERRUPTIBLE_ACTIVITY_REGION = "IN_INTERRUPTIBLE_ACTIVITY_REGION";
    public static final String OUT_FROM_PARTITION = "OUT_FROM_PARTITION";
    public static final String OUT_FROM_INTERRUPTIBLE_REGION = "OUT_FROM_REGION";

    protected ICommand getCreateCommand(CreateElementRequest req) {
        ActivityNodeHelper.fillRequestWithInPartitionsAndInInterruptibleRegions(req);
        return super.getCreateCommand(req);
    }

    protected ICommand getBasicDestroyElementCommand(DestroyElementRequest req) {
        DestroyElementCommand result = req.getBasicDestroyCommand();
        if (result == null) {
            result = new DestroyActivityOwnedElementCommand(req);
        } else {
            req.setBasicDestroyCommand(null);
        }
        return result;
    }

    @Override
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        Object parameterValue;
        if (req.getParameter(IN_PARTITION) != null) {
            parameterValue = req.getParameter(IN_PARTITION);
            if (parameterValue instanceof Collection) {
                CompositeCommand compositeCommand = new CompositeCommand("Set ActivityPartitions Nodes");
                for (Object entryValue : (Collection)parameterValue) {
                    if (!(entryValue instanceof EObject)) continue;
                    compositeCommand.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)entryValue, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityPartition_Node(), (Object)req.getElementToConfigure())));
                }
                return compositeCommand;
            }
            if (parameterValue instanceof EObject) {
                return new SetValueCommand(new SetRequest((EObject)parameterValue, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityPartition_Node(), (Object)req.getElementToConfigure()));
            }
        }
        if (req.getParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION) != null) {
            parameterValue = req.getParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION);
            if (parameterValue instanceof Collection) {
                CompositeCommand compositeCommand = new CompositeCommand("Set InterruptibleActivityRegions Nodes");
                for (Object entryValue : (Collection)parameterValue) {
                    if (!(entryValue instanceof EObject)) continue;
                    compositeCommand.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)entryValue, (EStructuralFeature)UMLPackage.eINSTANCE.getInterruptibleActivityRegion_Node(), (Object)req.getElementToConfigure())));
                }
                return compositeCommand;
            }
            if (parameterValue instanceof EObject) {
                return new SetValueCommand(new SetRequest((EObject)parameterValue, (EStructuralFeature)UMLPackage.eINSTANCE.getInterruptibleActivityRegion_Node(), (Object)req.getElementToConfigure()));
            }
        }
        return super.getConfigureCommand(req);
    }

    public static void fillRequestWithInPartitionsAndInInterruptibleRegions(CreateElementRequest createRequest) {
        EObject container = createRequest.getContainer();
        if (container instanceof ActivityNode) {
            EList inInterruptibleRegions;
            EList inPartitions = ((ActivityNode)container).getInPartitions();
            if (!inPartitions.isEmpty()) {
                createRequest.setParameter(IN_PARTITION, (Object)inPartitions);
            }
            if (!(inInterruptibleRegions = ((ActivityNode)container).getInInterruptibleRegions()).isEmpty()) {
                createRequest.setParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION, (Object)inInterruptibleRegions);
            }
        }
    }

    public static ICommand getMoveOutFromPartitionCommand(MoveRequest req) {
        if (req.getParameter(OUT_FROM_PARTITION) != null) {
            CompositeCommand cc = new CompositeCommand("Move Out From Parition");
            ActivityPartition outFromPartition = (ActivityPartition)req.getParameter(OUT_FROM_PARTITION);
            for (Object elementToMove : req.getElementsToMove().keySet()) {
                ActivityPartition inPartition;
                if (!(elementToMove instanceof ActivityNode)) continue;
                ActivityNode node = (ActivityNode)elementToMove;
                LinkedList<ActivityPartition> inPartitions = new LinkedList<ActivityPartition>((Collection<ActivityPartition>)node.getInPartitions());
                boolean change = false;
                if (inPartitions.contains(outFromPartition)) {
                    inPartitions.remove(outFromPartition);
                    change = true;
                }
                if (req.getParameter(IN_PARTITION) != null && !inPartitions.contains(inPartition = (ActivityPartition)req.getParameter(IN_PARTITION))) {
                    inPartitions.add(inPartition);
                    change = true;
                }
                if (change) {
                    cc.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)node, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityNode_InPartition(), inPartitions)));
                }
                if (req.getParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION) == null) continue;
                InterruptibleActivityRegion inRegion = (InterruptibleActivityRegion)req.getParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION);
                LinkedList<InterruptibleActivityRegion> inRegions = new LinkedList<InterruptibleActivityRegion>((Collection<InterruptibleActivityRegion>)node.getInInterruptibleRegions());
                if (inRegions.contains(inRegion)) continue;
                inRegions.add(inRegion);
                cc.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)node, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityNode_InInterruptibleRegion(), inRegions)));
            }
            return cc.isEmpty() ? null : cc.reduce();
        }
        return null;
    }

    public static ICommand getMoveOutFromInterruptibleActivityRegionCommand(MoveRequest req) {
        if (req.getParameter(OUT_FROM_INTERRUPTIBLE_REGION) != null) {
            CompositeCommand cc = new CompositeCommand("Move Out From InterruptibleActivityRegion");
            InterruptibleActivityRegion outFromRegion = (InterruptibleActivityRegion)req.getParameter(OUT_FROM_INTERRUPTIBLE_REGION);
            for (Object elementToMove : req.getElementsToMove().keySet()) {
                InterruptibleActivityRegion inRegion;
                if (!(elementToMove instanceof ActivityNode)) continue;
                ActivityNode node = (ActivityNode)elementToMove;
                LinkedList<InterruptibleActivityRegion> inRegions = new LinkedList<InterruptibleActivityRegion>((Collection<InterruptibleActivityRegion>)node.getInInterruptibleRegions());
                boolean change = false;
                if (inRegions.contains(outFromRegion)) {
                    inRegions.remove(outFromRegion);
                    change = true;
                }
                if (req.getParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION) != null && !inRegions.contains(inRegion = (InterruptibleActivityRegion)req.getParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION))) {
                    inRegions.add(inRegion);
                    change = true;
                }
                if (change) {
                    cc.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)node, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityNode_InInterruptibleRegion(), inRegions)));
                }
                if (req.getParameter(IN_PARTITION) == null) continue;
                ActivityPartition inPartition = (ActivityPartition)req.getParameter(IN_PARTITION);
                LinkedList<ActivityPartition> inPartitions = new LinkedList<ActivityPartition>((Collection<ActivityPartition>)node.getInPartitions());
                if (inPartitions.contains(inPartition)) continue;
                inPartitions.add(inPartition);
                cc.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)node, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityNode_InPartition(), inPartitions)));
            }
            return cc.isEmpty() ? null : cc.reduce();
        }
        return null;
    }

    static class DestroyActivityOwnedElementCommand
    extends DestroyElementCommand {
        DestroyActivityOwnedElementCommand(DestroyElementRequest request) {
            super(request);
        }

        protected void tearDownIncomingReferences(EObject destructee) {
            Activity activity = (Activity)TypeUtils.as((Object)destructee.eContainer(), Activity.class);
            if (activity != null) {
                activity.getNodes().remove((Object)destructee);
                activity.getGroups().remove((Object)destructee);
            }
            super.tearDownIncomingReferences(destructee);
        }
    }
}

