/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.papyrus.uml.service.types.utils.NamespaceOwnedMemberUtils;
import org.eclipse.uml2.uml.Namespace;

public class ElementOwnedElementReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ElementOwnedElementReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Namespace)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.newEnd instanceof Namespace)) {
            return false;
        }
        return NamespaceOwnedMemberUtils.canContainTarget(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.newEnd instanceof Namespace)) {
            return false;
        }
        return NamespaceOwnedMemberUtils.canContainTarget(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        Object value = this.getNewSource().eGet((EStructuralFeature)NamespaceOwnedMemberUtils.getContainmentFeature(this.getNewSource(), this.getOldTarget()));
        if (value instanceof List) {
            ((List)value).add(this.getOldTarget());
        } else if (value != null) {
            this.getNewSource().eSet((EStructuralFeature)NamespaceOwnedMemberUtils.getContainmentFeature(this.getNewSource(), this.getOldTarget()), (Object)this.getOldTarget());
        }
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        Object value = this.getOldSource().eGet((EStructuralFeature)NamespaceOwnedMemberUtils.getContainmentFeature(this.getOldSource(), this.getNewTarget()));
        if (value instanceof List) {
            ((List)value).add(this.getNewTarget());
        } else if (value != null) {
            this.getOldSource().eSet((EStructuralFeature)NamespaceOwnedMemberUtils.getContainmentFeature(this.getOldSource(), this.getNewTarget()), (Object)this.getNewTarget());
        }
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Namespace getOldSource() {
        return (Namespace)this.referenceOwner;
    }

    protected Namespace getNewSource() {
        return (Namespace)this.newEnd;
    }

    protected Namespace getOldTarget() {
        return (Namespace)this.oldEnd;
    }

    protected Namespace getNewTarget() {
        return (Namespace)this.newEnd;
    }
}

