/**
 * Copyright (c) 2006 - 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram;

import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.Objects;
import org.eclipse.papyrus.gmf.codegen.gmfgen.DefaultSizeAttributes;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelOffsetAttributes;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ResizeConstraints;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StyleAttributes;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class ViewmapAttributesUtils_qvto {
  public boolean isStoringChildPositions(final ViewmapLayoutType layoutType) {
    return Objects.equals(Integer.valueOf(ViewmapLayoutType.XY_LAYOUT), layoutType);
  }

  public boolean isFixedFont(final Viewmap xptSelf) {
    return ((xptSelf != null) && IterableExtensions.<StyleAttributes>exists(Iterables.<StyleAttributes>filter(xptSelf.getAttributes(), StyleAttributes.class), ((Function1<StyleAttributes, Boolean>) (StyleAttributes it) -> {
      return Boolean.valueOf(it.isFixedFont());
    })));
  }

  public boolean isFixedForeground(final Viewmap xptSelf) {
    return ((xptSelf != null) && IterableExtensions.<StyleAttributes>exists(Iterables.<StyleAttributes>filter(xptSelf.getAttributes(), StyleAttributes.class), ((Function1<StyleAttributes, Boolean>) (StyleAttributes it) -> {
      return Boolean.valueOf(it.isFixedForeground());
    })));
  }

  public boolean isFixedBackground(final Viewmap xptSelf) {
    return ((xptSelf != null) && IterableExtensions.<StyleAttributes>exists(Iterables.<StyleAttributes>filter(xptSelf.getAttributes(), StyleAttributes.class), ((Function1<StyleAttributes, Boolean>) (StyleAttributes it) -> {
      return Boolean.valueOf(it.isFixedBackground());
    })));
  }

  public boolean canUseShapeStyle(final Viewmap xptSelf) {
    return ((xptSelf != null) && (!((this.isFixedFont(xptSelf) || this.isFixedForeground(xptSelf)) || this.isFixedBackground(xptSelf))));
  }

  public ResizeConstraints getResizeConstraints(final Viewmap viewmap) {
    if ((viewmap == null)) {
      return null;
    }
    return IterableExtensions.<ResizeConstraints>head(Iterables.<ResizeConstraints>filter(viewmap.getAttributes(), ResizeConstraints.class));
  }

  public DefaultSizeAttributes getDefaultSizeAttributes(final Viewmap viewmap) {
    if ((viewmap == null)) {
      return null;
    }
    return IterableExtensions.<DefaultSizeAttributes>head(Iterables.<DefaultSizeAttributes>filter(viewmap.getAttributes(), DefaultSizeAttributes.class));
  }

  public LabelOffsetAttributes getLabelOffsetAttributes(final Viewmap viewmap) {
    if ((viewmap == null)) {
      return null;
    }
    return IterableExtensions.<LabelOffsetAttributes>head(Iterables.<LabelOffsetAttributes>filter(viewmap.getAttributes(), LabelOffsetAttributes.class));
  }

  public int defaultSizeWidth(final Viewmap viewmap, final int defaultValue) {
    DefaultSizeAttributes result = this.getDefaultSizeAttributes(viewmap);
    int _xifexpression = (int) 0;
    if ((result == null)) {
      _xifexpression = defaultValue;
    } else {
      _xifexpression = result.getWidth();
    }
    return _xifexpression;
  }

  public int defaultSizeHeight(final Viewmap viewmap, final int defaultValue) {
    DefaultSizeAttributes result = this.getDefaultSizeAttributes(viewmap);
    int _xifexpression = (int) 0;
    if ((result == null)) {
      _xifexpression = defaultValue;
    } else {
      _xifexpression = result.getHeight();
    }
    return _xifexpression;
  }

  public int labelOffsetX(final Viewmap viewmap, final int defaultValue) {
    LabelOffsetAttributes result = this.getLabelOffsetAttributes(viewmap);
    int _xifexpression = (int) 0;
    if ((result == null)) {
      _xifexpression = defaultValue;
    } else {
      _xifexpression = result.getX();
    }
    return _xifexpression;
  }

  public int labelOffsetY(final Viewmap viewmap, final int defaultValue) {
    LabelOffsetAttributes result = this.getLabelOffsetAttributes(viewmap);
    int _xifexpression = (int) 0;
    if ((result == null)) {
      _xifexpression = defaultValue;
    } else {
      _xifexpression = result.getY();
    }
    return _xifexpression;
  }
}
