/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.canonical.editpolicy;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.tools.util.ReferenceCounted;

public class CanonicalStateListener
extends ReferenceCounted<CanonicalStateListener>
implements NotificationListener {
    private static final ConcurrentMap<IGraphicalEditPart, CanonicalStateListener> listeners = new MapMaker().weakKeys().weakValues().makeMap();
    private final IGraphicalEditPart owner;
    private List<Handler> handlers = Lists.newArrayListWithExpectedSize((int)2);

    private CanonicalStateListener(IGraphicalEditPart owner) {
        this.owner = owner;
        this.install();
    }

    protected void dispose() {
        listeners.remove(this.owner, (Object)this);
        this.uninstall();
    }

    public static CanonicalStateListener getInstance(IGraphicalEditPart editPart) {
        CanonicalStateListener clash;
        CanonicalStateListener result = (CanonicalStateListener)((Object)listeners.get(editPart));
        if (result == null && (clash = listeners.putIfAbsent(editPart, result = new CanonicalStateListener(editPart))) != null) {
            result.dispose();
            result = clash;
        }
        return (CanonicalStateListener)((Object)result.retain());
    }

    public void addCanonicalRefreshHandler(Handler refreshHandler) {
        this.handlers.add(refreshHandler);
    }

    public void removeCanonicalRefreshHandler(Handler refreshHandler) {
        this.handlers.remove(refreshHandler);
    }

    private void install() {
        if (this.owner != null) {
            View view = this.owner.getNotationView();
            DiagramEventBroker broker = this.getDiagramEventBroker();
            broker.addNotificationListener((EObject)view, (EStructuralFeature)NotationPackage.Literals.VIEW__STYLES, (NotificationListener)this);
            CanonicalStyle style = (CanonicalStyle)view.getStyle(NotationPackage.Literals.CANONICAL_STYLE);
            if (style != null && style.eContainer() == view) {
                this.install(style);
            }
        }
    }

    private IGraphicalEditPart getOwner() {
        return this.owner;
    }

    private void install(CanonicalStyle style) {
        DiagramEventBroker broker = this.getDiagramEventBroker();
        broker.addNotificationListener((EObject)style, (EStructuralFeature)NotationPackage.Literals.CANONICAL_STYLE__CANONICAL, (NotificationListener)this);
    }

    private void uninstall() {
        DiagramEventBroker broker;
        View view = this.getOwner().getNotationView();
        CanonicalStyle style = (CanonicalStyle)view.getStyle(NotationPackage.Literals.CANONICAL_STYLE);
        if (style != null && style != view) {
            this.uninstall(style);
        }
        if ((broker = this.getDiagramEventBroker()) != null) {
            broker.removeNotificationListener((EObject)view, (Object)NotationPackage.Literals.VIEW__STYLES, (NotificationListener)this);
        }
    }

    private void uninstall(CanonicalStyle style) {
        DiagramEventBroker broker = this.getDiagramEventBroker();
        if (broker != null) {
            broker.removeNotificationListener((EObject)style, (Object)NotationPackage.Literals.CANONICAL_STYLE__CANONICAL, (NotificationListener)this);
        }
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        IGraphicalEditPart owner = this.getOwner();
        TransactionalEditingDomain domain = owner == null ? null : owner.getEditingDomain();
        return domain == null ? null : DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof CanonicalStyle && notification.getFeature() == NotationPackage.Literals.CANONICAL_STYLE__CANONICAL) {
            this.handleAdd((CanonicalStyle)notifier, null);
        } else if (notification.getFeature() == NotationPackage.Literals.VIEW__STYLES) {
            block0 : switch (notification.getEventType()) {
                case 3: {
                    if (!(notification.getNewValue() instanceof CanonicalStyle)) break;
                    this.internalHandleAdd((CanonicalStyle)notification.getNewValue());
                    break;
                }
                case 5: {
                    for (Object next : (Iterable)notification.getNewValue()) {
                        if (!(next instanceof CanonicalStyle)) continue;
                        this.internalHandleAdd((CanonicalStyle)next);
                        break block0;
                    }
                    break;
                }
                case 4: {
                    if (!(notification.getOldValue() instanceof CanonicalStyle)) break;
                    this.internalHandleRemove((CanonicalStyle)notification.getOldValue());
                    break;
                }
                case 6: {
                    for (Object next : (Iterable)notification.getOldValue()) {
                        if (!(next instanceof CanonicalStyle)) continue;
                        this.internalHandleRemove((CanonicalStyle)next);
                        break block0;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    CanonicalStyle removed;
                    CanonicalStyle added = notification.getNewValue() instanceof CanonicalStyle ? (CanonicalStyle)notification.getNewValue() : null;
                    CanonicalStyle canonicalStyle = removed = notification.getOldValue() instanceof CanonicalStyle ? (CanonicalStyle)notification.getOldValue() : null;
                    if (added != null) {
                        if (removed != null) {
                            this.uninstall(removed);
                        }
                        this.internalHandleAdd((CanonicalStyle)notification.getNewValue());
                        break;
                    }
                    if (!(notification.getOldValue() instanceof CanonicalStyle)) break;
                    this.internalHandleRemove((CanonicalStyle)notification.getOldValue());
                }
            }
        }
    }

    private void internalHandleAdd(CanonicalStyle style) {
        if (style.eContainer() == this.owner.getNotationView()) {
            this.install(style);
        }
        this.handleAdd(style, null);
    }

    void handleAdd(CanonicalStyle style, Predicate<? super Handler> filter) {
        if (!this.handlers.isEmpty()) {
            List<Handler> filtered = filter == null ? this.handlers : Iterables.filter(this.handlers, filter);
            for (Handler next : filtered) {
                Runnable update = next.handleAdd(style);
                if (update == null) continue;
                EditPartUtil.synchronizeRunnableToMainThread((IGraphicalEditPart)this.getOwner(), (Runnable)update);
            }
        }
    }

    private void internalHandleRemove(CanonicalStyle style) {
        this.uninstall(style);
        this.handleRemove(style, null);
    }

    void handleRemove(CanonicalStyle style, Predicate<? super Handler> filter) {
        if (!this.handlers.isEmpty()) {
            List<Handler> filtered = filter == null ? this.handlers : Iterables.filter(this.handlers, filter);
            for (Handler next : filtered) {
                Runnable update = next.handleRemove(style);
                if (update == null) continue;
                EditPartUtil.synchronizeRunnableToMainThread((IGraphicalEditPart)this.getOwner(), (Runnable)update);
            }
        }
    }

    void pokeHandlers(Handler requestor, boolean enabled) {
        View view = this.owner.getNotationView();
        if (view != null) {
            CanonicalStyle style = (CanonicalStyle)view.getStyle(NotationPackage.Literals.CANONICAL_STYLE);
            if (style == null) {
                if (!enabled) {
                    CanonicalStyle fakeStyle = NotationFactory.eINSTANCE.createCanonicalStyle();
                    this.handleRemove(fakeStyle, CanonicalStateListener.not(requestor));
                }
            } else if (style.eContainer() == null && enabled) {
                this.handleAdd(style, CanonicalStateListener.not(requestor));
            }
        }
    }

    private static Predicate<Object> not(final Object excluded) {
        return excluded == null ? null : new Predicate<Object>(){

            public boolean apply(Object input) {
                return input != excluded;
            }
        };
    }

    public static interface Handler {
        public Runnable handleAdd(CanonicalStyle var1);

        public Runnable handleRemove(CanonicalStyle var1);
    }
}

