/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.transition;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.uml.tools.helper.EventCreationHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;

public class SignalOrReceptionAsTriggerToTransitionDropStrategy
extends TransactionalDropStrategy {
    protected boolean understandRequest(Request request) {
        return request instanceof DropObjectsRequest;
    }

    protected boolean isTransitionEditPart(EditPart ep) {
        if (!(ep instanceof GraphicalEditPart)) {
            return false;
        }
        EObject targetSemantic = this.getTargetSemanticElement(ep);
        return targetSemantic instanceof Transition;
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if (this.understandRequest(request) && this.isTransitionEditPart(targetEditPart)) {
            List sourceEObjects = this.getSourceEObjects(request);
            if (sourceEObjects.size() != 1) {
                return null;
            }
            if (!(sourceEObjects.get(0) instanceof Signal) && !(sourceEObjects.get(0) instanceof Reception)) {
                return null;
            }
            Signal draggedSignal = null;
            if (sourceEObjects.get(0) instanceof Signal) {
                draggedSignal = (Signal)sourceEObjects.get(0);
            } else if (sourceEObjects.get(0) instanceof Reception) {
                draggedSignal = ((Reception)sourceEObjects.get(0)).getSignal();
            }
            final Signal signal = draggedSignal;
            final Transition transition = (Transition)this.getTargetSemanticElement(targetEditPart);
            return new Command(){

                public void execute() {
                    if (transition != null && signal != null) {
                        SignalEvent signalEvent;
                        Package pkg;
                        Trigger trigger2;
                        for (Trigger trigger2 : transition.getTriggers()) {
                            if (!(trigger2.getEvent() instanceof SignalEvent) || ((SignalEvent)trigger2.getEvent()).getSignal() != signal) continue;
                            return;
                        }
                        trigger2 = transition.createTrigger("");
                        EventCreationHelper helper = new EventCreationHelper(transition);
                        if (trigger2 != null && (pkg = transition.getNearestPackage()) != null && (signalEvent = helper.getOrCreateSignalEvent(signal, false)) != null) {
                            signalEvent.setSignal(signal);
                            trigger2.setEvent((Event)signalEvent);
                        }
                    }
                }
            };
        }
        return null;
    }

    public String getLabel() {
        return "Drop signal as trigger with signal event";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.dnd.SignalAsTriggerToTransitionDrop";
    }

    public String getDescription() {
        return "Drops a signal into a transition as a trigger with a signal event";
    }

    public String getCategoryID() {
        return "org.eclipse.papyrus.dnd.SignalAsTriggerToTransitionDrop";
    }

    public String getCategoryLabel() {
        return "Drop a signal into a transition as a trigger with a signal event";
    }

    public Image getImage() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public void setOptions(Map<String, Object> options) {
    }
}

