/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.providers;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.papyrus.uml.diagram.clazz.custom.parsers.CustomMessageFormatParser;
import org.eclipse.papyrus.uml.diagram.clazz.custom.parsers.OperationParser;
import org.eclipse.papyrus.uml.diagram.clazz.custom.parsers.PropertyParser;
import org.eclipse.papyrus.uml.diagram.clazz.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLParserProvider;
import org.eclipse.papyrus.uml.diagram.common.parser.custom.AssociationEndParser;
import org.eclipse.papyrus.uml.diagram.common.parser.custom.AssociationMultiplicityParser;
import org.eclipse.papyrus.uml.diagram.common.parser.stereotype.AppliedKeywordParser;
import org.eclipse.papyrus.uml.diagram.common.parser.stereotype.AppliedStereotypeParser;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomUMLParserProvider
extends UMLParserProvider {
    private static final int ASSOCIATION_SOURCE = 0;
    private static final int ASSOCIATION_TARGET = 1;

    protected IParser getAppliedStereotypeParser() {
        return new AppliedStereotypeParser();
    }

    protected IParser getAppliedStereotypeParser(String defaultPrintString) {
        return new AppliedStereotypeParser(defaultPrintString);
    }

    protected IParser getAppliedKeywordParser(String defaultPrintString) {
        return new AppliedKeywordParser(defaultPrintString);
    }

    protected IParser getAssociationBranchRole() {
        EAttribute[] features = new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()};
        CustomMessageFormatParser parser = new CustomMessageFormatParser(features, (EStructuralFeature)UMLPackage.eINSTANCE.getAssociation_MemberEnd(), 0);
        return parser;
    }

    protected IParser getAssociationNameParser() {
        EAttribute[] features = new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()};
        MessageFormatParser parser = new MessageFormatParser(features);
        return parser;
    }

    protected IParser getAssociationSourceMultiplicityParser() {
        return new AssociationMultiplicityParser(0);
    }

    protected IParser getAssociationSourceRoleParser() {
        return new AssociationEndParser(0);
    }

    protected IParser getAssociationTargetMultiplicity() {
        return new AssociationMultiplicityParser(1);
    }

    protected IParser getAssociationTargetRoleParser() {
        return new AssociationEndParser(1);
    }

    protected IParser getCustomPropertyParser() {
        return new PropertyParser();
    }

    private IParser getOperationParser() {
        OperationParser operationParser = new OperationParser();
        return operationParser;
    }

    @Override
    protected IParser getParser(String visualID) {
        switch (visualID) {
            case "Property_ComponentAttributeLabel": {
                return this.getCustomPropertyParser();
            }
            case "Operation_ComponentOperationLabel": {
                return this.getOperationParser();
            }
            case "Property_SignalAttributeLabel": {
                return this.getCustomPropertyParser();
            }
            case "Property_InterfaceAttributeLabel": {
                return this.getCustomPropertyParser();
            }
            case "Operation_InterfaceOperationLabel": {
                return this.getOperationParser();
            }
            case "Property_ClassAttributeLabel": {
                return this.getCustomPropertyParser();
            }
            case "Operation_ClassOperationLabel": {
                return this.getOperationParser();
            }
            case "Property_DataTypeAttributeLabel": {
                return this.getCustomPropertyParser();
            }
            case "Operation_DataTypeOperationLabel": {
                return this.getOperationParser();
            }
            case "Association_NameLabel": {
                return this.getAssociationNameParser();
            }
            case "Association_TargetRoleLabel": {
                return this.getAssociationTargetRoleParser();
            }
            case "Association_SourceRoleLabel": {
                return this.getAssociationSourceMultiplicityParser();
            }
            case "Association_BranchRoleLabel": {
                return this.getAssociationSourceRoleParser();
            }
            case "Association_BranchMultiplicityLabel": {
                return this.getAssociationSourceMultiplicityParser();
            }
            case "Association_StereotypeLabel": {
                return this.getAppliedStereotypeParser();
            }
            case "Generalization_StereotypeLabel": {
                return this.getAppliedStereotypeParser();
            }
            case "InterfaceRealization_StereotypeLabel": {
                return this.getAppliedStereotypeParser();
            }
            case "Substitution_StereotypeLabel": {
                return this.getAppliedKeywordParser("substitute");
            }
            case "Realization_StereotypeLabel": {
                return this.getAppliedStereotypeParser();
            }
            case "Abstraction_StereotypeLabel": {
                return this.getAppliedKeywordParser("abstraction");
            }
            case "Usage_StereotypeLabel": {
                return this.getAppliedKeywordParser("use");
            }
            case "Dependency_StereotypeLabel": {
                return this.getAppliedStereotypeParser();
            }
            case "ElementImport_StereotypeLabel": {
                return this.getAppliedKeywordParser("import");
            }
            case "PackageImport_StereotypeLabel": {
                return this.getAppliedStereotypeParser();
            }
            case "InformationFlow_StereotypeLabel": {
                return this.getAppliedKeywordParser("flow");
            }
            case "Constraint_KeywordLabel": {
                return this.getAppliedStereotypeParser("context");
            }
            case "PackageMerge_StereotypeLabel": {
                return this.getAppliedKeywordParser("merge");
            }
        }
        return super.getParser(visualID);
    }
}

