/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation;

import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation.Activator;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class ImageProvider {
    private static ImageProvider instance;
    private Image linkIcon = null;
    private Image linkUniDirIcon = null;
    private Image linkFacetIcon = null;
    private Image aggregIcon = null;
    private Image aggregUniDirIcon = null;
    private Image invAggregIcon = null;
    private Image emptyLinksIcon = null;
    private Image sortLinksIcon = null;
    private Image sortLinksByTypeIcon = null;
    private Image showDerivedLinksIcon = null;
    private Image showFullQualifiedNamesIcon = null;
    private Image showMultiplicityIcon = null;
    private Image showOppositeLinksIcon = null;
    private Image rangeIcon = null;
    private Image containerIcon = null;
    private Image packageIcon = null;
    private Image attributeIcon = null;
    private Image attributeFacetIcon = null;
    private Image emptyAttributeIcon = null;
    private Image orderingIcon = null;
    private Image linkTypeIcon = null;
    private Image facetIcon = null;
    private Image viewMenuIcon = null;
    private ImageDescriptor increaseFontSizeIcon = null;
    private ImageDescriptor decreaseFontSizeIcon = null;
    private ImageDescriptor restoreFontSizeIcon = null;
    private Image hideEmptyColumnsIcon = null;
    private Image commonColumnsIcon = null;
    private Image eClassIcon = null;
    private Image operationIcon = null;
    private Image predicateIcon = null;
    private Image emffacetIcon = null;
    private Image featureIcon = null;
    private Image errorIcon = null;
    private Image queryIcon = null;
    private Image uiCustomIcon = null;
    private Image grayedUiCustomIcon = null;
    private Image uriIcon = null;
    private Image shortcutIcon = null;
    private Image topLeftOverlay = null;
    private Image topMiddleOverlay = null;
    private Image topRightOverlay = null;
    private Image middleLeftOverlay = null;
    private Image middleRightOverlay = null;
    private Image bottomLeftOverlay = null;
    private Image bottomMiddleOverlay = null;
    private Image bottomRightOverlay = null;
    private Image customizationLabel = null;
    private Image customizationImage = null;
    private Image rgb = null;
    private Image fontName = null;
    private Image fontSize = null;
    private Image isBold = null;
    private Image isItalic = null;
    private Image isUnderlined = null;
    private Image isStruckthrough = null;
    private static final String LINK_ICON_PATH = "/icons/full/ctool16/link.gif";
    private static final String LINK_UNIDIR_ICON_PATH = "/icons/full/ctool16/link_unidir.gif";
    private static final String LINK_FACET_ICON_PATH = "/icons/full/ctool16/link_unidir_facet.gif";
    private static final String AGGREG_ICON_PATH = "/icons/full/ctool16/aggreg.gif";
    private static final String AGGREG_UNIDIR_ICON_PATH = "/icons/full/ctool16/aggreg_unidir.gif";
    private static final String INV_AGGREG_ICON_PATH = "/icons/full/ctool16/inv_aggreg.gif";
    private static final String EMPTY_LINKS_ICON_PATH = "/icons/full/ctool16/empty_links.gif";
    private static final String SORT_INSTANCES_ICON_PATH = "/icons/full/ctool16/sort.gif";
    private static final String SORT_LINKS_ICON_PATH = "/icons/full/ctool16/sort_links.gif";
    private static final String SORT_LINKS_BY_TYPE_ICON_PATH = "/icons/full/ctool16/sort_links_by_type.gif";
    private static final String SORT_NUMERICALLY_ICON_PATH = "/icons/full/ctool16/sort_num.gif";
    private static final String SHOW_DERIVED_LINKS_ICON_PATH = "/icons/full/ctool16/derived.gif";
    private static final String SHOW_FULL_QUALIFIED_NAMES_ICON_PATH = "/icons/full/ctool16/full_name.gif";
    private static final String RANGE_ICON_PATH = "/icons/full/ctool16/range.gif";
    private static final String SHOW_MULTIPLICITY_ICON_PATH = "/icons/full/ctool16/multiplicity.gif";
    private static final String SHOW_OPPOSITE_LINKS_ICON_PATH = "/icons/full/ctool16/opposite_links.gif";
    private static final String CONTAINER_ICON_PATH = "/icons/full/ctool16/container.gif";
    private static final String EMPTY_METACLASSES_ICON_PATH = "/icons/full/ctool16/zero.gif";
    private static final String PACKAGE_ICON_PATH = "/icons/full/ctool16/package.gif";
    private static final String DERIVED_INSTANCES_ICON_PATH = "/icons/full/ctool16/derived_instances.gif";
    private static final String DERIVATION_TREE_ICON_PATH = "/icons/full/ctool16/derivation_tree.gif";
    private static final String ATTRIBUTE_ICON_PATH = "/icons/full/ctool16/attributes.gif";
    private static final String ATTRIBUTE_FACET_ICON_PATH = "/icons/full/ctool16/attribute_facet.gif";
    private static final String EMPTY_ATTRIBUTE_ICON_PATH = "/icons/full/ctool16/empty_attributes.gif";
    private static final String INCREASE_FONT_SIZE_ICON_PATH = "/icons/full/ctool16/increase_font_size.gif";
    private static final String DECREASE_FONT_SIZE_ICON_PATH = "/icons/full/ctool16/decrease_font_size.gif";
    private static final String RESTORE_FONT_SIZE_ICON_PATH = "/icons/full/ctool16/restore_font_size.gif";
    private static final String HIDE_EMPTY_COLUMNS_ICON_PATH = "/icons/full/ctool16/non-zero.gif";
    private static final String COMMON_COLUMNS_ICON_PATH = "/icons/full/ctool16/common_columns.gif";
    private static final String ORDERING_ICON_PATH = "/icons/full/ctool16/ordering.gif";
    private static final String ECLASS_ICON_PATH = "/icons/full/ctool16/eClass.gif";
    private static final String OPERATION_ICON_PATH = "/icons/full/ctool16/operation.gif";
    private static final String PREDICATE_ICON_PATH = "/icons/full/ctool16/predicate.gif";
    private static final String EMFFACET_ICON_PATH = "icons/logoEmfFacetMini.gif";
    private static final String FEATURE_ICON_PATH = "icons/full/ctool16/feature.gif";
    private static final String ERROR_ICON_PATH = "icons/error.gif";
    private static final String FACET_ICON_PATH = "icons/Facet.gif";
    private static final String ADD_UI_CUSTOM_ICON_PATH = "icons/full/ctool16/addUiCustom.gif";
    private static final String VIEW_MENU_ICON_PATH = "icons/full/ctool16/view_menu.gif";
    private static final String LINK_TYPE_ICON_PATH = "icons/full/ctool16/link_type.gif";
    private static final String QUERY_ICON_PATH = "icons/query.png";
    private static final String ELEMENT_IDS_ICON_PATH = "/icons/full/ctool16/element_id.gif";
    private static final String URI_ICON_PATH = "/icons/full/ctool16/uri.gif";
    private static final String COLLAPSE_ALL_ICON_PATH = "/icons/full/ctool16/collapseall.gif";
    private static final String SHORTCUT_ICON_PATH = "/icons/shortcut.png";
    private static final String TOP_LEFT_OVERLAY_ICON_PATH = "/icons/full/ctool16/topLeftOverlay.png";
    private static final String TOP_MIDDLE_OVERLAY_ICON_PATH = "/icons/full/ctool16/topMiddleOverlay.png";
    private static final String TOP_RIGHT_OVERLAY_ICON_PATH = "/icons/full/ctool16/topRightOverlay.png";
    private static final String MIDDLE_LEFT_OVERLAY_ICON_PATH = "/icons/full/ctool16/middleLeftOverlay.png";
    private static final String MIDDLE_RIGHT_OVERLAY_ICON_PATH = "/icons/full/ctool16/middleRightOverlay.png";
    private static final String BOTTOM_LEFT_OVERLAY_ICON_PATH = "/icons/full/ctool16/bottomLeftOverlay.png";
    private static final String BOTTOM_MIDDLE_OVERLAY_ICON_PATH = "/icons/full/ctool16/bottomMiddleOverlay.png";
    private static final String BOTTOM_RIGHT_OVERLAY_ICON_PATH = "/icons/full/ctool16/bottomRightOverlay.png";
    private static final String LABEL_CUSTOMIZATION = "/icons/full/ctool16/customizationLabel.png";
    private static final String IMAGE_CUSTOMIZATION = "/icons/full/ctool16/imageCustomization.png";
    private static final String RGB_CUSTOMIZATION = "/icons/full/ctool16/rgb.png";
    private static final String FONT_NAME = "/icons/full/ctool16/fontName.png";
    private static final String FONT_SIZE = "/icons/full/ctool16/fontSize.png";
    private static final String IS_BOLD = "/icons/full/ctool16/fontBold.png";
    private static final String IS_ITALIC = "/icons/full/ctool16/fontItalic.bmp";
    private static final String IS_UNDERLINED = "/icons/full/ctool16/fontUnderline.bmp";
    private static final String IS_STRUCKTHROUGH = "/icons/full/ctool16/fontStrukethrough.bmp";

    private ImageProvider() {
    }

    public static ImageProvider getInstance() {
        if (instance == null) {
            instance = new ImageProvider();
        }
        return instance;
    }

    private ImageDescriptor createImageDescriptor(String resourcePath) {
        URL url = Activator.getDefault().getBundle().getResource(resourcePath);
        if (url == null) {
            Logger.logError((String)NLS.bind((String)"Resource not found: {0}", (Object)resourcePath), (Plugin)Activator.getDefault());
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public Image getLinkIcon() {
        if (this.linkIcon == null) {
            this.linkIcon = this.createImageDescriptor(LINK_ICON_PATH).createImage();
        }
        return this.linkIcon;
    }

    public Image getUnidirectionalLinkIcon() {
        if (this.linkUniDirIcon == null) {
            this.linkUniDirIcon = this.createImageDescriptor(LINK_UNIDIR_ICON_PATH).createImage();
        }
        return this.linkUniDirIcon;
    }

    public Image getFacetLinkIcon() {
        if (this.linkFacetIcon == null) {
            this.linkFacetIcon = this.createImageDescriptor(LINK_FACET_ICON_PATH).createImage();
        }
        return this.linkFacetIcon;
    }

    public Image getAggregIcon() {
        if (this.aggregIcon == null) {
            this.aggregIcon = this.createImageDescriptor(AGGREG_ICON_PATH).createImage();
        }
        return this.aggregIcon;
    }

    public Image getUnidirectionalAggregIcon() {
        if (this.aggregUniDirIcon == null) {
            this.aggregUniDirIcon = this.createImageDescriptor(AGGREG_UNIDIR_ICON_PATH).createImage();
        }
        return this.aggregUniDirIcon;
    }

    public Image getInvAggregIcon() {
        if (this.invAggregIcon == null) {
            this.invAggregIcon = this.createImageDescriptor(INV_AGGREG_ICON_PATH).createImage();
        }
        return this.invAggregIcon;
    }

    public Image getEmptyLinksIcon() {
        if (this.emptyLinksIcon == null) {
            this.emptyLinksIcon = this.createImageDescriptor(EMPTY_LINKS_ICON_PATH).createImage();
        }
        return this.emptyLinksIcon;
    }

    public ImageDescriptor getEmptyLinksImageDescriptor() {
        return this.createImageDescriptor(EMPTY_LINKS_ICON_PATH);
    }

    public ImageDescriptor getSortInstancesIcon() {
        return this.createImageDescriptor(SORT_INSTANCES_ICON_PATH);
    }

    public Image getSortLinksIcon() {
        if (this.sortLinksIcon == null) {
            this.sortLinksIcon = this.createImageDescriptor(SORT_LINKS_ICON_PATH).createImage();
        }
        return this.sortLinksIcon;
    }

    public ImageDescriptor getSortLinksImageDescriptor() {
        return this.createImageDescriptor(SORT_LINKS_ICON_PATH);
    }

    public Image getSortLinksByTypeIcon() {
        if (this.sortLinksByTypeIcon == null) {
            this.sortLinksByTypeIcon = this.createImageDescriptor(SORT_LINKS_BY_TYPE_ICON_PATH).createImage();
        }
        return this.sortLinksByTypeIcon;
    }

    public ImageDescriptor getSortLinksByTypeImageDescriptor() {
        return this.createImageDescriptor(SORT_LINKS_BY_TYPE_ICON_PATH);
    }

    public ImageDescriptor getSortNumericallyIcon() {
        return this.createImageDescriptor(SORT_NUMERICALLY_ICON_PATH);
    }

    public Image getShowDerivedLinksIcon() {
        if (this.showDerivedLinksIcon == null) {
            this.showDerivedLinksIcon = this.createImageDescriptor(SHOW_DERIVED_LINKS_ICON_PATH).createImage();
        }
        return this.showDerivedLinksIcon;
    }

    public ImageDescriptor getShowDerivedLinksImageDescriptor() {
        return this.createImageDescriptor(SHOW_DERIVED_LINKS_ICON_PATH);
    }

    public Image getShowFullQualifiedNamesIcon() {
        if (this.showFullQualifiedNamesIcon == null) {
            this.showFullQualifiedNamesIcon = this.createImageDescriptor(SHOW_FULL_QUALIFIED_NAMES_ICON_PATH).createImage();
        }
        return this.showFullQualifiedNamesIcon;
    }

    public ImageDescriptor getShowFullQualifiedNamesImageDescriptor() {
        return this.createImageDescriptor(SHOW_FULL_QUALIFIED_NAMES_ICON_PATH);
    }

    public Image getRangeIcon() {
        if (this.rangeIcon == null) {
            this.rangeIcon = this.createImageDescriptor(RANGE_ICON_PATH).createImage();
        }
        return this.rangeIcon;
    }

    public Image getShowMultiplicityIcon() {
        if (this.showMultiplicityIcon == null) {
            this.showMultiplicityIcon = this.createImageDescriptor(SHOW_MULTIPLICITY_ICON_PATH).createImage();
        }
        return this.showMultiplicityIcon;
    }

    public ImageDescriptor getShowMultiplicityImageDescriptor() {
        return this.createImageDescriptor(SHOW_MULTIPLICITY_ICON_PATH);
    }

    public Image getShowOppositeLinksIcon() {
        if (this.showOppositeLinksIcon == null) {
            this.showOppositeLinksIcon = this.createImageDescriptor(SHOW_OPPOSITE_LINKS_ICON_PATH).createImage();
        }
        return this.showOppositeLinksIcon;
    }

    public ImageDescriptor getShowOppositeLinksImageDescriptor() {
        return this.createImageDescriptor(SHOW_OPPOSITE_LINKS_ICON_PATH);
    }

    public Image getContainerIcon() {
        if (this.containerIcon == null) {
            this.containerIcon = this.createImageDescriptor(CONTAINER_ICON_PATH).createImage();
        }
        return this.containerIcon;
    }

    public ImageDescriptor getContainerImageDescriptor() {
        return this.createImageDescriptor(CONTAINER_ICON_PATH);
    }

    public ImageDescriptor getShowEmptyMetaclassesIcon() {
        return this.createImageDescriptor(EMPTY_METACLASSES_ICON_PATH);
    }

    public Image getPackageIcon() {
        if (this.packageIcon == null) {
            this.packageIcon = this.createImageDescriptor(PACKAGE_ICON_PATH).createImage();
        }
        return this.packageIcon;
    }

    public ImageDescriptor getPackageImageDescriptor() {
        return this.createImageDescriptor(PACKAGE_ICON_PATH);
    }

    public ImageDescriptor getDerivedInstancesImageDescriptor() {
        return this.createImageDescriptor(DERIVED_INSTANCES_ICON_PATH);
    }

    public ImageDescriptor getDerivationTreeIcon() {
        return this.createImageDescriptor(DERIVATION_TREE_ICON_PATH);
    }

    public Image getAttributeIcon() {
        if (this.attributeIcon == null) {
            this.attributeIcon = this.createImageDescriptor(ATTRIBUTE_ICON_PATH).createImage();
        }
        return this.attributeIcon;
    }

    public ImageDescriptor getAttributeImageDescriptor() {
        return this.createImageDescriptor(ATTRIBUTE_ICON_PATH);
    }

    public Image getFacetAttributeIcon() {
        if (this.attributeFacetIcon == null) {
            this.attributeFacetIcon = this.createImageDescriptor(ATTRIBUTE_FACET_ICON_PATH).createImage();
        }
        return this.attributeFacetIcon;
    }

    public Image getEmptyAttributeIcon() {
        if (this.emptyAttributeIcon == null) {
            this.emptyAttributeIcon = this.createImageDescriptor(EMPTY_ATTRIBUTE_ICON_PATH).createImage();
        }
        return this.emptyAttributeIcon;
    }

    public ImageDescriptor getEmptyAttributeImageDescriptor() {
        return this.createImageDescriptor(EMPTY_ATTRIBUTE_ICON_PATH);
    }

    public ImageDescriptor getIncreaseFontSizeIcon() {
        if (this.increaseFontSizeIcon == null) {
            this.increaseFontSizeIcon = this.createImageDescriptor(INCREASE_FONT_SIZE_ICON_PATH);
        }
        return this.increaseFontSizeIcon;
    }

    public ImageDescriptor getDecreaseFontSizeIcon() {
        if (this.decreaseFontSizeIcon == null) {
            this.decreaseFontSizeIcon = this.createImageDescriptor(DECREASE_FONT_SIZE_ICON_PATH);
        }
        return this.decreaseFontSizeIcon;
    }

    public ImageDescriptor getRestoreFontSizeIcon() {
        if (this.restoreFontSizeIcon == null) {
            this.restoreFontSizeIcon = this.createImageDescriptor(RESTORE_FONT_SIZE_ICON_PATH);
        }
        return this.restoreFontSizeIcon;
    }

    public Image getHideEmptyColumnsIcon() {
        if (this.hideEmptyColumnsIcon == null) {
            this.hideEmptyColumnsIcon = this.createImageDescriptor(HIDE_EMPTY_COLUMNS_ICON_PATH).createImage();
        }
        return this.hideEmptyColumnsIcon;
    }

    public Image getCommonColumnsIcon() {
        if (this.commonColumnsIcon == null) {
            this.commonColumnsIcon = this.createImageDescriptor(COMMON_COLUMNS_ICON_PATH).createImage();
        }
        return this.commonColumnsIcon;
    }

    public Image getOrderingIcon() {
        if (this.orderingIcon == null) {
            this.orderingIcon = this.createImageDescriptor(ORDERING_ICON_PATH).createImage();
        }
        return this.orderingIcon;
    }

    public ImageDescriptor getOrderingImageDescriptor() {
        return this.createImageDescriptor(ORDERING_ICON_PATH);
    }

    public Image getEClassIcon() {
        if (this.eClassIcon == null) {
            this.eClassIcon = this.createImageDescriptor(ECLASS_ICON_PATH).createImage();
        }
        return this.eClassIcon;
    }

    public Image getOperationIcon() {
        if (this.operationIcon == null) {
            this.operationIcon = this.createImageDescriptor(OPERATION_ICON_PATH).createImage();
        }
        return this.operationIcon;
    }

    public Image getPredicateIcon() {
        if (this.predicateIcon == null) {
            this.predicateIcon = this.createImageDescriptor(PREDICATE_ICON_PATH).createImage();
        }
        return this.predicateIcon;
    }

    public Image getEmfFacetIcon() {
        if (this.emffacetIcon == null) {
            this.emffacetIcon = this.createImageDescriptor(EMFFACET_ICON_PATH).createImage();
        }
        return this.emffacetIcon;
    }

    public Image getFeatureIcon() {
        if (this.featureIcon == null) {
            this.featureIcon = this.createImageDescriptor(FEATURE_ICON_PATH).createImage();
        }
        return this.featureIcon;
    }

    public ImageDescriptor getFeatureIconDescriptor() {
        return this.createImageDescriptor(FEATURE_ICON_PATH);
    }

    public ImageDescriptor getFacetIconDescriptor() {
        return this.createImageDescriptor(FACET_ICON_PATH);
    }

    public Image getFacetIcon() {
        if (this.facetIcon == null) {
            this.facetIcon = this.createImageDescriptor(FACET_ICON_PATH).createImage();
        }
        return this.facetIcon;
    }

    public ImageDescriptor getAddUiCustomIconDescriptor() {
        return this.createImageDescriptor(ADD_UI_CUSTOM_ICON_PATH);
    }

    public Image getUiCustomIcon() {
        if (this.uiCustomIcon == null) {
            this.uiCustomIcon = this.createImageDescriptor(ADD_UI_CUSTOM_ICON_PATH).createImage();
        }
        return this.uiCustomIcon;
    }

    public Image getGrayedUiCustomIcon() {
        if (this.grayedUiCustomIcon == null) {
            this.grayedUiCustomIcon = new Image((Device)Display.getCurrent(), this.getUiCustomIcon(), 2);
        }
        return this.grayedUiCustomIcon;
    }

    public Image getErrorIcon() {
        if (this.errorIcon == null) {
            this.errorIcon = this.createImageDescriptor(ERROR_ICON_PATH).createImage();
        }
        return this.errorIcon;
    }

    public Image getViewMenuIcon() {
        if (this.viewMenuIcon == null) {
            this.viewMenuIcon = this.createImageDescriptor(VIEW_MENU_ICON_PATH).createImage();
        }
        return this.viewMenuIcon;
    }

    public Image getQueryIcon() {
        if (this.queryIcon == null) {
            this.queryIcon = this.createImageDescriptor(QUERY_ICON_PATH).createImage();
        }
        return this.queryIcon;
    }

    public Image getLinkTypeIcon() {
        if (this.linkTypeIcon == null) {
            this.linkTypeIcon = this.createImageDescriptor(LINK_TYPE_ICON_PATH).createImage();
        }
        return this.linkTypeIcon;
    }

    public ImageDescriptor getLinkTypeIconDescriptor() {
        return this.createImageDescriptor(LINK_TYPE_ICON_PATH);
    }

    public ImageDescriptor getShowElementIDsDescriptor() {
        return this.createImageDescriptor(ELEMENT_IDS_ICON_PATH);
    }

    public ImageDescriptor getShowURIDescriptor() {
        return this.createImageDescriptor(URI_ICON_PATH);
    }

    public Image getURIIcon() {
        if (this.uriIcon == null) {
            this.uriIcon = this.createImageDescriptor(URI_ICON_PATH).createImage();
        }
        return this.uriIcon;
    }

    public ImageDescriptor getCollapseAllDescriptor() {
        return this.createImageDescriptor(COLLAPSE_ALL_ICON_PATH);
    }

    public Image getShortcutIcon() {
        if (this.shortcutIcon == null) {
            this.shortcutIcon = this.createImageDescriptor(SHORTCUT_ICON_PATH).createImage();
        }
        return this.shortcutIcon;
    }

    public Image getTopLeftOverlayIcon() {
        if (this.topLeftOverlay == null) {
            this.topLeftOverlay = this.createImageDescriptor(TOP_LEFT_OVERLAY_ICON_PATH).createImage();
        }
        return this.topLeftOverlay;
    }

    public Image getTopMiddleOverlayIcon() {
        if (this.topMiddleOverlay == null) {
            this.topMiddleOverlay = this.createImageDescriptor(TOP_MIDDLE_OVERLAY_ICON_PATH).createImage();
        }
        return this.topMiddleOverlay;
    }

    public Image getTopRightOverlayIcon() {
        if (this.topRightOverlay == null) {
            this.topRightOverlay = this.createImageDescriptor(TOP_RIGHT_OVERLAY_ICON_PATH).createImage();
        }
        return this.topRightOverlay;
    }

    public Image getMiddleLeftOverlayIcon() {
        if (this.middleLeftOverlay == null) {
            this.middleLeftOverlay = this.createImageDescriptor(MIDDLE_LEFT_OVERLAY_ICON_PATH).createImage();
        }
        return this.middleLeftOverlay;
    }

    public Image getMiddleRightOverlayIcon() {
        if (this.middleRightOverlay == null) {
            this.middleRightOverlay = this.createImageDescriptor(MIDDLE_RIGHT_OVERLAY_ICON_PATH).createImage();
        }
        return this.middleRightOverlay;
    }

    public Image getBottomLeftOverlayIcon() {
        if (this.bottomLeftOverlay == null) {
            this.bottomLeftOverlay = this.createImageDescriptor(BOTTOM_LEFT_OVERLAY_ICON_PATH).createImage();
        }
        return this.bottomLeftOverlay;
    }

    public Image getBottomMiddleOverlayIcon() {
        if (this.bottomMiddleOverlay == null) {
            this.bottomMiddleOverlay = this.createImageDescriptor(BOTTOM_MIDDLE_OVERLAY_ICON_PATH).createImage();
        }
        return this.bottomMiddleOverlay;
    }

    public Image getBottomRightOverlayIcon() {
        if (this.bottomRightOverlay == null) {
            this.bottomRightOverlay = this.createImageDescriptor(BOTTOM_RIGHT_OVERLAY_ICON_PATH).createImage();
        }
        return this.bottomRightOverlay;
    }

    public Image getCustomizationLabelIcon() {
        if (this.customizationLabel == null) {
            this.customizationLabel = this.createImageDescriptor(LABEL_CUSTOMIZATION).createImage();
        }
        return this.customizationLabel;
    }

    public Image getCustomizationImageIcon() {
        if (this.customizationImage == null) {
            this.customizationImage = this.createImageDescriptor(IMAGE_CUSTOMIZATION).createImage();
        }
        return this.customizationImage;
    }

    public Image getCustomizationColorIcon() {
        if (this.rgb == null) {
            this.rgb = this.createImageDescriptor(RGB_CUSTOMIZATION).createImage();
        }
        return this.rgb;
    }

    public Image getFontNameIcon() {
        if (this.fontName == null) {
            this.fontName = this.createImageDescriptor(FONT_NAME).createImage();
        }
        return this.fontName;
    }

    public Image getFontSizeIcon() {
        if (this.fontSize == null) {
            this.fontSize = this.createImageDescriptor(FONT_SIZE).createImage();
        }
        return this.fontSize;
    }

    public Image getIsBoldIcon() {
        if (this.isBold == null) {
            this.isBold = this.createImageDescriptor(IS_BOLD).createImage();
        }
        return this.isBold;
    }

    public Image getIsItalicIcon() {
        if (this.isItalic == null) {
            this.isItalic = this.createImageDescriptor(IS_ITALIC).createImage();
        }
        return this.isItalic;
    }

    public Image getIsUnderlinedIcon() {
        if (this.isUnderlined == null) {
            this.isUnderlined = this.createImageDescriptor(IS_UNDERLINED).createImage();
        }
        return this.isUnderlined;
    }

    public Image getIsStrukethroughIcon() {
        if (this.isStruckthrough == null) {
            this.isStruckthrough = this.createImageDescriptor(IS_STRUCKTHROUGH).createImage();
        }
        return this.isStruckthrough;
    }
}

