/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.LabelHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;

public class BehaviorPropertyNodeEditPolicy
extends NonResizableEditPolicyEx {
    private PolylineShape linkFeedback = null;

    protected List createSelectionHandles() {
        MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
        mh.setBorder(null);
        return Collections.singletonList(mh);
    }

    public void eraseSourceFeedback(Request request) {
        if ("move".equals(request.getType()) && this.isDragAllowed() || "clone".equals(request.getType()) || "add children".equals(request.getType()) || "drop".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    public void showSourceFeedback(Request request) {
        if ("move".equals(request.getType()) && this.isDragAllowed() || "add children".equals(request.getType()) || "clone".equals(request.getType()) || "drop".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        this.getHostFigure().translateToRelative((Translatable)rect);
        if (this.getHost() instanceof IBorderItemEditPart) {
            IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
            IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
            if (borderItemLocator != null) {
                Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
                Point parentOrigin = borderItemEP.getFigure().getParent().getBounds().getTopLeft();
                Dimension d = realLocation.getTopLeft().getDifference(parentOrigin);
                Point location = new Point(d.width, d.height);
                SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), location);
                return new ICommandProxy((ICommand)moveCommand);
            }
        } else if (this.getHost() instanceof LabelEditPart) {
            LabelEditPart editPart = (LabelEditPart)this.getHost();
            Point refPoint = editPart.getReferencePoint();
            Point normalPoint = LabelHelper.offsetFromRelativeCoordinate((IFigure)this.getHostFigure(), (Rectangle)rect, (Point)refPoint);
            SetBoundsCommand moveCommand = new SetBoundsCommand(editPart.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)editPart.getModel())), normalPoint);
            return new ICommandProxy((ICommand)moveCommand);
        }
        return null;
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        return null;
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        if (this.linkFeedback != null) {
            this.removeFeedback((IFigure)this.linkFeedback);
        }
        this.linkFeedback = null;
    }

    protected IFigure createDragSourceFeedbackFigure() {
        IFigure feedback = super.createDragSourceFeedbackFigure();
        this.linkFeedback = new PolylineShape();
        this.linkFeedback.setLineWidth(1);
        this.linkFeedback.setLineStyle(4);
        this.linkFeedback.setForegroundColor(((IGraphicalEditPart)this.getHost()).getFigure().getForegroundColor());
        this.addFeedback((IFigure)this.linkFeedback);
        return feedback;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.getHost() instanceof IBorderItemEditPart) {
            IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
            IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
            if (borderItemLocator != null) {
                IFigure feedback = this.getDragSourceFeedbackFigure();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                this.getHostFigure().translateToRelative((Translatable)rect);
                Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
                this.getHostFigure().translateToAbsolute((Translatable)realLocation);
                feedback.translateToRelative((Translatable)realLocation);
                feedback.setBounds(realLocation);
            }
        } else {
            super.showChangeBoundsFeedback(request);
        }
        IFigure p = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        p.translateToRelative((Translatable)rect);
        p.setBounds((Rectangle)rect);
        Point referencePoint = this.getReferencePoint(request);
        Point end = this.getLinkEndPoint(request, referencePoint);
        this.linkFeedback.setEnd(end);
        Point start = this.getLinkStartPoint(request, referencePoint, end);
        if (start != null) {
            this.linkFeedback.setStart(start);
        } else {
            this.linkFeedback.setStart(referencePoint);
        }
    }

    private Point getReferencePoint(ChangeBoundsRequest request) {
        Point refPoint = ((LabelEditPart)this.getHost()).getReferencePoint();
        Rectangle centerMain = null;
        if (((IGraphicalEditPart)this.getHost().getParent()).getFigure() instanceof Connection) {
            centerMain = new Rectangle(refPoint.x, refPoint.y, 0, 0);
        } else {
            centerMain = ((IGraphicalEditPart)this.getHost().getParent()).getFigure().getBounds().getCopy();
            centerMain.translate(centerMain.width / 2, centerMain.height / 2);
        }
        PrecisionRectangle ref = new PrecisionRectangle(centerMain);
        this.getHostFigure().translateToAbsolute((Translatable)ref);
        this.getDragSourceFeedbackFigure().translateToRelative((Translatable)ref);
        return ref.getLocation();
    }

    private Point getLinkStartPoint(ChangeBoundsRequest request, Point referencePoint, Point endPoint) {
        AbstractBorderedShapeEditPart parentPart;
        IFigure fig;
        Point u1 = referencePoint;
        Point u2 = endPoint;
        if (this.getHost().getParent() instanceof AbstractBorderedShapeEditPart && (fig = (parentPart = (AbstractBorderedShapeEditPart)this.getHost().getParent()).getMainFigure()) instanceof NodeFigure) {
            PointList pointsList = ((NodeFigure)fig).getPolygonPoints().getCopy();
            fig.translateToAbsolute((Translatable)pointsList);
            this.getDragSourceFeedbackFigure().translateToRelative((Translatable)pointsList);
            return BehaviorPropertyNodeEditPolicy.getIntersectionPoint(pointsList, u1, u2);
        }
        return referencePoint;
    }

    private Point getLinkEndPoint(ChangeBoundsRequest request, Point referencePoint) {
        Rectangle rect = this.getDragSourceFeedbackFigure().getBounds();
        Point endPoint = BehaviorPropertyNodeEditPolicy.getAppropriateBorderPoint(referencePoint, rect);
        return endPoint;
    }

    public static Point getIntersectionPoint(PointList polygonalBounds, Point insidePoint, Point outsideExtremity) {
        Point intersection = null;
        int i = 0;
        while (intersection == null && i < polygonalBounds.size() - 1) {
            Point v1 = polygonalBounds.getPoint(i).getCopy();
            Point v2 = polygonalBounds.getPoint(i + 1).getCopy();
            intersection = BehaviorPropertyNodeEditPolicy.getIntersection(insidePoint, outsideExtremity, v1, v2);
            ++i;
        }
        return intersection;
    }

    public static Point getAppropriateBorderPoint(Point referencePoint, Rectangle border) {
        Point midTop = new Point(border.x + border.width / 2, border.y);
        Point midBottom = new Point(border.x + border.width / 2, border.y + border.height);
        Point midLeft = new Point(border.x, border.y + border.height / 2);
        Point midRight = new Point(border.x + border.width, border.y + border.height / 2);
        Dimension diffTop = referencePoint.getDifference(midTop);
        Dimension diffBottom = referencePoint.getDifference(midBottom);
        Dimension diffRight = referencePoint.getDifference(midRight);
        Dimension diffLeft = referencePoint.getDifference(midLeft);
        Point startPoint = midBottom;
        if (diffBottom.height > 0) {
            startPoint = diffLeft.width < 0 && diffBottom.height < -diffLeft.width ? midLeft : (diffRight.width > 0 && diffBottom.height < diffRight.width ? midRight : midBottom);
        } else if (diffTop.height < 0) {
            startPoint = diffLeft.width < 0 && -diffTop.height < -diffLeft.width ? midLeft : (diffRight.width > 0 && -diffTop.height < diffRight.width ? midRight : midTop);
        } else if (diffLeft.width < 0) {
            startPoint = midLeft;
        } else if (diffRight.width > 0) {
            startPoint = midRight;
        }
        return startPoint;
    }

    public static Point getIntersection(Point u1, Point u2, Point v1, Point v2) {
        float denom = (u2.y - u1.y) * (v2.x - v1.x) - (u2.x - u1.x) * (v2.y - v1.y);
        float nume_a = (u2.x - u1.x) * (v1.y - u1.y) - (u2.y - u1.y) * (v1.x - u1.x);
        float nume_b = (v2.x - v1.x) * (v1.y - u1.y) - (v2.y - v1.y) * (v1.x - u1.x);
        if (denom == 0.0f) {
            return null;
        }
        float ua = nume_a / denom;
        float ub = nume_b / denom;
        if (ua >= 0.0f && ua <= 1.0f && ub >= 0.0f && ub <= 1.0f) {
            Float x = Float.valueOf((float)v1.x + ua * (float)(v2.x - v1.x));
            Float y = Float.valueOf((float)v1.y + ua * (float)(v2.y - v1.y));
            return new Point(x.intValue(), y.intValue());
        }
        return null;
    }
}

