/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.commands;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.OclMigrationProblems_qvto;
import xpt.diagram.Utils_qvto;
import xpt.providers.ElementInitializers;

@Singleton
@SuppressWarnings("all")
public class CreateNodeCommand {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private OclMigrationProblems_qvto _oclMigrationProblems_qvto;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Inject
  private ElementInitializers xptElementInitializers;
  
  public CharSequence className(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _createCommandClassName = it.getCreateCommandClassName();
    _builder.append(_createCommandClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editCommandsPackageName = it.getDiagram().getEditCommandsPackageName();
    _builder.append(_editCommandsPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence CreateNodeCommand(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence __constructor = this._constructor(it);
    _builder.append(__constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _elementToEdit = this.getElementToEdit(it);
    _builder.append(_elementToEdit, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _canExecuteMethod = this.canExecuteMethod(it);
    _builder.append(_canExecuteMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doExecuteWithResultMethod = this.doExecuteWithResultMethod(it);
    _builder.append(_doExecuteWithResultMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doConfigureMethod = this.doConfigureMethod(it);
    _builder.append(_doConfigureMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence _constructor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest req) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(req.getLabel(), null, req);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * TODO: either use setElementToEdit, or generate downcasted version (which may be troublesome if containment and child features point to a different parent)
   */
  public CharSequence getElementToEdit(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("FIXME: replace with setElementToEdit()");
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.emf.ecore.EObject getElementToEdit() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject container = ((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).getContainer();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (container instanceof org.eclipse.gmf.runtime.notation.View) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("container = ((org.eclipse.gmf.runtime.notation.View) container).getElement();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return container;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doExecuteWithResultMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    {
      boolean _isPhantomElement = it.getModelFacet().isPhantomElement();
      if (_isPhantomElement) {
        CharSequence _phantomElementCreation = this.phantomElementCreation(it.getModelFacet(), it, "newElement");
        _builder.append(_phantomElementCreation);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _normalElementCreation = this.normalElementCreation(it.getModelFacet(), it, "newElement");
        _builder.append(_normalElementCreation);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    CharSequence _initialize = this.initialize(it.getModelFacet(), it, "newElement");
    _builder.append(_initialize);
    _builder.newLineIfNotEmpty();
    {
      if (true) {
        CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
        _builder.append(_extraLineBreak_1);
        _builder.newLineIfNotEmpty();
        _builder.append("doConfigure(newElement, monitor, info);");
        _builder.newLine();
        CharSequence _extraLineBreak_2 = this._common.extraLineBreak();
        _builder.append(_extraLineBreak_2);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).setNewElement(");
    CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getModelFacet().getMetaClass(), "newElement");
    _builder.append(_DowncastToEObject, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult(newElement);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Unlike original CreateElementCommand, we don't keep track of IStatus from configureCommand.execute,
   * nor allow status setting from doDefaultCreation. The reason is ICommandProxy#execute implementation,
   * which ignores any status from wrapped ICommand. Besides, both CommandResult and IStatus seems too much to me.
   */
  public CharSequence doConfigureMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void doConfigure(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getModelFacet().getMetaClass());
    _builder.append(_QualifiedClassName);
    _builder.append(" newElement, org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType elementType = ((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).getElementType();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest configureRequest = new org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest(getEditingDomain(), ");
    CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getModelFacet().getMetaClass(), "newElement");
    _builder.append(_DowncastToEObject, "\t");
    _builder.append(", elementType);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("configureRequest.setClientContext(((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).getClientContext());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("configureRequest.addParameters(getRequest().getParameters());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.common.core.command.ICommand configureCommand = elementType.getEditCommand(configureRequest);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (configureCommand != null && configureCommand.canExecute()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("configureCommand.execute(monitor, info);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence canExecuteMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean canExecute() {");
    _builder.newLine();
    {
      boolean _isPhantomElement = it.getModelFacet().isPhantomElement();
      if (_isPhantomElement) {
        _builder.append("return true;");
        _builder.newLine();
      } else {
        CharSequence _canExecute_Normal = this.canExecute_Normal(it.getModelFacet());
        _builder.append(_canExecute_Normal);
        _builder.newLineIfNotEmpty();
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence canExecute_Normal(final TypeModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!this._oclMigrationProblems_qvto.isUnbounded(it.getContainmentMetaFeature().getEcoreFeature())) || ((!Objects.equal(it.getChildMetaFeature(), it.getContainmentMetaFeature())) && (!this._oclMigrationProblems_qvto.isUnbounded(it.getChildMetaFeature().getEcoreFeature()))))) {
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(it.getContainmentMetaFeature().getGenClass(), "container", "getElementToEdit()");
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        {
          boolean _isUnbounded = this._oclMigrationProblems_qvto.isUnbounded(it.getContainmentMetaFeature().getEcoreFeature());
          boolean _not = (!_isUnbounded);
          if (_not) {
            {
              boolean _isSingleValued = this._oclMigrationProblems_qvto.isSingleValued(it.getContainmentMetaFeature().getEcoreFeature());
              if (_isSingleValued) {
                _builder.append("if (");
                CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getContainmentMetaFeature(), "container", it.getContainmentMetaFeature().getGenClass());
                _builder.append(_featureValue);
                _builder.append(" != null) {");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("if (");
                CharSequence _featureValue_1 = this.xptMetaModel.getFeatureValue(it.getContainmentMetaFeature(), "container", it.getContainmentMetaFeature().getGenClass());
                _builder.append(_featureValue_1);
                _builder.append(".size() >= ");
                int _upperBound = it.getContainmentMetaFeature().getEcoreFeature().getUpperBound();
                _builder.append(_upperBound);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("return false;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
        {
          if (((!Objects.equal(it.getChildMetaFeature(), it.getContainmentMetaFeature())) && (!this._oclMigrationProblems_qvto.isUnbounded(it.getChildMetaFeature().getEcoreFeature())))) {
            {
              boolean _isSingleValued_1 = this._oclMigrationProblems_qvto.isSingleValued(it.getChildMetaFeature().getEcoreFeature());
              if (_isSingleValued_1) {
                _builder.append("if (");
                CharSequence _featureValue_2 = this.xptMetaModel.getFeatureValue(it.getChildMetaFeature(), "container", it.getContainmentMetaFeature().getGenClass());
                _builder.append(_featureValue_2);
                _builder.append(" != null) {");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("if (");
                CharSequence _featureValue_3 = this.xptMetaModel.getFeatureValue(it.getChildMetaFeature(), "container", it.getContainmentMetaFeature().getGenClass());
                _builder.append(_featureValue_3);
                _builder.append(".size() >= ");
                int _upperBound_1 = it.getChildMetaFeature().getEcoreFeature().getUpperBound();
                _builder.append(_upperBound_1);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("return false;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence phantomElementCreation(final TypeModelFacet it, final GenNode node, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Uncomment to put \"phantom\" objects into the diagram file.\t\t");
    _builder.newLine();
    _builder.append("// org.eclipse.emf.ecore.resource.Resource resource = ");
    _builder.newLine();
    _builder.append("// \t\t((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).getContainer().eResource();");
    _builder.newLine();
    _builder.append("// if (resource == null) {");
    _builder.newLine();
    _builder.append("// \treturn null;");
    _builder.newLine();
    _builder.append("// }");
    _builder.newLine();
    _builder.append("org.eclipse.emf.ecore.resource.Resource resource = getElementToEdit().eResource();");
    _builder.newLine();
    CharSequence _NewInstance = this.xptMetaModel.NewInstance(it.getMetaClass(), varName);
    _builder.append(_NewInstance);
    _builder.newLineIfNotEmpty();
    _builder.append("resource.getContents().add(");
    CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getMetaClass(), varName);
    _builder.append(_DowncastToEObject);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence normalElementCreation(final TypeModelFacet it, final GenNode node, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _NewInstance = this.xptMetaModel.NewInstance(it.getMetaClass(), varName);
    _builder.append(_NewInstance);
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    {
      GenFeature _containmentMetaFeature = it.getContainmentMetaFeature();
      boolean _notEquals = (!Objects.equal(_containmentMetaFeature, null));
      if (_notEquals) {
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(it.getContainmentMetaFeature().getGenClass(), "owner", "getElementToEdit()");
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(it.getContainmentMetaFeature(), "owner", it.getContainmentMetaFeature().getGenClass(), varName);
        _builder.append(_modifyFeature);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("//");
        _builder.newLine();
        _builder.append("// FIXME no containment feature found in the genmodel, toolsmith need to manually write code here to add ");
        _builder.append(varName);
        _builder.append(" to a parent");
        _builder.newLineIfNotEmpty();
        _builder.append("//");
        _builder.newLine();
      }
    }
    {
      boolean _hasExplicitChildFeature = this._utils_qvto.hasExplicitChildFeature(it);
      if (_hasExplicitChildFeature) {
        CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(it.getChildMetaFeature().getGenClass(), "childHolder", "getElementToEdit()");
        _builder.append(_DeclareAndAssign_1);
        _builder.newLineIfNotEmpty();
        CharSequence _modifyFeature_1 = this.xptMetaModel.modifyFeature(it.getChildMetaFeature(), "childHolder", it.getChildMetaFeature().getGenClass(), varName);
        _builder.append(_modifyFeature_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence initialize(final TypeModelFacet it, final GenNode node, final String newElementVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _initMethodCall = this.xptElementInitializers.initMethodCall(node, it, newElementVar);
    _builder.append(_initMethodCall);
    return _builder;
  }
  
  public CharSequence additions(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
