/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import gmfgraph.attr.CustomAttributeOwner;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.papyrus.gmf.gmfgraph.CustomLayoutData;
import org.eclipse.papyrus.gmf.gmfgraph.Dimension;
import org.eclipse.papyrus.gmf.gmfgraph.GridLayoutData;
import org.eclipse.papyrus.gmf.gmfgraph.Point;
import org.eclipse.papyrus.gmf.gmfgraph.XYLayoutData;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class LayoutData {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private gmfgraph.Runtime xptRuntime;
  
  @Inject
  private CustomAttributeOwner xptCustomAttributeOwner;
  
  @Inject
  private MapMode xptMapMode;
  
  protected CharSequence _Init(final LayoutData it, final String parentFigureVariable, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Abstract definition, there should be specific template for " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _Init(final BorderLayoutData it, final String parentFigureVariable, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    _builder.append(parentFigureVariable);
    _builder.append(".add(");
    _builder.append(owningFigureVariable);
    _builder.append(", org.eclipse.draw2d.BorderLayout.");
    String _borderLayoutConstant = this._utils_qvto.borderLayoutConstant(it);
    _builder.append(_borderLayoutConstant);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _Init(final XYLayoutData it, final String parentFigureVariable, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    _builder.append(parentFigureVariable);
    _builder.append(".add(");
    _builder.append(owningFigureVariable);
    _builder.append(", ");
    CharSequence _newRectangle = this.newRectangle(it);
    _builder.append(_newRectangle);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _Init(final CustomLayoutData it, final String parentFigureVariable, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    String _firstUpper = StringExtensions.toFirstUpper(owningFigureVariable);
    String constraintVarName = ("constraint" + _firstUpper);
    _builder.newLineIfNotEmpty();
    String _qualifiedClassName = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    _builder.append(" ");
    _builder.append(constraintVarName);
    _builder.append(" = new ");
    String _qualifiedClassName_1 = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName_1);
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    CharSequence _Init = this.xptCustomAttributeOwner.Init(it, constraintVarName);
    _builder.append(_Init);
    _builder.newLineIfNotEmpty();
    _builder.append(parentFigureVariable);
    _builder.append(".add(");
    _builder.append(owningFigureVariable);
    _builder.append(", ");
    _builder.append(constraintVarName);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _Init(final GridLayoutData it, final String parentFigureVariable, final String owningFigureVariable) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    String _firstUpper = StringExtensions.toFirstUpper(owningFigureVariable);
    String constraintVarName = ("constraint" + _firstUpper);
    _builder.newLineIfNotEmpty();
    CharSequence _newInstance = this.xptRuntime.newInstance(it, constraintVarName);
    _builder.append(_newInstance);
    _builder.newLineIfNotEmpty();
    _builder.append(constraintVarName);
    _builder.append(".verticalAlignment = ");
    CharSequence _fqn = this.xptRuntime.fqn(it);
    _builder.append(_fqn);
    _builder.append(".");
    String _literal = it.getVerticalAlignment().getLiteral();
    _builder.append(_literal);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(constraintVarName);
    _builder.append(".horizontalAlignment = ");
    CharSequence _fqn_1 = this.xptRuntime.fqn(it);
    _builder.append(_fqn_1);
    _builder.append(".");
    String _literal_1 = it.getHorizontalAlignment().getLiteral();
    _builder.append(_literal_1);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(constraintVarName);
    _builder.append(".horizontalIndent = ");
    int _horizontalIndent = it.getHorizontalIndent();
    _builder.append(_horizontalIndent);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(constraintVarName);
    _builder.append(".horizontalSpan = ");
    int _horizontalSpan = it.getHorizontalSpan();
    _builder.append(_horizontalSpan);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(constraintVarName);
    _builder.append(".verticalSpan = ");
    int _verticalSpan = it.getVerticalSpan();
    _builder.append(_verticalSpan);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(constraintVarName);
    _builder.append(".grabExcessHorizontalSpace = ");
    boolean _isGrabExcessHorizontalSpace = it.isGrabExcessHorizontalSpace();
    _builder.append(_isGrabExcessHorizontalSpace);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append(constraintVarName);
    _builder.append(".grabExcessVerticalSpace = ");
    boolean _isGrabExcessVerticalSpace = it.isGrabExcessVerticalSpace();
    _builder.append(_isGrabExcessVerticalSpace);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    {
      Dimension _sizeHint = it.getSizeHint();
      boolean _notEquals = (!Objects.equal(null, _sizeHint));
      if (_notEquals) {
        _builder.append(constraintVarName);
        _builder.append(".widthHint = ");
        int _dx = it.getSizeHint().getDx();
        _builder.append(_dx);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append(constraintVarName);
        _builder.append(".heightHint = ");
        int _dy = it.getSizeHint().getDy();
        _builder.append(_dy);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(parentFigureVariable);
    _builder.append(".add(");
    _builder.append(owningFigureVariable);
    _builder.append(", ");
    _builder.append(constraintVarName);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence newRectangle(final XYLayoutData it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.draw2d.geometry.Rectangle(");
    {
      Point _topLeft = it.getTopLeft();
      boolean _notEquals = (!Objects.equal(null, _topLeft));
      if (_notEquals) {
        CharSequence _mapMode = this.xptMapMode.mapMode(it.getTopLeft());
        _builder.append(_mapMode);
        _builder.append(", ");
      } else {
        _builder.append("0, 0, ");
      }
    }
    {
      Dimension _size = it.getSize();
      boolean _notEquals_1 = (!Objects.equal(null, _size));
      if (_notEquals_1) {
        CharSequence _mapMode_1 = this.xptMapMode.mapMode(it.getSize());
        _builder.append(_mapMode_1);
      } else {
        _builder.append("0, 0");
      }
    }
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence Init(final Object it, final String parentFigureVariable, final String owningFigureVariable) {
    if (it instanceof CustomLayoutData) {
      return _Init((CustomLayoutData)it, parentFigureVariable, owningFigureVariable);
    } else if (it instanceof BorderLayoutData) {
      return _Init((BorderLayoutData)it, parentFigureVariable, owningFigureVariable);
    } else if (it instanceof GridLayoutData) {
      return _Init((GridLayoutData)it, parentFigureVariable, owningFigureVariable);
    } else if (it instanceof XYLayoutData) {
      return _Init((XYLayoutData)it, parentFigureVariable, owningFigureVariable);
    } else if (it instanceof LayoutData) {
      return _Init((LayoutData)it, parentFigureVariable, owningFigureVariable);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, parentFigureVariable, owningFigureVariable).toString());
    }
  }
}
