/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ast;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.papyrus.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Advice;
import org.eclipse.papyrus.gmf.internal.xpand.ast.AstIterator;
import org.eclipse.papyrus.gmf.internal.xpand.ast.CompositeAstVisitor;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Definition;
import org.eclipse.papyrus.gmf.internal.xpand.ast.ImportDeclaration;
import org.eclipse.papyrus.gmf.internal.xpand.ast.NamespaceImport;
import org.eclipse.papyrus.gmf.internal.xpand.ast.analyze.UnusedMetamodelsCollector;
import org.eclipse.papyrus.gmf.internal.xpand.ast.analyze.UnusedModulesCollector;
import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandResource;
import org.eclipse.papyrus.gmf.internal.xpand.xtend.ast.QvtResource;

public class Template
extends SyntaxElement
implements XpandResource {
    private final NamespaceImport[] imports;
    private final Definition[] definitions;
    private final ImportDeclaration[] extensions;
    private final Advice[] advices;
    private String qualifiedName;
    private String[] importStrings = null;
    private String[] importedExtensions = null;

    public Template(int start, int end, int line, NamespaceImport[] imports, ImportDeclaration[] extensions, Definition[] definitions, Advice[] advices) {
        super(start, end, line);
        AbstractDefinition element;
        this.imports = imports;
        this.extensions = extensions;
        AbstractDefinition[] abstractDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            element.setOwner(this);
            ++n2;
        }
        this.definitions = definitions;
        abstractDefinitionArray = advices;
        n = advices.length;
        n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            element.setOwner(this);
            ++n2;
        }
        this.advices = advices;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.qualifiedName == null ? this.getFileName() : this.qualifiedName;
    }

    public void setFullyQualifiedName(String name) {
        this.qualifiedName = name;
    }

    @Override
    public XpandDefinition[] getDefinitions() {
        return this.definitions;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        AbstractDefinition element;
        ctx = ctx.cloneWithResource(this);
        AbstractDefinition[] abstractDefinitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            element.analyze(ctx, issues);
            ++n2;
        }
        abstractDefinitionArray = this.advices;
        n = this.advices.length;
        n2 = 0;
        while (n2 < n) {
            element = abstractDefinitionArray[n2];
            ((Advice)element).analyze(ctx, issues);
            ++n2;
        }
        LinkedHashMap<Module, ImportDeclaration> module2ImportDeclarationMap = new LinkedHashMap<Module, ImportDeclaration>();
        ImportDeclaration[] importDeclarationArray = this.extensions;
        int n3 = this.extensions.length;
        n = 0;
        while (n < n3) {
            ImportDeclaration importDeclaration = importDeclarationArray[n];
            QvtResource extension = ctx.getScope().findExtension(importDeclaration.getImportString());
            if (extension == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.EXTENSION_NOT_FOUND, "Couldn't find " + importDeclaration.getImportString(), importDeclaration));
            } else {
                for (Module module : extension.getModules()) {
                    module2ImportDeclarationMap.put(module, importDeclaration);
                }
            }
            ++n;
        }
        LinkedHashMap<EPackage, NamespaceImport> ePackage2NapespaceImportMap = new LinkedHashMap<EPackage, NamespaceImport>();
        EPackage.Registry packageRegistry = ctx.getScope().createPackageRegistry(this.getImportedNamespaces());
        NamespaceImport[] namespaceImportArray = this.imports;
        int n4 = this.imports.length;
        int n5 = 0;
        while (n5 < n4) {
            NamespaceImport namespaceImport = namespaceImportArray[n5];
            if (!packageRegistry.containsKey((Object)namespaceImport.getImportString())) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.NAMESPACE_NOT_FOUND, "Couldn't find " + namespaceImport.getImportString(), namespaceImport));
            } else {
                ePackage2NapespaceImportMap.put(packageRegistry.getEPackage(namespaceImport.getImportString()), namespaceImport);
            }
            ++n5;
        }
        this.addWarnings(module2ImportDeclarationMap, ePackage2NapespaceImportMap, ctx, issues);
    }

    private void addWarnings(Map<Module, ImportDeclaration> module2ImportDeclarationMap, Map<EPackage, NamespaceImport> ePackage2NapespaceImportMap, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        UnusedModulesCollector unusedModulesCollector = new UnusedModulesCollector(module2ImportDeclarationMap.keySet());
        UnusedMetamodelsCollector unusedMetamodelsCollector = new UnusedMetamodelsCollector(ePackage2NapespaceImportMap.keySet(), ctx);
        new AstIterator(new CompositeAstVisitor(unusedModulesCollector, unusedMetamodelsCollector)).iterate(this);
        for (Module unusedModule : unusedModulesCollector.getUnusedModules()) {
            ImportDeclaration importDeclaration = module2ImportDeclarationMap.get(unusedModule);
            issues.add(new AnalysationIssue(AnalysationIssue.Type.UNUSED_IMPORT, "Extension " + importDeclaration.getImportString() + " is never used", importDeclaration, true));
        }
        for (EPackage unusedEPackage : unusedMetamodelsCollector.getUnusedEPackages()) {
            NamespaceImport namespaceImport = ePackage2NapespaceImportMap.get(unusedEPackage);
            issues.add(new AnalysationIssue(AnalysationIssue.Type.UNUSED_IMPORT, "Import " + namespaceImport.getImportString() + " is never used", namespaceImport, true));
        }
    }

    @Override
    public String[] getImportedNamespaces() {
        if (this.importStrings == null) {
            this.importStrings = new String[this.imports.length];
            int i = 0;
            while (i < this.importStrings.length) {
                this.importStrings[i] = this.imports[i].getImportString();
                ++i;
            }
        }
        return this.importStrings;
    }

    @Override
    public String[] getImportedExtensions() {
        if (this.importedExtensions == null) {
            this.importedExtensions = new String[this.extensions.length];
            int i = 0;
            while (i < this.extensions.length) {
                this.importedExtensions[i] = this.extensions[i].getImportString();
                ++i;
            }
        }
        return this.importedExtensions;
    }

    @Override
    public XpandAdvice[] getAdvices() {
        return this.advices;
    }
}

