/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.BacktrackingParser;
import lpg.runtime.BadParseException;
import lpg.runtime.ConfigurationElement;
import lpg.runtime.ConfigurationStack;
import lpg.runtime.DiagnoseParser;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntSegmentedTuple;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.ParseErrorCodes;
import lpg.runtime.ParseTable;

public class RecoveryParser
extends DiagnoseParser
implements ParseErrorCodes {
    private BacktrackingParser parser;
    private IntSegmentedTuple action;
    private IntTuple tokens;
    private int[] actionStack;
    private DiagnoseParser.PrimaryRepairInfo scope_repair = new DiagnoseParser.PrimaryRepairInfo();

    public RecoveryParser(BacktrackingParser parser, IntSegmentedTuple action, IntTuple tokens, IPrsStream tokStream, ParseTable prs) {
        this(parser, null, action, tokens, tokStream, prs);
    }

    public RecoveryParser(BacktrackingParser parser, Monitor monitor, IntSegmentedTuple action, IntTuple tokens, IPrsStream tokStream, ParseTable prs) {
        this(parser, monitor, action, tokens, tokStream, prs, 0, 0L);
    }

    public RecoveryParser(BacktrackingParser parser, IntSegmentedTuple action, IntTuple tokens, IPrsStream tokStream, ParseTable prs, int maxErrors, long maxTime) {
        this(parser, null, action, tokens, tokStream, prs, maxErrors, maxTime);
    }

    public RecoveryParser(BacktrackingParser parser, Monitor monitor, IntSegmentedTuple action, IntTuple tokens, IPrsStream tokStream, ParseTable prs, int maxErrors, long maxTime) {
        super(monitor, tokStream, prs, maxErrors, maxTime);
        this.parser = parser;
        this.action = action;
        this.tokens = tokens;
    }

    protected void reallocateStacks() {
        super.reallocateStacks();
        if (this.actionStack == null) {
            this.actionStack = new int[this.stateStack.length];
        } else {
            int old_stack_length = this.actionStack.length;
            this.actionStack = new int[this.stateStack.length];
            System.arraycopy(this.actionStack, 0, this.actionStack, 0, old_stack_length);
        }
    }

    public void reportError(int scope_index, int error_token) {
        String text = "\"";
        int i = this.scopeSuffix(scope_index);
        while (this.scopeRhs(i) != 0) {
            if (!this.isNullable(this.scopeRhs(i))) {
                int symbol_index;
                int n = symbol_index = this.scopeRhs(i) > this.NT_OFFSET ? this.nonterminalIndex(this.scopeRhs(i) - this.NT_OFFSET) : this.terminalIndex(this.scopeRhs(i));
                if (this.name(symbol_index).length() > 0) {
                    if (text.length() > 1) {
                        text = String.valueOf(text) + " ";
                    }
                    text = String.valueOf(text) + this.name(symbol_index);
                }
            }
            ++i;
        }
        text = String.valueOf(text) + "\"";
        this.tokStream.reportError(9, error_token, error_token, new String[]{text});
    }

    public int recover(int marker_token, int error_token) throws BadParseException {
        if (this.stateStack == null) {
            this.reallocateStacks();
        }
        this.tokens.reset();
        this.tokStream.reset();
        this.tokens.add(this.tokStream.getPrevious(this.tokStream.peek()));
        int restart_token = marker_token != 0 ? marker_token : this.tokStream.getToken();
        int old_action_size = 0;
        this.stateStackTop = 0;
        this.stateStack[this.stateStackTop] = this.START_STATE;
        do {
            this.action.reset(old_action_size);
            if (!this.fixError(restart_token, error_token)) {
                throw new BadParseException(error_token);
            }
            if (this.monitor != null && this.monitor.isCancelled()) break;
            restart_token = error_token;
            this.tokStream.reset(error_token);
            old_action_size = this.action.size();
            error_token = this.parser.backtrackParse(this.stateStack, this.stateStackTop, this.action, 0);
            this.tokStream.reset(this.tokStream.getNext(restart_token));
        } while (error_token != 0);
        return restart_token;
    }

    private boolean fixError(int start_token, int error_token) {
        int curtok = start_token;
        int current_kind = this.tokStream.getKind(curtok);
        int first_stream_token = this.tokStream.peek();
        this.buffer[1] = error_token;
        this.buffer[0] = this.tokStream.getPrevious(this.buffer[1]);
        int k = 2;
        while (k < 32) {
            this.buffer[k] = this.tokStream.getNext(this.buffer[k - 1]);
            ++k;
        }
        this.scope_repair.distance = 0;
        this.scope_repair.misspellIndex = 0;
        this.scope_repair.bufferPosition = 1;
        this.main_configuration_stack = new ConfigurationStack(this.prs);
        this.locationStack[this.stateStackTop] = curtok;
        this.actionStack[this.stateStackTop] = this.action.size();
        int act = this.tAction(this.stateStack[this.stateStackTop], current_kind);
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return true;
            }
            if (act <= this.NUM_RULES) {
                this.action.add(act);
                --this.stateStackTop;
                do {
                    this.stateStackTop -= this.rhs(act) - 1;
                } while ((act = this.ntAction(this.stateStack[this.stateStackTop], this.lhs(act))) <= this.NUM_RULES);
                try {
                    this.stateStack[++this.stateStackTop] = act;
                }
                catch (IndexOutOfBoundsException e) {
                    this.reallocateStacks();
                    this.stateStack[this.stateStackTop] = act;
                }
                this.locationStack[this.stateStackTop] = curtok;
                this.actionStack[this.stateStackTop] = this.action.size();
                act = this.tAction(act, current_kind);
                continue;
            }
            if (act == this.ERROR_ACTION) {
                if (curtok == error_token && this.main_configuration_stack.size() <= 0) break;
                ConfigurationElement configuration = this.main_configuration_stack.pop();
                if (configuration == null) {
                    act = this.ERROR_ACTION;
                    break;
                }
                this.stateStackTop = configuration.stack_top;
                configuration.retrieveStack(this.stateStack);
                act = configuration.act;
                curtok = configuration.curtok;
                this.action.reset(configuration.action_length);
                current_kind = this.tokStream.getKind(curtok);
                this.tokStream.reset(this.tokStream.getNext(curtok));
                continue;
            }
            if (act > this.ACCEPT_ACTION && act < this.ERROR_ACTION) {
                if (this.main_configuration_stack.findConfiguration(this.stateStack, this.stateStackTop, curtok)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                this.main_configuration_stack.push(this.stateStack, this.stateStackTop, act + 1, curtok, this.action.size());
                act = this.baseAction(act);
                continue;
            }
            if (act < this.ACCEPT_ACTION) {
                this.action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
            } else {
                if (act <= this.ERROR_ACTION) break;
                this.action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                act -= this.ERROR_ACTION;
                do {
                    this.stateStackTop -= this.rhs(act) - 1;
                } while ((act = this.ntAction(this.stateStack[this.stateStackTop], this.lhs(act))) <= this.NUM_RULES);
            }
            try {
                this.stateStack[++this.stateStackTop] = act;
            }
            catch (IndexOutOfBoundsException e) {
                this.reallocateStacks();
                this.stateStack[this.stateStackTop] = act;
            }
            if (curtok == error_token) {
                this.scopeTrial(this.scope_repair, this.stateStack, this.stateStackTop);
                if (this.scope_repair.distance >= 3) {
                    this.tokens.add(start_token);
                    int token = first_stream_token;
                    while (token != error_token) {
                        this.tokens.add(token);
                        token = this.tokStream.getNext(token);
                    }
                    this.acceptRecovery(error_token);
                    break;
                }
            }
            this.locationStack[this.stateStackTop] = curtok;
            this.actionStack[this.stateStackTop] = this.action.size();
            act = this.tAction(act, current_kind);
        }
        return act != this.ERROR_ACTION;
    }

    private void acceptRecovery(int error_token) {
        IntTuple recovery_action = new IntTuple();
        int k = 0;
        while (k <= this.scopeStackTop) {
            int scope_index = this.scopeIndex[k];
            int la = this.scopeLa(scope_index);
            recovery_action.reset();
            int act = this.tAction(this.stateStack[this.stateStackTop], la);
            if (act > this.ACCEPT_ACTION && act < this.ERROR_ACTION) {
                do {
                    recovery_action.add(this.baseAction(act++));
                } while (this.baseAction(act) != 0);
            } else {
                recovery_action.add(act);
            }
            int start_action_size = this.action.size();
            int index = 0;
            while (index < recovery_action.size()) {
                this.action.reset(start_action_size);
                this.tokStream.reset(error_token);
                this.tempStackTop = this.stateStackTop - 1;
                int max_pos = this.stateStackTop;
                act = recovery_action.get(index);
                while (act <= this.NUM_RULES) {
                    int lhs_symbol;
                    this.action.add(act);
                    do {
                        lhs_symbol = this.lhs(act);
                        this.tempStackTop -= this.rhs(act) - 1;
                        int n = act = this.tempStackTop > max_pos ? this.tempStack[this.tempStackTop] : this.stateStack[this.tempStackTop];
                    } while ((act = this.ntAction(act, lhs_symbol)) <= this.NUM_RULES);
                    if (this.tempStackTop + 1 >= this.stateStack.length) {
                        this.reallocateStacks();
                    }
                    max_pos = max_pos < this.tempStackTop ? max_pos : this.tempStackTop;
                    this.tempStack[this.tempStackTop + 1] = act;
                    act = this.tAction(act, la);
                }
                if (act != this.ERROR_ACTION) {
                    this.nextStackTop = ++this.tempStackTop;
                    int i = 0;
                    while (i <= max_pos) {
                        this.nextStack[i] = this.stateStack[i];
                        ++i;
                    }
                    i = max_pos + 1;
                    while (i <= this.tempStackTop) {
                        this.nextStack[i] = this.tempStack[i];
                        ++i;
                    }
                    if (this.completeScope(this.action, this.scopeSuffix(scope_index))) {
                        i = this.scopeSuffix(this.scopeIndex[k]);
                        while (this.scopeRhs(i) != 0) {
                            this.tokens.add(((IPrsStream)this.tokStream).makeErrorToken(error_token, this.tokStream.getPrevious(error_token), error_token, this.scopeRhs(i)));
                            ++i;
                        }
                        this.reportError(this.scopeIndex[k], this.tokStream.getPrevious(error_token));
                        break;
                    }
                }
                ++index;
            }
            this.stateStackTop = this.nextStackTop;
            System.arraycopy(this.nextStack, 0, this.stateStack, 0, this.stateStackTop + 1);
            ++k;
        }
    }

    private boolean completeScope(IntSegmentedTuple action, int scope_rhs_index) {
        int kind = this.scopeRhs(scope_rhs_index);
        if (kind == 0) {
            return true;
        }
        int act = this.nextStack[this.nextStackTop];
        if (kind > this.NT_OFFSET) {
            int lhs_symbol = kind - this.NT_OFFSET;
            if (this.baseCheck(act + lhs_symbol) != lhs_symbol) {
                return false;
            }
            action.add((act = this.ntAction(act, lhs_symbol)) <= this.NUM_RULES ? act + this.ERROR_ACTION : act);
            while (act <= this.NUM_RULES) {
                this.nextStackTop -= this.rhs(act) - 1;
                act = this.ntAction(this.nextStack[this.nextStackTop], this.lhs(act));
            }
            ++this.nextStackTop;
            this.nextStack[this.nextStackTop] = act;
            return this.completeScope(action, scope_rhs_index + 1);
        }
        act = this.tAction(act, kind);
        action.add(act);
        if (act < this.ACCEPT_ACTION) {
            ++this.nextStackTop;
            this.nextStack[this.nextStackTop] = act;
            return this.completeScope(action, scope_rhs_index + 1);
        }
        if (act > this.ERROR_ACTION) {
            act -= this.ERROR_ACTION;
            do {
                this.nextStackTop -= this.rhs(act) - 1;
            } while ((act = this.ntAction(this.nextStack[this.nextStackTop], this.lhs(act))) <= this.NUM_RULES);
            ++this.nextStackTop;
            this.nextStack[this.nextStackTop] = act;
            return true;
        }
        if (act > this.ACCEPT_ACTION && act < this.ERROR_ACTION) {
            int save_action_size = action.size();
            int i = act;
            while (this.baseAction(i) != 0) {
                action.reset(save_action_size);
                act = this.baseAction(i);
                action.add(act);
                if (act > this.NUM_RULES) {
                    if (act < this.ACCEPT_ACTION) {
                        ++this.nextStackTop;
                        this.nextStack[this.nextStackTop] = act;
                        if (this.completeScope(action, scope_rhs_index + 1)) {
                            return true;
                        }
                    } else if (act > this.ERROR_ACTION) {
                        act -= this.ERROR_ACTION;
                        do {
                            this.nextStackTop -= this.rhs(act) - 1;
                        } while ((act = this.ntAction(this.nextStack[this.nextStackTop], this.lhs(act))) <= this.NUM_RULES);
                        ++this.nextStackTop;
                        this.nextStack[this.nextStackTop] = act;
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }
}

