/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.minimap;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.internal.views.minimap.MinimapMessages;
import org.eclipse.ui.internal.views.minimap.MinimapPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.texteditor.ITextEditor;

public class MultiPageMinimapPage
extends Page {
    private final MultiPageEditorPart fMultiPageEditor;
    private final Map<Object, Control> fTextWidgetMap;
    private final IPageChangedListener fPageChangedListener;
    private PageBook fPageBook;
    private Label fErrorLabel;

    public MultiPageMinimapPage(MultiPageEditorPart multiPageEditor) {
        this.fMultiPageEditor = multiPageEditor;
        this.fTextWidgetMap = new HashMap<Object, Control>();
        this.fPageChangedListener = e -> {
            Object selectedPage = multiPageEditor.getSelectedPage();
            Control textWidget = this.fTextWidgetMap.get(selectedPage);
            if (textWidget != null) {
                this.fPageBook.showPage(textWidget);
                return;
            }
            MinimapPage minimapPage = null;
            if (selectedPage instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)selectedPage;
                minimapPage = MinimapPage.createMinimapPage(textEditor);
            }
            if (minimapPage != null) {
                minimapPage.createControl((Composite)this.fPageBook);
                textWidget = minimapPage.getControl();
                this.fTextWidgetMap.put(selectedPage, textWidget);
                this.fPageBook.showPage(textWidget);
            } else {
                this.fTextWidgetMap.put(selectedPage, (Control)this.fErrorLabel);
                this.fPageBook.showPage((Control)this.fErrorLabel);
            }
        };
        multiPageEditor.addPageChangedListener(this.fPageChangedListener);
    }

    public void createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.fErrorLabel = new Label((Composite)this.fPageBook, 0);
        this.fErrorLabel.setText(MinimapMessages.MinimapViewNoMinimap);
        this.fPageChangedListener.pageChanged(null);
    }

    public Control getControl() {
        return this.fPageBook;
    }

    public void setFocus() {
        this.fPageBook.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.fMultiPageEditor.removePageChangedListener(this.fPageChangedListener);
    }
}

