/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style;

import org.eclipse.nebula.widgets.nattable.persistence.ColorPersistor;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;

public class BorderStyle {
    private int thickness = 1;
    private Color color = GUIHelper.COLOR_BLACK;
    private LineStyleEnum lineStyle = LineStyleEnum.SOLID;
    private BorderModeEnum borderMode = BorderModeEnum.CENTERED;

    public BorderStyle() {
    }

    public BorderStyle(int thickness, Color color, LineStyleEnum lineStyle) {
        this.thickness = thickness;
        this.color = color;
        this.lineStyle = lineStyle;
    }

    public BorderStyle(int thickness, Color color, LineStyleEnum lineStyle, BorderModeEnum borderMode) {
        this.thickness = thickness;
        this.color = color;
        this.lineStyle = lineStyle;
        this.borderMode = borderMode;
    }

    public BorderStyle(String string) {
        String[] tokens = string.split("\\|");
        this.thickness = Integer.parseInt(tokens[0]);
        this.color = ColorPersistor.asColor(tokens[1]);
        this.lineStyle = LineStyleEnum.valueOf(tokens[2]);
        if (tokens.length > 3) {
            this.borderMode = BorderModeEnum.valueOf(tokens[3]);
        }
    }

    public int getThickness() {
        return this.thickness;
    }

    public Color getColor() {
        return this.color;
    }

    public LineStyleEnum getLineStyle() {
        return this.lineStyle;
    }

    public BorderModeEnum getBorderMode() {
        return this.borderMode;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLineStyle(LineStyleEnum lineStyle) {
        this.lineStyle = lineStyle;
    }

    public void setBorderMode(BorderModeEnum borderMode) {
        this.borderMode = borderMode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BorderStyle other = (BorderStyle)obj;
        if (this.borderMode != other.borderMode) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals((Object)other.color)) {
            return false;
        }
        if (this.lineStyle != other.lineStyle) {
            return false;
        }
        return this.thickness == other.thickness;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.borderMode == null ? 0 : this.borderMode.hashCode());
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.lineStyle == null ? 0 : this.lineStyle.hashCode());
        result = 31 * result + this.thickness;
        return result;
    }

    public String toString() {
        return String.valueOf(this.thickness) + "|" + ColorPersistor.asString(this.color) + "|" + (Object)((Object)this.lineStyle) + "|" + (Object)((Object)this.borderMode);
    }

    public static enum BorderModeEnum {
        CENTERED,
        INTERNAL,
        EXTERNAL;

    }

    public static enum LineStyleEnum {
        SOLID,
        DASHED,
        DOTTED,
        DASHDOT,
        DASHDOTDOT;


        public static int toSWT(LineStyleEnum line) {
            if (line == null) {
                throw new IllegalArgumentException("null");
            }
            if (line.equals((Object)SOLID)) {
                return 1;
            }
            if (line.equals((Object)DASHED)) {
                return 2;
            }
            if (line.equals((Object)DOTTED)) {
                return 3;
            }
            if (line.equals((Object)DASHDOT)) {
                return 4;
            }
            if (line.equals((Object)DASHDOTDOT)) {
                return 5;
            }
            return 1;
        }
    }
}

