/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.commands.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;
import org.eclipse.papyrus.uml.commands.command.RenameNamedElementLabelCommand;
import org.eclipse.papyrus.uml.commands.messages.Messages;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.views.modelexplorer.commands.RenameElementCommand;
import org.eclipse.papyrus.views.modelexplorer.util.ModelExplorerEditionUtil;
import org.eclipse.uml2.uml.NamedElement;

public class RenameNamedElementHandler
extends AbstractCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
        EObject selectedElement = this.getSelectedElement();
        if (selectedElement instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)selectedElement;
            String label = UMLLabelInternationalization.getInstance().getLabelWithoutUML(namedElement);
            if (label != null && LabelInternationalizationPreferencesUtils.getInternationalizationPreference((EObject)namedElement)) {
                RenameNamedElementLabelCommand cmd = new RenameNamedElementLabelCommand(editingDomain, "ChangeLabelCommand", (EObject)namedElement, label, Messages.RenameNamedElementHandler_Label_DialogTitle);
                result = new GMFtoEMFCommandWrapper((ICommand)cmd);
            } else {
                String currentName = namedElement.getName();
                if (currentName != null) {
                    EStructuralFeature nameFeature = namedElement.eClass().getEStructuralFeature("name");
                    result = new RenameElementCommand(editingDomain, "Rename", (EObject)namedElement, currentName, nameFeature, Messages.RenameNamedElementHandler_Name_DialogTitle, Messages.RenameNamedElementHandler_Name_DialogMessage);
                }
            }
        }
        return result;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean enabled = super.computeEnabled(context);
        if (enabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            enabled = !EMFHelper.isReadOnly((EObject)selection);
        }
        return enabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedElement = this.getSelectedElement();
        if (ModelExplorerEditionUtil.isHandledByDirectEditor((EObject)selectedElement)) {
            ModelExplorerEditionUtil.editElement((EObject)selectedElement);
        } else {
            super.execute(event);
        }
        return null;
    }
}

