/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.refactoring.UndoCompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;

public class CompilationUnitChange
extends TextFileChange {
    private final ICompilationUnit fCUnit;
    private ChangeDescriptor fDescriptor;

    public CompilationUnitChange(String name, ICompilationUnit cunit) {
        super(name, CompilationUnitChange.getFile(cunit));
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        this.setTextType("java");
    }

    private static IFile getFile(ICompilationUnit cunit) {
        return (IFile)cunit.getResource();
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        this.fCUnit.becomeWorkingCopy((IProgressMonitor)subMonitor.split(1));
        Assert.isTrue((boolean)this.fCUnit.isWorkingCopy(), (String)this.fCUnit.toString());
        return super.acquireDocument((IProgressMonitor)subMonitor.split(1));
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        boolean isModified = this.isDocumentModified();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        super.releaseDocument(document, (IProgressMonitor)subMonitor.split(1));
        try {
            this.fCUnit.discardWorkingCopy();
        }
        finally {
            if (isModified && !this.isDocumentAcquired()) {
                if (this.fCUnit.isWorkingCopy()) {
                    this.fCUnit.reconcile(0, false, null, (IProgressMonitor)subMonitor.split(1, 10));
                } else {
                    this.fCUnit.makeConsistent((IProgressMonitor)subMonitor.split(1, 10));
                }
            }
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        try {
            return new UndoCompilationUnitChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
        }
        catch (CoreException e) {
            JavaManipulationPlugin.log(e);
            return null;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ICompilationUnit.class.equals(adapter)) {
            return (T)this.fCUnit;
        }
        return (T)super.getAdapter(adapter);
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }
}

