/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ActionDelegateWrapper
extends Action
implements ISelectionChangedListener {
    private IActionDelegate delegate;

    public ActionDelegateWrapper(IActionDelegate delegate, ISynchronizePageConfiguration configuration) {
        this.delegate = delegate;
        IWorkbenchPart part = configuration.getSite().getPart();
        if (part != null) {
            if (delegate instanceof IObjectActionDelegate) {
                ((IObjectActionDelegate)delegate).setActivePart((IAction)this, part);
            }
            if (part instanceof IViewPart && delegate instanceof IViewActionDelegate) {
                ((IViewActionDelegate)delegate).init((IViewPart)part);
            }
            if (part instanceof IEditorPart && delegate instanceof IEditorActionDelegate) {
                ((IEditorActionDelegate)delegate).setActiveEditor((IAction)this, (IEditorPart)part);
            }
        }
        this.initialize(configuration);
    }

    public ActionDelegateWrapper(IActionDelegate delegate, ISynchronizePageConfiguration configuration, String id) {
        this(delegate, configuration);
        this.setId(id);
        this.setActionDefinitionId(id);
    }

    protected void initialize(ISynchronizePageConfiguration configuration) {
        configuration.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        configuration.getPage().getViewer().getControl().addDisposeListener(e -> configuration.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.getDelegate().selectionChanged((IAction)this, event.getSelection());
    }

    public void run() {
        this.getDelegate().run((IAction)this);
    }

    public IActionDelegate getDelegate() {
        return this.delegate;
    }
}

