/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.iproduct.IConfigurationProperty;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PropertiesSection
extends TableSection {
    private TableViewer fPropertiesTable;

    public PropertiesSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, PropertiesSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.PropertiesSection_Add, PDEUIMessages.PropertiesSection_Edit, PDEUIMessages.PropertiesSection_Remove};
        return labels;
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                this.handleRemove();
            }
        }
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.PropertiesSection_PropertiesSectionTitle);
        section.setDescription(PDEUIMessages.PropertiesSection_PropertiesSectionDescription);
        GridData sectionData = new GridData(4, 4, true, true);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 3, toolkit);
        this.createViewerPartControl(container, 65538, 3, toolkit);
        this.fPropertiesTable = this.getTablePart().getTableViewer();
        this.fPropertiesTable.setComparator(new ViewerComparator());
        this.fPropertiesTable.addDoubleClickListener(event -> this.handleEdit());
        this.fPropertiesTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    PropertiesSection.this.handleRemove();
                }
            }
        });
        final Table table = this.fPropertiesTable.getTable();
        final TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(PDEUIMessages.PropertiesSection_NameColumn);
        nameColumn.setWidth(160);
        final TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText(PDEUIMessages.PropertiesSection_ValueColumn);
        valueColumn.setWidth(220);
        final TableColumn osColumn = new TableColumn(table, 16384);
        osColumn.setText(PDEUIMessages.PropertiesSection_OSColumn);
        osColumn.setWidth(60);
        final TableColumn archColumn = new TableColumn(table, 16384);
        archColumn.setText(PDEUIMessages.PropertiesSection_ArchColumn);
        archColumn.setWidth(60);
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int size = table.getSize().x;
                nameColumn.setWidth(size / 9 * 3);
                valueColumn.setWidth(size / 9 * 4);
                osColumn.setWidth(size / 9 * 1);
                archColumn.setWidth(size / 9 * 1);
            }
        });
        TextCellEditor cellEditor = new TextCellEditor((Composite)table);
        cellEditor.getControl().pack();
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = cellEditor;
        this.fPropertiesTable.setCellEditors(cellEditorArray);
        this.fPropertiesTable.setColumnProperties(new String[]{"0", "1"});
        this.fPropertiesTable.setCellModifier((ICellModifier)new ValueCellModifier());
        table.setHeaderVisible(true);
        toolkit.paintBordersFor(container);
        this.fPropertiesTable.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fPropertiesTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fPropertiesTable.setInput((Object)this.getProduct());
        section.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateButtons();
    }

    private void handleAdd() {
        IConfigurationProperty result;
        PropertyDialog dialog = new PropertyDialog(PDEPlugin.getActiveWorkbenchShell(), null, this.getExistingNames());
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            this.fPropertiesTable.refresh();
            this.fPropertiesTable.setSelection((ISelection)new StructuredSelection((Object)result));
            this.updateButtons();
        }
    }

    private void handleEdit() {
        IStructuredSelection ssel = this.fPropertiesTable.getStructuredSelection();
        if (!ssel.isEmpty() && ssel.getFirstElement() instanceof IConfigurationProperty) {
            IConfigurationProperty result;
            IConfigurationProperty propertyToEdit = (IConfigurationProperty)ssel.getFirstElement();
            Set<String> existing = this.getExistingNames();
            existing.remove(propertyToEdit.getName());
            PropertyDialog dialog = new PropertyDialog(PDEPlugin.getActiveWorkbenchShell(), propertyToEdit, existing);
            if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
                this.fPropertiesTable.refresh();
                this.fPropertiesTable.setSelection((ISelection)new StructuredSelection((Object)result));
                this.updateButtons();
            }
        }
    }

    private Set<String> getExistingNames() {
        IConfigurationProperty[] properties;
        HashSet<String> result = new HashSet<String>();
        IConfigurationProperty[] iConfigurationPropertyArray = properties = this.getProduct().getConfigurationProperties();
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationProperty property = iConfigurationPropertyArray[n2];
            result.add(property.getName());
            ++n2;
        }
        return result;
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fPropertiesTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            Object[] objects = ssel.toArray();
            IConfigurationProperty[] properties = new IConfigurationProperty[objects.length];
            System.arraycopy(objects, 0, properties, 0, objects.length);
            this.getProduct().removeConfigurationProperties(properties);
            this.fPropertiesTable.refresh(false);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.updateButtons();
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.fPropertiesTable.setInput((Object)this.getProduct());
        this.fPropertiesTable.refresh();
        this.updateButtons();
    }

    private void updateButtons() {
        EditableTablePart tablePart = this.getTablePart();
        IStructuredSelection selection = this.getViewerSelection();
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable() && !selection.isEmpty());
        tablePart.setButtonEnabled(2, this.isEditable() && !selection.isEmpty());
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProduct) {
                return ((IProduct)inputElement).getConfigurationProperties();
            }
            return new Object[0];
        }
    }

    private class LabelProvider
    extends PDELabelProvider {
        private LabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.get(PDEPluginImages.DESC_PROPERTIES);
            }
            return null;
        }

        @Override
        public String getColumnText(Object obj, int index) {
            IConfigurationProperty configuration = (IConfigurationProperty)obj;
            switch (index) {
                case 0: {
                    return configuration.getName();
                }
                case 1: {
                    return configuration.getValue();
                }
                case 2: {
                    return configuration.getOs();
                }
                case 3: {
                    return configuration.getArch();
                }
            }
            return null;
        }
    }

    private class PropertyDialog
    extends StatusDialog {
        private Text fName;
        private Text fValue;
        private Combo fOS;
        private Combo fArch;
        private IConfigurationProperty fEdit;
        private Set<String> fExistingNames;
        private String[] COMBO_OSLABELS;
        private String[] COMBO_ARCHLABELS;

        public PropertyDialog(Shell shell, IConfigurationProperty property, Set<String> existingNames) {
            super(shell);
            this.COMBO_OSLABELS = new String[]{PDEUIMessages.PropertiesSection_All, "linux", "macosx", "win32"};
            this.COMBO_ARCHLABELS = new String[]{PDEUIMessages.PropertiesSection_All, "x86", "x86_64"};
            this.fEdit = property;
            this.fExistingNames = existingNames;
            this.setTitle(PDEUIMessages.PropertiesSection_PropertyDialogTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = (Composite)super.createDialogArea(parent);
            ((GridLayout)comp.getLayout()).numColumns = 2;
            SWTFactory.createLabel(comp, PDEUIMessages.PropertiesSection_Name, 1);
            this.fName = SWTFactory.createSingleText(comp, 1);
            this.fName.addModifyListener(e -> this.validate());
            SWTFactory.createLabel(comp, PDEUIMessages.PropertiesSection_Value, 1);
            this.fValue = SWTFactory.createSingleText(comp, 1);
            this.fValue.addModifyListener(e -> this.validate());
            SWTFactory.createLabel(comp, PDEUIMessages.PropertiesSection_OS, 1);
            this.fOS = SWTFactory.createCombo(comp, 2060, 1, this.COMBO_OSLABELS);
            this.fOS.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyDialog.this.updateStatus(Status.OK_STATUS);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    PropertyDialog.this.updateStatus(Status.OK_STATUS);
                }
            });
            SWTFactory.createLabel(comp, PDEUIMessages.PropertiesSection_Arch, 1);
            this.fArch = SWTFactory.createCombo(comp, 2060, 1, this.COMBO_ARCHLABELS);
            this.fArch.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyDialog.this.updateStatus(Status.OK_STATUS);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    PropertyDialog.this.updateStatus(Status.OK_STATUS);
                }
            });
            if (this.fEdit != null) {
                int index;
                if (this.fEdit.getName() != null) {
                    this.fName.setText(this.fEdit.getName());
                }
                if (this.fEdit.getValue() != null) {
                    this.fValue.setText(this.fEdit.getValue());
                }
                if ((index = Arrays.asList(this.COMBO_OSLABELS).indexOf(this.fEdit.getOs())) >= 0) {
                    this.fOS.select(index);
                } else {
                    this.fOS.select(0);
                }
                index = Arrays.asList(this.COMBO_ARCHLABELS).indexOf(this.fEdit.getArch());
                if (index >= 0) {
                    this.fArch.select(index);
                } else {
                    this.fArch.select(0);
                }
            }
            this.updateStatus((IStatus)new Status(4, "org.eclipse.pde.ui", ""));
            return comp;
        }

        protected void validate() {
            String name = this.fName.getText().trim();
            if (name.length() == 0) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.pde.ui", PDEUIMessages.PropertiesSection_ErrorPropertyNoName));
            } else if (this.fExistingNames.contains(name)) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.pde.ui", NLS.bind((String)PDEUIMessages.PropertiesSection_ErrorPropertyExists, (Object)name)));
            } else {
                this.updateStatus(Status.OK_STATUS);
            }
        }

        protected void okPressed() {
            if (this.fEdit != null) {
                PropertiesSection.this.getProduct().removeConfigurationProperties(new IConfigurationProperty[]{this.fEdit});
            }
            IProductModelFactory factory = PropertiesSection.this.getModel().getFactory();
            this.fEdit = factory.createConfigurationProperty();
            this.fEdit.setName(this.fName.getText().trim());
            this.fEdit.setValue(this.fValue.getText().trim());
            int index = this.fOS.getSelectionIndex();
            this.fEdit.setOs(index == 0 ? "" : this.COMBO_OSLABELS[index]);
            index = this.fArch.getSelectionIndex();
            this.fEdit.setArch(index == 0 ? "" : this.COMBO_ARCHLABELS[index]);
            PropertiesSection.this.getProduct().addConfigurationProperties(new IConfigurationProperty[]{this.fEdit});
            super.okPressed();
        }

        protected Control createHelpControl(Composite parent) {
            return parent;
        }

        public IConfigurationProperty getResult() {
            return this.fEdit;
        }
    }

    class ValueCellModifier
    implements ICellModifier {
        ValueCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return element instanceof IConfigurationProperty;
        }

        public Object getValue(Object element, String property) {
            return ((IConfigurationProperty)element).getValue();
        }

        public void modify(Object item, String property, Object value) {
            Object data = ((TableItem)item).getData();
            if (data instanceof IConfigurationProperty) {
                String newValue = ((String)value).trim();
                ((IConfigurationProperty)data).setValue(newValue);
                PropertiesSection.this.fPropertiesTable.refresh(data);
            }
        }
    }
}

