/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.ActionElement;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class ActionProvider
extends QuickAccessProvider {
    private Map idToElement;

    @Override
    public String getId() {
        return "org.eclipse.ui.actions";
    }

    @Override
    public QuickAccessElement getElementForId(String id) {
        this.getElements();
        return (ActionElement)this.idToElement.get(id);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.idToElement == null) {
            this.idToElement = new HashMap();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window instanceof WorkbenchWindow) {
                ActionContributionItem[] actions;
                MenuManager menu = ((WorkbenchWindow)window).getMenuManager();
                HashSet result = new HashSet();
                this.collectContributions(menu, result);
                ActionContributionItem[] actionContributionItemArray = actions = result.toArray(new ActionContributionItem[result.size()]);
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionContributionItem action = actionContributionItemArray[n2];
                    ActionElement actionElement = new ActionElement(action);
                    this.idToElement.put(actionElement.getId(), actionElement);
                    ++n2;
                }
            }
        }
        return this.idToElement.values().toArray(new ActionElement[this.idToElement.values().size()]);
    }

    private void collectContributions(MenuManager menu, Set result) {
        IContributionItem[] iContributionItemArray = menu.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof SubContributionItem) {
                item = ((SubContributionItem)item).getInnerItem();
            }
            if (item instanceof MenuManager) {
                this.collectContributions((MenuManager)item, result);
            } else if (item instanceof ActionContributionItem && item.isEnabled()) {
                result.add(item);
            }
            ++n2;
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Menus;
    }

    @Override
    protected void doReset() {
        this.idToElement = null;
    }

    @Override
    public boolean requiresUiAccess() {
        return true;
    }
}

