/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.rename;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ChangeConverter2
implements IAcceptor<IEmfResourceChange> {
    private final IResourceServiceProvider.Registry registry;
    @Extension
    private final UriExtensions uriExtensions;
    private final WorkspaceEdit edit;
    private final ILanguageServerAccess access;
    private final boolean useDocumentChanges;

    protected ChangeConverter2(IResourceServiceProvider.Registry registry, WorkspaceEdit edit, ILanguageServerAccess access, UriExtensions uriExtensions) {
        boolean _tripleEquals;
        this.registry = registry;
        this.uriExtensions = uriExtensions;
        this.edit = edit;
        this.access = access;
        InitializeParams _initializeParams = null;
        if (access != null) {
            _initializeParams = access.getInitializeParams();
        }
        ClientCapabilities _capabilities = null;
        if (_initializeParams != null) {
            _capabilities = _initializeParams.getCapabilities();
        }
        WorkspaceClientCapabilities _workspace = null;
        if (_capabilities != null) {
            _workspace = _capabilities.getWorkspace();
        }
        WorkspaceEditCapabilities _workspaceEdit = null;
        if (_workspace != null) {
            _workspaceEdit = _workspace.getWorkspaceEdit();
        }
        Boolean _documentChanges = null;
        if (_workspaceEdit != null) {
            _documentChanges = _workspaceEdit.getDocumentChanges();
        }
        this.useDocumentChanges = _tripleEquals = _documentChanges == Boolean.TRUE;
        if (this.useDocumentChanges) {
            this.edit.setDocumentChanges((List)CollectionLiterals.newArrayList());
        } else {
            this.edit.setChanges((Map)CollectionLiterals.newLinkedHashMap());
        }
    }

    public void accept(IEmfResourceChange change) {
        this.handleReplacements(change);
    }

    protected void _handleReplacements(IEmfResourceChange change) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            String uri = this.uriExtensions.toUriString(change.getResource().getURI());
            change.getResource().save((OutputStream)outputStream, null);
            byte[] _byteArray = outputStream.toByteArray();
            String _charset = this.getCharset(change.getResource());
            String newContent = new String(_byteArray, _charset);
            Function<ILanguageServerAccess.Context, Object> _function = context -> {
                Object _xblockexpression = null;
                Document document = context.getDocument();
                Position _position = document.getPosition(0);
                Position _position_1 = document.getPosition(document.getContents().length());
                Range range = new Range(_position, _position_1);
                TextEdit textEdit = new TextEdit(range, newContent);
                _xblockexpression = this.addTextEdit(uri, document, textEdit);
                return _xblockexpression;
            };
            this.access.doRead(uri, _function).get();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getCharset(Resource resource) {
        String _xblockexpression = null;
        IEncodingProvider xtextEncodingProvider = (IEncodingProvider)this.registry.getResourceServiceProvider(resource.getURI()).get(IEncodingProvider.class);
        String _xifexpression = null;
        if (xtextEncodingProvider != null) {
            return xtextEncodingProvider.getEncoding(resource.getURI());
        }
        String _xifexpression_1 = null;
        _xifexpression_1 = resource instanceof XMLResource ? ((XMLResource)resource).getEncoding() : Charset.defaultCharset().toString();
        _xblockexpression = _xifexpression = _xifexpression_1;
        return _xblockexpression;
    }

    protected void _handleReplacements(ITextDocumentChange change) {
        try {
            boolean _greaterThan;
            int _size = change.getReplacements().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                String uri = this.uriExtensions.toUriString(change.getNewURI());
                Function<ILanguageServerAccess.Context, Object> _function = context -> {
                    Object _xblockexpression = null;
                    Document document = context.getDocument();
                    Functions.Function1 _function_1 = replacement -> {
                        TextEdit _xblockexpression_1 = null;
                        Position start = document.getPosition(replacement.getOffset());
                        int _offset = replacement.getOffset();
                        int _length = replacement.getLength();
                        int _plus = _offset + _length;
                        Position end = document.getPosition(_plus);
                        Range range = new Range(start, end);
                        String _replacementText = replacement.getReplacementText();
                        _xblockexpression_1 = new TextEdit(range, _replacementText);
                        return _xblockexpression_1;
                    };
                    List textEdits = ListExtensions.map(change.getReplacements(), (Functions.Function1)_function_1);
                    _xblockexpression = this.addTextEdit(uri, document, (TextEdit[])Conversions.unwrapArray((Object)textEdits, TextEdit.class));
                    return _xblockexpression;
                };
                this.access.doRead(uri, _function).get();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Object addTextEdit(String theUri, Document document, TextEdit ... textEdits) {
        Object _xifexpression = null;
        if (this.useDocumentChanges) {
            List _documentChanges = this.edit.getDocumentChanges();
            TextDocumentEdit _textDocumentEdit = new TextDocumentEdit();
            Procedures.Procedure1 _function = it -> {
                VersionedTextDocumentIdentifier _versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier();
                Procedures.Procedure1 _function_1 = it_1 -> {
                    it_1.setUri(theUri);
                    it_1.setVersion(document.getVersion());
                };
                VersionedTextDocumentIdentifier _doubleArrow = (VersionedTextDocumentIdentifier)ObjectExtensions.operator_doubleArrow((Object)_versionedTextDocumentIdentifier, (Procedures.Procedure1)_function_1);
                it.setTextDocument(_doubleArrow);
                it.setEdits((List)Conversions.doWrapArray((Object)textEdits));
            };
            TextDocumentEdit _doubleArrow = (TextDocumentEdit)ObjectExtensions.operator_doubleArrow((Object)_textDocumentEdit, (Procedures.Procedure1)_function);
            Either _forLeft = Either.forLeft((Object)_doubleArrow);
            _xifexpression = _documentChanges.add(_forLeft);
        } else {
            _xifexpression = this.edit.getChanges().put(theUri, (List)Conversions.doWrapArray((Object)textEdits));
        }
        return _xifexpression;
    }

    protected void handleReplacements(IEmfResourceChange change) {
        if (change instanceof ITextDocumentChange) {
            this._handleReplacements((ITextDocumentChange)change);
            return;
        }
        if (change != null) {
            this._handleReplacements(change);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(change).toString());
    }

    public static class Factory {
        @Inject
        protected IResourceServiceProvider.Registry registry;
        @Inject
        protected UriExtensions uriExtensions;

        public ChangeConverter2 create(WorkspaceEdit edit, ILanguageServerAccess access) {
            return new ChangeConverter2(this.registry, edit, access, this.uriExtensions);
        }
    }
}

