/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public interface ILanguageServerAccess {
    public <T> CompletableFuture<T> doRead(String var1, Function<Context, T> var2);

    public <T> CompletableFuture<T> doReadIndex(Function<? super IndexContext, ? extends T> var1);

    public void addBuildListener(IBuildListener var1);

    public LanguageClient getLanguageClient();

    public ResourceSet newLiveScopeResourceSet(URI var1);

    public InitializeParams getInitializeParams();

    public InitializeResult getInitializeResult();

    public static interface IBuildListener {
        public void afterBuild(List<IResourceDescription.Delta> var1);
    }

    @Data
    public static class IndexContext {
        private final IResourceDescriptions index;
        private final CancelIndicator cancelChecker;

        public IndexContext(IResourceDescriptions index, CancelIndicator cancelChecker) {
            this.index = index;
            this.cancelChecker = cancelChecker;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            return 31 * result + (this.cancelChecker == null ? 0 : this.cancelChecker.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexContext other = (IndexContext)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            return !(this.cancelChecker == null ? other.cancelChecker != null : !this.cancelChecker.equals(other.cancelChecker));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("index", (Object)this.index);
            b.add("cancelChecker", (Object)this.cancelChecker);
            return b.toString();
        }

        @Pure
        public IResourceDescriptions getIndex() {
            return this.index;
        }

        @Pure
        public CancelIndicator getCancelChecker() {
            return this.cancelChecker;
        }
    }

    @Data
    public static class Context {
        private final Resource resource;
        private final Document document;
        private final boolean isDocumentOpen;
        private final CancelIndicator cancelChecker;

        public Context(Resource resource, Document document, boolean isDocumentOpen, CancelIndicator cancelChecker) {
            this.resource = resource;
            this.document = document;
            this.isDocumentOpen = isDocumentOpen;
            this.cancelChecker = cancelChecker;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
            result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
            result = 31 * result + (this.isDocumentOpen ? 1231 : 1237);
            return 31 * result + (this.cancelChecker == null ? 0 : this.cancelChecker.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
                return false;
            }
            if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
                return false;
            }
            if (other.isDocumentOpen != this.isDocumentOpen) {
                return false;
            }
            return !(this.cancelChecker == null ? other.cancelChecker != null : !this.cancelChecker.equals(other.cancelChecker));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("resource", (Object)this.resource);
            b.add("document", (Object)this.document);
            b.add("isDocumentOpen", (Object)this.isDocumentOpen);
            b.add("cancelChecker", (Object)this.cancelChecker);
            return b.toString();
        }

        @Pure
        public Resource getResource() {
            return this.resource;
        }

        @Pure
        public Document getDocument() {
            return this.document;
        }

        @Pure
        public boolean isDocumentOpen() {
            return this.isDocumentOpen;
        }

        @Pure
        public CancelIndicator getCancelChecker() {
            return this.cancelChecker;
        }
    }
}

