/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class ExpressionInformationControlCreator
implements IInformationControlCreator {
    public IInformationControl createInformationControl(Shell parent) {
        return new ExpressionInformationControl(parent, false);
    }

    private static Color getSystemForegroundColor() {
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color foreground = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_FOREGROUND");
        if (foreground == null) {
            return JFaceColors.getInformationViewerForegroundColor((Display)Display.getDefault());
        }
        return foreground;
    }

    public static Color getSystemBackgroundColor() {
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color background = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_BACKGROUND");
        if (background == null) {
            return JFaceColors.getInformationViewerBackgroundColor((Display)Display.getDefault());
        }
        return background;
    }

    class ExpressionInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private static final String HEIGHT = "HEIGHT";
        private static final String WIDTH = "WIDTH";
        private static final String SASH_WEIGHT_TREE = "SashWeightTree";
        private static final String SASH_WEIGHT_DETAILS = "SashWeightDetails";
        private IVariable fVariable;
        private IPresentationContext fContext;
        private TreeModelViewer fViewer;
        private SashForm fSashForm;
        private Composite fDetailPaneComposite;
        private DetailPaneProxy fDetailPane;
        private Tree fTree;

        ExpressionInformationControl(Shell parentShell, boolean resize) {
            super(parentShell, resize);
            this.create();
        }

        public Point computeSizeHint() {
            int y;
            int x;
            IDialogSettings settings = this.getDialogSettings(false);
            if (settings != null && (x = this.getIntSetting(settings, WIDTH)) > 0 && (y = this.getIntSetting(settings, HEIGHT)) > 0) {
                return new Point(x, y);
            }
            return super.computeSizeHint();
        }

        private IDialogSettings getDialogSettings(boolean create) {
            IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
            if (section == null & create) {
                section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
            }
            return section;
        }

        private int getIntSetting(IDialogSettings settings, String key) {
            try {
                return settings.getInt(key);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        public void dispose() {
            this.persistSettings(this.getShell());
            this.fContext.dispose();
            super.dispose();
        }

        private void persistSettings(Shell shell) {
            if (shell != null && !shell.isDisposed() && this.isResizable()) {
                IDialogSettings settings = this.getDialogSettings(true);
                Point size = shell.getSize();
                settings.put(WIDTH, size.x);
                settings.put(HEIGHT, size.y);
                int[] weights = this.fSashForm.getWeights();
                settings.put(SASH_WEIGHT_TREE, weights[0]);
                settings.put(SASH_WEIGHT_DETAILS, weights[1]);
            }
        }

        public void setVisible(boolean visible) {
            if (!visible) {
                this.persistSettings(this.getShell());
            }
            super.setVisible(visible);
        }

        protected void createContent(Composite parent) {
            StructuredViewer structuredViewer;
            int i;
            this.fSashForm = new SashForm(parent, parent.getStyle());
            this.fSashForm.setOrientation(512);
            AbstractDebugView view = this.getViewToEmulate();
            this.fContext = new PresentationContext("org.eclipse.debug.ui.VariableView");
            if (view != null) {
                IPresentationContext copy = ((TreeModelViewer)view.getViewer()).getPresentationContext();
                String[] properties = copy.getProperties();
                i = 0;
                while (i < properties.length) {
                    String key = properties[i];
                    this.fContext.setProperty(key, copy.getProperty(key));
                    ++i;
                }
            }
            this.fViewer = new TreeModelViewer((Composite)this.fSashForm, 0x1000000A, this.fContext);
            this.fViewer.setAutoExpandLevel(1);
            if (view != null && (structuredViewer = (StructuredViewer)view.getViewer()) != null) {
                ViewerFilter[] filters = structuredViewer.getFilters();
                i = 0;
                while (i < filters.length) {
                    this.fViewer.addFilter(filters[i]);
                    ++i;
                }
            }
            this.fDetailPaneComposite = SWTFactory.createComposite((Composite)this.fSashForm, (int)1, (int)1, (int)1808);
            Layout layout = this.fDetailPaneComposite.getLayout();
            if (layout instanceof GridLayout) {
                GridLayout gl = (GridLayout)layout;
                gl.marginHeight = 0;
                gl.marginWidth = 0;
            }
            this.fDetailPane = new DetailPaneProxy((IDetailPaneContainer)new DetailPaneContainer());
            this.fDetailPane.display(null);
            this.fTree = this.fViewer.getTree();
            this.fTree.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ExpressionInformationControl.this.fDetailPane.display((IStructuredSelection)ExpressionInformationControl.this.fViewer.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.initSashWeights();
            this.fViewer.addViewerUpdateListener(new IViewerUpdateListener(){

                public void viewerUpdatesComplete() {
                }

                public void viewerUpdatesBegin() {
                }

                public void updateStarted(IViewerUpdate update) {
                }

                public void updateComplete(IViewerUpdate update) {
                    if (update instanceof IChildrenUpdate) {
                        TreeSelection selection = new TreeSelection(new TreePath(new Object[]{ExpressionInformationControl.this.fVariable}));
                        ExpressionInformationControl.this.fViewer.setSelection((ISelection)selection);
                        ExpressionInformationControl.this.fDetailPane.display((IStructuredSelection)selection);
                        ExpressionInformationControl.this.fViewer.removeViewerUpdateListener((IViewerUpdateListener)this);
                    }
                }
            });
            this.setForegroundColor(ExpressionInformationControlCreator.getSystemForegroundColor());
            this.setBackgroundColor(ExpressionInformationControlCreator.getSystemBackgroundColor());
        }

        private AbstractDebugView getViewToEmulate() {
            IWorkbenchPage page = JDIDebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
            AbstractDebugView expressionsView = (AbstractDebugView)page.findView("org.eclipse.debug.ui.ExpressionView");
            if (expressionsView != null && expressionsView.isVisible()) {
                return expressionsView;
            }
            AbstractDebugView variablesView = (AbstractDebugView)page.findView("org.eclipse.debug.ui.VariableView");
            if (variablesView != null && variablesView.isVisible()) {
                return variablesView;
            }
            if (expressionsView != null) {
                return expressionsView;
            }
            return variablesView;
        }

        protected void initSashWeights() {
            int details;
            int tree;
            IDialogSettings settings = this.getDialogSettings(false);
            if (settings != null && (tree = this.getIntSetting(settings, SASH_WEIGHT_TREE)) > 0 && (details = this.getIntSetting(settings, SASH_WEIGHT_DETAILS)) > 0) {
                this.fSashForm.setWeights(new int[]{tree, details});
            }
        }

        public void setForegroundColor(Color foreground) {
            super.setForegroundColor(foreground);
            this.fDetailPaneComposite.setForeground(foreground);
            this.fTree.setForeground(foreground);
        }

        public void setBackgroundColor(Color background) {
            super.setBackgroundColor(background);
            this.fDetailPaneComposite.setBackground(background);
            this.fTree.setBackground(background);
        }

        public void setFocus() {
            super.setFocus();
            this.fTree.setFocus();
        }

        public boolean hasContents() {
            return this.fVariable != null;
        }

        public void setInput(Object input) {
            if (input instanceof IVariable) {
                this.fVariable = (IVariable)input;
                this.fViewer.setInput((Object)new TreeRoot());
            }
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return new ExpressionInformationControlCreator(){

                @Override
                public IInformationControl createInformationControl(Shell shell) {
                    return new ExpressionInformationControl(shell, true);
                }
            };
        }

        private class DetailPaneContainer
        implements IDetailPaneContainer {
            private DetailPaneContainer() {
            }

            public String getCurrentPaneID() {
                return ExpressionInformationControl.this.fDetailPane.getCurrentPaneID();
            }

            public IStructuredSelection getCurrentSelection() {
                return (IStructuredSelection)ExpressionInformationControl.this.fViewer.getSelection();
            }

            public void refreshDetailPaneContents() {
                ExpressionInformationControl.this.fDetailPane.display(this.getCurrentSelection());
            }

            public Composite getParentComposite() {
                return ExpressionInformationControl.this.fDetailPaneComposite;
            }

            public IWorkbenchPartSite getWorkbenchPartSite() {
                return null;
            }

            public void paneChanged(String newPaneID) {
                if (newPaneID.equals(DefaultDetailPane.ID)) {
                    ExpressionInformationControl.this.fDetailPane.getCurrentControl().setForeground(ExpressionInformationControlCreator.getSystemForegroundColor());
                    ExpressionInformationControl.this.fDetailPane.getCurrentControl().setBackground(ExpressionInformationControlCreator.getSystemBackgroundColor());
                }
            }
        }

        private class TreeRoot
        extends ElementContentProvider {
            private TreeRoot() {
            }

            protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
                return 1;
            }

            protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
                return new Object[]{ExpressionInformationControl.this.fVariable};
            }

            protected boolean supportsContextId(String id) {
                return true;
            }
        }
    }
}

