/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.validation.constraints;

import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.aas.AASEndpoint;
import org.eclipse.papyrus.aas.Asset;
import org.eclipse.papyrus.aas.AssetAdministrationShell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AssetEndpointAddressConstraint
extends AbstractModelConstraint {
    private final UrlValidator urlValidator = new UrlValidator(11L);
    private final DomainValidator domainValidator = DomainValidator.getInstance((boolean)true);
    private final InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();

    public IStatus validate(IValidationContext ctx) {
        IStatus status = ctx.createSuccessStatus();
        if (ctx.getTarget() instanceof NamedElement) {
            String address;
            AASEndpoint ep2;
            NamedElement elt = (NamedElement)ctx.getTarget();
            Asset asset = (Asset)UMLUtil.getStereotypeApplication((Element)elt, Asset.class);
            AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)elt, AssetAdministrationShell.class);
            if (asset != null && elt instanceof Class && asset.getEndpoint() != null && !asset.getEndpoint().isEmpty()) {
                for (AASEndpoint ep2 : asset.getEndpoint()) {
                    if (ep2.getAddress() == null || ep2.getAddress().isEmpty() || this.urlValidator.isValid(ep2.getAddress())) continue;
                    return ctx.createFailureStatus(new Object[]{"The URL is not valid"});
                }
            }
            if (aas != null && elt instanceof Class && aas.getEndpoint() != null && (address = (ep2 = aas.getEndpoint()).getAddress()) != null && !address.isEmpty() && !this.inetAddressValidator.isValid(address) && !this.domainValidator.isValid(address)) {
                return ctx.createFailureStatus(new Object[]{"The URL is not valid"});
            }
        }
        return status;
    }
}

