/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.api.aas;

import io.adminshell.aas.v3.model.IdentifierType;
import io.adminshell.aas.v3.model.Reference;
import io.adminshell.aas.v3.model.impl.DefaultAssetAdministrationShell;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aas.api.aas.parts.ConceptDictionary;
import org.eclipse.aas.api.asset.Asset;
import org.eclipse.aas.api.communications.AASEndpoint;
import org.eclipse.aas.api.submodel.SubModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetAdministrationShell
extends DefaultAssetAdministrationShell {
    private static final Logger logger = LoggerFactory.getLogger(AssetAdministrationShell.class);
    private Asset asset;
    private AASEndpoint aasEndpoint;
    private List<SubModel> subModels = new ArrayList<SubModel>();
    private ConceptDictionary conceptDictionary;

    public AssetAdministrationShell(String idShort) {
        super.setIdShort(idShort);
        logger.info("Asset Administration Shell Class initialised with just idShort.");
    }

    public AssetAdministrationShell(String idShort, AASEndpoint aasEndpoint) {
        super.setIdShort(idShort);
        this.aasEndpoint = aasEndpoint;
        logger.info("Asset Administration Shell Class initialised with just idShort and an Endpoint.");
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public AASEndpoint getAASEndpoint() {
        return this.aasEndpoint;
    }

    public void setEndpoint(AASEndpoint aasEndpoint) {
        this.aasEndpoint = aasEndpoint;
    }

    public IdentifierType getIdType() {
        return super.getIdentification().getIdType();
    }

    public void setIdType(IdentifierType idType) {
        this.identification.setIdType(idType);
    }

    public String getId() {
        return super.getIdentification().getIdentifier();
    }

    public void setId(String id) {
        this.identification.setIdentifier(id);
    }

    public List<SubModel> getSubModels() {
        return this.subModels;
    }

    @Deprecated
    public List<Reference> getSubmodels() {
        return super.getSubmodels();
    }

    public void setSubModels(List<SubModel> subModels) {
        this.subModels = subModels;
    }

    public void setSubModels(SubModel ... subModels) {
        SubModel[] subModelArray = subModels;
        int n = subModels.length;
        int n2 = 0;
        while (n2 < n) {
            SubModel subModel = subModelArray[n2];
            this.subModels.add(subModel);
            ++n2;
        }
    }

    @Deprecated
    public void setSubmodels(List<Reference> submodels) {
        super.setSubmodels(submodels);
    }

    public ConceptDictionary getConceptDictionary() {
        return this.conceptDictionary;
    }

    public void setConceptDictionary(ConceptDictionary conceptDictionary) {
        this.conceptDictionary = conceptDictionary;
    }
}

