/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.uml.tools.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeUtil {
    protected static final String QUOTE = "\"";
    public static final String SPACE_SEPARATOR = "#";
    public static final String EQUAL_SEPARATOR = "=";
    public static final String PROPERTY_VALUE_SEPARATOR = "|";
    public static final String SETREOTYPE_WITH_VALUE_SEPARATOR = ";";
    protected static final String ST_LEFT = String.valueOf("\u00ab");
    protected static final String ST_RIGHT = String.valueOf("\u00bb");
    public static final String BASE_PREFIX = "base_";

    public static List<Stereotype> getAllSuperStereotypes(Stereotype stereotype) {
        ArrayList<Stereotype> generalStereotypes = new ArrayList<Stereotype>();
        for (Classifier generalClassifier : stereotype.getGenerals()) {
            if (!(generalClassifier instanceof Stereotype)) continue;
            generalStereotypes.add((Stereotype)generalClassifier);
            generalStereotypes.addAll(StereotypeUtil.getAllSuperStereotypes((Stereotype)generalClassifier));
        }
        return generalStereotypes;
    }

    protected static List<String> getStereoPropertiesToDisplay(Stereotype stereotype, List<String> stPropList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String currentProp : stPropList) {
            if (!currentProp.substring(0, currentProp.lastIndexOf(".")).equals(stereotype.getQualifiedName())) continue;
            result.add(currentProp.substring(currentProp.lastIndexOf(".") + 1, currentProp.length()));
        }
        return result;
    }

    public static Property getPropertyByName(Stereotype stereotype, String propertyName) {
        for (Property tmpProperty : stereotype.getAllAttributes()) {
            String name = "";
            if (tmpProperty != null) {
                String string = name = tmpProperty.getName() != null ? tmpProperty.getName() : "";
            }
            if (!name.equals(propertyName)) continue;
            return tmpProperty;
        }
        return null;
    }

    protected static String getPropertyValueForEnumerationType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR) {
        Object val;
        Object out = "";
        out = property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null ? (property.getLower() != 0 || umlElement.getValue(stereotype, property.getName()) != null ? (property.getDefaultValue() != null || umlElement.getValue(stereotype, property.getName()) != null ? ((val = umlElement.getValue(stereotype, property.getName())) instanceof EnumerationLiteral ? property.getName() + EQUAL_SEPARATOR + ((EnumerationLiteral)val).getLabel() + PROPERTY_VALUE_SEPARATOR : property.getName() + EQUAL_SEPARATOR + String.valueOf(val) + PROPERTY_VALUE_SEPARATOR) : property.getName() + PROPERTY_VALUE_SEPARATOR) : property.getName() + PROPERTY_VALUE_SEPARATOR) : property.getName() + EQUAL_SEPARATOR + String.valueOf(umlElement.getValue(stereotype, property.getName())) + PROPERTY_VALUE_SEPARATOR;
        return out;
    }

    protected static String getPropertyValueOnlyForEnumerationType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR) {
        Object val;
        Object out = "";
        out = property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null ? (property.getLower() != 0 || umlElement.getValue(stereotype, property.getName()) != null ? (property.getDefaultValue() != null || umlElement.getValue(stereotype, property.getName()) != null ? ((val = umlElement.getValue(stereotype, property.getName())) instanceof EnumerationLiteral ? ((EnumerationLiteral)val).getLabel() + PROPERTY_VALUE_SEPARATOR : String.valueOf(val) + PROPERTY_VALUE_SEPARATOR) : PROPERTY_VALUE_SEPARATOR) : PROPERTY_VALUE_SEPARATOR) : String.valueOf(umlElement.getValue(stereotype, property.getName())) + PROPERTY_VALUE_SEPARATOR;
        return out;
    }

    protected static String getPropertyValueForMetaclassType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withQualifiedName) {
        Object out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null && umlElement.getValue(stereotype, property.getName()) instanceof NamedElement) {
            out = withQualifiedName ? property.getName() + EQUAL_SEPARATOR + ((NamedElement)umlElement.getValue(stereotype, property.getName())).getQualifiedName() + PROPERTY_VALUE_SEPARATOR : property.getName() + EQUAL_SEPARATOR + ((NamedElement)umlElement.getValue(stereotype, property.getName())).getName() + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> elementNames = new ArrayList<String>();
            if (values != null) {
                int count = 0;
                while (count < values.size()) {
                    if (values.get(count) instanceof NamedElement) {
                        if (withQualifiedName) {
                            elementNames.add(((NamedElement)values.get(count)).getQualifiedName());
                        } else {
                            elementNames.add(((NamedElement)values.get(count)).getName());
                        }
                    }
                    ++count;
                }
            }
            out = property.getName() + EQUAL_SEPARATOR + String.valueOf(elementNames) + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = property.getName() + EQUAL_SEPARATOR + String.valueOf(umlElement.getValue(stereotype, property.getName())) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    protected static String getPropertyValueOnlyForMetaclassType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withQualifiedName) {
        Object out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null && umlElement.getValue(stereotype, property.getName()) instanceof NamedElement) {
            out = withQualifiedName ? ((NamedElement)umlElement.getValue(stereotype, property.getName())).getQualifiedName() + PROPERTY_VALUE_SEPARATOR : ((NamedElement)umlElement.getValue(stereotype, property.getName())).getName() + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> elementNames = new ArrayList<String>();
            if (values != null) {
                int count = 0;
                while (count < values.size()) {
                    if (values.get(count) instanceof NamedElement) {
                        if (withQualifiedName) {
                            elementNames.add(((NamedElement)values.get(count)).getQualifiedName());
                        } else {
                            elementNames.add(((NamedElement)values.get(count)).getName());
                        }
                    }
                    ++count;
                }
            }
            out = String.valueOf(elementNames) + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = String.valueOf(umlElement.getValue(stereotype, property.getName())) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    protected static String getPropertyValueForStereotypeType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withQualifiedName) {
        Object out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null) {
            Object value = umlElement.getValue(stereotype, property.getName());
            Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
            out = withQualifiedName ? property.getName() + EQUAL_SEPARATOR + ((NamedElement)baseElement).getQualifiedName() + PROPERTY_VALUE_SEPARATOR : property.getName() + EQUAL_SEPARATOR + ((NamedElement)baseElement).getName() + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> baseElements = new ArrayList<String>();
            if (values != null) {
                int k = 0;
                while (k < values.size()) {
                    Element base = UMLUtil.getBaseElement((EObject)((EObject)values.get(k)));
                    if (base instanceof NamedElement) {
                        if (withQualifiedName) {
                            baseElements.add(((NamedElement)base).getQualifiedName());
                        } else {
                            baseElements.add(((NamedElement)base).getName());
                        }
                    }
                    ++k;
                }
            }
            out = property.getName() + EQUAL_SEPARATOR + String.valueOf(baseElements) + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = property.getName() + EQUAL_SEPARATOR + String.valueOf(umlElement.getValue(stereotype, property.getName())) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    protected static String getPropertyValueOnlyForStereotypeType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withQualifiedName) {
        Object out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null) {
            Object value = umlElement.getValue(stereotype, property.getName());
            Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
            out = withQualifiedName ? ((NamedElement)baseElement).getQualifiedName() + PROPERTY_VALUE_SEPARATOR : ((NamedElement)baseElement).getName() + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> baseElements = new ArrayList<String>();
            if (values != null) {
                int k = 0;
                while (k < values.size()) {
                    if (withQualifiedName) {
                        baseElements.add(((NamedElement)UMLUtil.getBaseElement((EObject)((EObject)values.get(k)))).getQualifiedName());
                    } else {
                        baseElements.add(((NamedElement)UMLUtil.getBaseElement((EObject)((EObject)values.get(k)))).getName());
                    }
                    ++k;
                }
            }
            out = String.valueOf(baseElements) + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = String.valueOf(umlElement.getValue(stereotype, property.getName())) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    public static final List<Property> getStereotypePropertiesWithoutBaseProperties(Stereotype stereotype) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property property : stereotype.getOwnedAttributes()) {
            if (!StereotypeUtil.isValidStereotypeProperty(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    public static final List<Property> getAllStereotypePropertiesWithoutBaseProperties(Stereotype stereotype) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property property : stereotype.getAllAttributes()) {
            if (!StereotypeUtil.isValidStereotypeProperty(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    public static final boolean isValidStereotypeProperty(Property property) {
        Association association = property.getAssociation();
        if (association instanceof Extension) {
            Extension ext = (Extension)association;
            Class metaClass = ext.getMetaclass();
            if (property.getName().equals(BASE_PREFIX + metaClass.getName())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isApplied(Element element, String str_name) {
        return element.getAppliedStereotype(str_name) != null;
    }

    public static boolean isApplied(Element element, java.lang.Class<? extends EObject> clazz) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (!clazz.isAssignableFrom(stereoApplication.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isApplicable(Element element, java.lang.Class<? extends EObject> clazz) {
        return StereotypeUtil.getStereoName(element, clazz) != null;
    }

    public static Stereotype apply(Element element, String stereo_name) {
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null) {
            boolean alreadyApplied;
            EList subStereos = element.getAppliedSubstereotypes(stereotype);
            boolean bl = alreadyApplied = subStereos.size() > 0;
            if (!alreadyApplied && element.getStereotypeApplication(stereotype) == null) {
                element.applyStereotype(stereotype);
            }
        }
        return stereotype;
    }

    public static Stereotype applyExact(Element element, String stereo_name) {
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null && element.getStereotypeApplication(stereotype) == null) {
            element.applyStereotype(stereotype);
        }
        return stereotype;
    }

    public static void unapply(Element element, String stereo_name) {
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null && element.getStereotypeApplication(stereotype) != null) {
            element.unapplyStereotype(stereotype);
        }
    }

    public static <T extends EObject> T applyApp(Element element, java.lang.Class<T> clazz) {
        if (StereotypeUtil.apply(element, clazz) != null) {
            return (T)UMLUtil.getStereotypeApplication((Element)element, clazz);
        }
        return null;
    }

    public static Stereotype apply(Element element, java.lang.Class<? extends EObject> clazz) {
        String qualifiedSN = StereotypeUtil.getStereoName(element, clazz);
        if (qualifiedSN != null) {
            return StereotypeUtil.apply(element, qualifiedSN);
        }
        return null;
    }

    public static void unapply(Element element, java.lang.Class<? extends EObject> clazz) {
        String qualifiedSN = StereotypeUtil.getStereoName(element, clazz);
        if (qualifiedSN != null) {
            StereotypeUtil.unapply(element, qualifiedSN);
        }
    }

    public static String getStereoName(Element element, java.lang.Class<? extends EObject> clazz) {
        String pkgName = clazz.getPackage().getName();
        EList appliedProfiles = element.getNearestPackage().getAllAppliedProfiles();
        for (Profile appliedProfile : appliedProfiles) {
            String defClassName;
            EPackage definition = appliedProfile.getDefinition();
            if (definition == null || (defClassName = definition.getClass().getName()) == null || !defClassName.startsWith(pkgName)) continue;
            return appliedProfile.getQualifiedName() + "::" + clazz.getSimpleName();
        }
        return null;
    }

    public static List<Stereotype> getAllStereotypes(Profile profile) {
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>((Collection<Stereotype>)profile.getOwnedStereotypes());
        stereotypes.addAll(StereotypeUtil.getStereotypeInMembers((List<NamedElement>)profile.getOwnedMembers()));
        return stereotypes;
    }

    protected static List<Stereotype> getStereotypeInMembers(List<NamedElement> members) {
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        for (NamedElement member : members) {
            if (member instanceof Package) {
                stereotypes.addAll((Collection<Stereotype>)((Package)member).getOwnedStereotypes());
            }
            if (!(member instanceof Namespace)) continue;
            stereotypes.addAll(StereotypeUtil.getStereotypeInMembers((List<NamedElement>)((Namespace)member).getOwnedMembers()));
        }
        return stereotypes;
    }
}

