/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.infra.base.RunnableWithResult;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationRTException;
import org.eclipse.papyrus.designer.transformation.core.sync.DepPlanSync;
import org.eclipse.papyrus.designer.transformation.core.sync.InterfaceSync;
import org.eclipse.papyrus.designer.transformation.ui.Messages;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public class SyncHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Property) {
            this.selectedEObject = ((Property)this.selectedEObject).getType();
        }
        if (this.selectedEObject instanceof Interface) {
            return true;
        }
        return this.selectedEObject instanceof Package;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedEObject instanceof Property) {
            this.selectedEObject = ((Property)this.selectedEObject).getType();
        }
        if (this.selectedEObject instanceof Interface) {
            final Interface selectedIntf = (Interface)this.selectedEObject;
            CommandSupport.exec((EObject)selectedIntf, (String)"Synchronize interface", (Runnable)new Runnable(){

                @Override
                public void run() {
                    InterfaceSync.syncSignalReceptionSupport((Interface)selectedIntf);
                }
            });
        }
        if (this.selectedEObject instanceof Package) {
            final Package selectedPkg = (Package)this.selectedEObject;
            CommandSupport.exec((EObject)selectedPkg, (String)"Synchronize deployment plan", (RunnableWithResult)new RunnableWithResult(){

                public IStatus run() {
                    try {
                        DepPlanSync.syncDepPlan((Package)selectedPkg);
                        return Status.CANCEL_STATUS;
                    }
                    catch (TransformationRTException e) {
                        Shell shell = Display.getCurrent().getActiveShell();
                        MessageDialog.openError((Shell)shell, (String)Messages.SyncHandler_CANNOT_SYNCHRONIZE, (String)e.getMessage());
                        return Status.error((String)Messages.SyncHandler_CANNOT_SYNCHRONIZE, (Throwable)e);
                    }
                }
            });
        }
        return null;
    }
}

