/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.IProjectExplorerNodeVisitor;

public class ProjectExplorerNodeWalker {
    protected IProjectExplorerNodeVisitor visitor;

    public ProjectExplorerNodeWalker(IProjectExplorerNodeVisitor visitor) {
        this.visitor = visitor;
    }

    public void visit(List<Object> nodes) {
        this.doSwitch(nodes);
    }

    protected void doSwitch(List<Object> nodes) {
        for (Object node : nodes) {
            this.doSwitch(node);
        }
    }

    protected void doSwitch(Object node) {
        if (node instanceof ICompilationUnit) {
            this.visitICompilationUnit((ICompilationUnit)node);
        } else if (node instanceof IClassFile) {
            this.visitIClassFile((IClassFile)node);
        } else if (node instanceof IPackageFragment) {
            this.visitIPackageFragment((IPackageFragment)node);
        } else if (node instanceof IPackageFragmentRoot) {
            this.visitIPackageFragmentRoot((IPackageFragmentRoot)node);
        } else if (node instanceof IJavaProject) {
            this.visitIJavaProject((IJavaProject)node);
        } else if (node instanceof IProject) {
            this.visitIProject((IProject)node);
        } else if (node instanceof IClasspathContainer) {
            this.visitIClasspathContainer((IClasspathContainer)node);
        } else {
            System.err.println("Skip node of type " + String.valueOf(node.getClass()));
        }
    }

    private void visitIClasspathContainer(IClasspathContainer node) {
        this.visitor.visitIClasspathContainer(node);
    }

    private void visitIProject(IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                this.visitIJavaProject(javaProject);
            } else {
                this.visitor.visitIProject(project);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void visitIJavaProject(IJavaProject node) {
        this.visitor.visitIJavaProject(node);
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = node.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot child = iPackageFragmentRootArray[n2];
                switch (child.getKind()) {
                    case 1: {
                        this.doSwitch(child);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void visitIPackageFragmentRoot(IPackageFragmentRoot node) {
        this.visitor.visitIPackageFragmentRoot(node);
        try {
            IJavaElement[] iJavaElementArray = node.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.doSwitch(child);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void visitIClassFile(IClassFile node) {
        this.visitor.visitIClassFile(node);
    }

    private void visitIPackageFragment(IPackageFragment node) {
        this.visitor.visitIPackageFragment(node);
        try {
            IJavaElement[] iJavaElementArray = node.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.doSwitch(child);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void visitICompilationUnit(ICompilationUnit node) {
        this.visitor.visitICompilationUnit(node);
    }
}

