/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.view.panels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.view.panels.CppAbstractPanel;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Parameter;

@Deprecated
public class CppParameterPanel
extends CppAbstractPanel {
    private Button isConst;
    private Parameter selectedParameter;
    private IDocument docPtr;
    private IDocument docRef;
    private IDocument docArray;
    private IDocument docDefault;
    private SourceViewer viewerPtr;
    private SourceViewer viewerRef;
    private SourceViewer viewerArray;
    private SourceViewer viewerDefault;
    private Group groupPtr;
    private Group groupRef;
    private Group groupArray;
    private Group groupDefault;

    public CppParameterPanel(Composite parent, int style) {
        super(parent, style);
    }

    public Parameter getSelectedElement() {
        return this.selectedParameter;
    }

    @Override
    public void setSelectedElement(Element newElement) {
        super.setSelectedElement(newElement);
        if (!(newElement instanceof Parameter)) {
            throw new RuntimeException("bad selection: " + String.valueOf(newElement) + " should be an uml2 Parameter");
        }
        this.selectedParameter = (Parameter)newElement;
    }

    @Override
    public Control createContent() {
        this.createSaveResetButtons();
        this.isConst = this.createButton("isConst", this, null);
        this.addStereotypeSelectionListener(this.isConst, "Const");
        this.docPtr = this.createDocument();
        this.groupPtr = this.createGroup(this, "Pointer declaration", (Control)this.buttonSave, null, false, 0, 25, false);
        this.viewerPtr = this.createViewer(this.docPtr, this.groupPtr);
        this.docRef = this.createDocument();
        this.groupRef = this.createGroup(this, "Reference declaration", (Control)this.buttonSave, (Control)this.groupPtr, false, 0, 50, false);
        this.viewerRef = this.createViewer(this.docRef, this.groupRef);
        this.docDefault = this.createDocument();
        this.groupDefault = this.createGroup(this, "Default value", (Control)this.buttonSave, (Control)this.groupRef, false, 0, 75, false);
        this.viewerDefault = this.createViewer(this.docDefault, this.groupDefault);
        this.docArray = this.createDocument();
        this.groupArray = this.createGroup(this, "Array value ([...])", (Control)this.buttonSave, (Control)this.groupDefault, true, 0, 0, false);
        this.viewerArray = this.createViewer(this.docArray, this.groupArray);
        return this;
    }

    @Override
    public void save() {
        if (this.selectedParameter != null) {
            CommandSupport.exec((EObject)this.selectedParameter, (String)"C++ parameter save", (Runnable)new Runnable(){

                @Override
                public void run() {
                    String newPtr = CppParameterPanel.this.docPtr.get();
                    if (newPtr.equals("")) {
                        StereotypeUtil.unapply((Element)CppParameterPanel.this.selectedParameter, Ptr.class);
                    } else {
                        StereotypeUtil.apply((Element)CppParameterPanel.this.selectedParameter, Ptr.class);
                    }
                    String newRef = CppParameterPanel.this.docRef.get();
                    if (newRef.equals("")) {
                        StereotypeUtil.unapply((Element)CppParameterPanel.this.selectedParameter, Ref.class);
                    } else {
                        StereotypeUtil.apply((Element)CppParameterPanel.this.selectedParameter, Ref.class);
                    }
                    String newArray = CppParameterPanel.this.docArray.get();
                    if (newArray.equals("")) {
                        StereotypeUtil.unapply((Element)CppParameterPanel.this.selectedParameter, Array.class);
                    } else {
                        StereotypeUtil.apply((Element)CppParameterPanel.this.selectedParameter, Array.class);
                    }
                }
            });
        }
    }

    @Override
    protected void refreshPanel() {
        if (this.selectedParameter != null) {
            this.isConst.setSelection(StereotypeUtil.isApplied((Element)this.selectedParameter, Const.class));
            this.docPtr.set(StereotypeUtil.isApplied((Element)this.selectedParameter, Ptr.class) ? "*" : "");
            this.docRef.set(StereotypeUtil.isApplied((Element)this.selectedParameter, Ref.class) ? "&" : "");
            this.docDefault.set(this.selectedParameter.getDefault());
            this.docArray.set(StereotypeUtil.isApplied((Element)this.selectedParameter, Array.class) ? "[]" : "");
        }
    }

    protected void checkConst() {
        boolean boxState = this.isConst.getSelection();
        if (boxState) {
            if (!StereotypeUtil.isApplied((Element)this.selectedParameter, Const.class)) {
                StereotypeUtil.apply((Element)this.selectedParameter, Const.class);
            }
        } else if (StereotypeUtil.isApplied((Element)this.selectedParameter, Const.class)) {
            StereotypeUtil.unapply((Element)this.selectedParameter, Const.class);
        }
    }

    @Override
    public void entryAction() {
        super.entryAction();
        this.reset();
    }

    @Override
    public boolean checkModifications() {
        String arrayValue;
        String refValue;
        String ptrValue;
        String string = ptrValue = StereotypeUtil.isApplied((Element)this.selectedParameter, Ptr.class) ? "*" : "";
        if (!this.docPtr.get().equals(ptrValue)) {
            return true;
        }
        String string2 = refValue = StereotypeUtil.isApplied((Element)this.selectedParameter, Ref.class) ? "&" : "";
        if (!this.docRef.get().equals(refValue)) {
            return true;
        }
        String defaultValue = this.selectedParameter.getDefault();
        if (defaultValue == null ? !this.docDefault.get().equals("") : !this.docDefault.get().equals(defaultValue)) {
            return true;
        }
        String string3 = arrayValue = StereotypeUtil.isApplied((Element)this.selectedParameter, Array.class) ? "[]" : "";
        return !this.docArray.get().equals(arrayValue);
    }

    @Override
    protected void updateModel() {
        CommandSupport.exec((EObject)this.selectedParameter, (String)"C++ parameter update", (Runnable)new Runnable(){

            @Override
            public void run() {
                CppParameterPanel.this.checkConst();
            }
        });
    }
}

