/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ASTUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.RoundtripCppUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class DependencyAnalysis {
    private Operation m_operation;
    private IASTFunctionDefinition m_definition;
    private ITranslationUnit m_itu;
    private Classifier m_classifier;
    private Map<String, Type> localVaribaleList = new HashMap<String, Type>();

    public DependencyAnalysis(Operation op, IASTFunctionDefinition definition, ITranslationUnit itu) {
        this.m_operation = op;
        this.m_definition = definition;
        this.m_itu = itu;
        EObject _eContainer = op.eContainer();
        if (_eContainer instanceof Classifier) {
            EObject _eContainer_1 = op.eContainer();
            this.m_classifier = (Classifier)_eContainer_1;
        }
    }

    public void analyzeDependencies() {
        IASTStatement body = this.m_definition.getBody();
        if (body != null) {
            this.analyzeStatement(body);
        }
    }

    private void analyzeStatement(IASTStatement statement) {
        if (statement == null) {
            return;
        }
        boolean _matched = false;
        if (statement instanceof IASTCompoundStatement) {
            _matched = true;
            this.analyzeStatement((IASTCompoundStatement)statement);
        }
        if (!_matched && statement instanceof ICPPASTCatchHandler) {
            _matched = true;
            this.analyzeStatement((ICPPASTCatchHandler)statement);
        }
        if (!_matched && statement instanceof ICPPASTRangeBasedForStatement) {
            _matched = true;
            this.analyzeStatement((ICPPASTRangeBasedForStatement)statement);
        }
        if (!_matched && statement instanceof ICPPASTTryBlockStatement) {
            _matched = true;
            this.analyzeStatement((ICPPASTTryBlockStatement)statement);
        }
        if (!_matched && statement instanceof IASTCaseStatement) {
            _matched = true;
            this.analyzeStatement((IASTCaseStatement)statement);
        }
        if (!_matched && statement instanceof IASTDeclarationStatement) {
            _matched = true;
            this.analyzeStatement((IASTDeclarationStatement)statement);
        }
        if (!_matched && statement instanceof IASTDefaultStatement) {
            _matched = true;
            this.analyzeStatement((IASTDefaultStatement)statement);
        }
        if (!_matched && statement instanceof IASTDoStatement) {
            _matched = true;
            this.analyzeStatement((IASTDoStatement)statement);
        }
        if (!_matched && statement instanceof IASTExpressionStatement) {
            _matched = true;
            this.analyzeStatement((IASTExpressionStatement)statement);
        }
        if (!_matched && statement instanceof IASTForStatement) {
            _matched = true;
            this.analyzeStatement((IASTForStatement)statement);
        }
        if (!_matched && statement instanceof IASTIfStatement) {
            _matched = true;
            this.analyzeStatement((IASTIfStatement)statement);
        }
        if (!_matched && statement instanceof IASTReturnStatement) {
            _matched = true;
            this.analyzeStatement((IASTReturnStatement)statement);
        }
        if (!_matched && statement instanceof IASTSwitchStatement) {
            _matched = true;
            this.analyzeStatement((IASTSwitchStatement)statement);
        }
        if (!_matched && statement instanceof IASTWhileStatement) {
            _matched = true;
            this.analyzeStatement((IASTWhileStatement)statement);
        }
    }

    private void analyzeStatement(IASTCompoundStatement statement) {
        IASTStatement[] statements;
        IASTStatement[] _converted_statements = statements = statement.getStatements();
        Consumer<IASTStatement> _function = it -> this.analyzeStatement((IASTStatement)it);
        ((List)Conversions.doWrapArray((Object)_converted_statements)).forEach(_function);
    }

    private void analyzeStatement(ICPPASTCatchHandler statement) {
    }

    private void analyzeStatement(ICPPASTRangeBasedForStatement statement) {
    }

    private void analyzeStatement(ICPPASTTryBlockStatement statement) {
    }

    private void analyzeStatement(IASTCaseStatement statement) {
    }

    private void analyzeStatement(IASTDeclarationStatement statement) {
        IASTDeclaration _declaration_1;
        IASTSimpleDeclaration declaration;
        IASTDeclaration _declaration = statement.getDeclaration();
        if (_declaration instanceof IASTSimpleDeclaration && (declaration = (IASTSimpleDeclaration)(_declaration_1 = statement.getDeclaration())) != null) {
            Type umlType;
            boolean _not;
            IASTDeclSpecifier specifier = declaration.getDeclSpecifier();
            String typeName = ASTUtils.getCppTypeName(specifier);
            boolean _isPrimitiveCppType = RoundtripCppUtils.isPrimitiveCppType(typeName);
            boolean bl = _not = !_isPrimitiveCppType;
            if (_not && (umlType = ReverseUtils.getUMLType(typeName, (ICElement)this.m_itu)) != null) {
                Consumer<IASTDeclarator> _function = it -> this.localVaribaleList.put(it.getName().toString(), umlType);
                ((List)Conversions.doWrapArray((Object)declaration.getDeclarators())).forEach(_function);
                this.createDependency((NamedElement)umlType);
            }
            Consumer<IASTDeclarator> _function_1 = it -> {
                IASTEqualsInitializer equalsInitialiser;
                IASTInitializerClause clause;
                IASTInitializer initilizer = it.getInitializer();
                if (initilizer != null && initilizer instanceof IASTEqualsInitializer && (clause = (equalsInitialiser = (IASTEqualsInitializer)initilizer).getInitializerClause()) instanceof IASTExpression) {
                    this.analyzeExpression((IASTExpression)clause);
                }
            };
            ((List)Conversions.doWrapArray((Object)declaration.getDeclarators())).forEach(_function_1);
        }
    }

    private void createDependency(NamedElement supplier) {
        Functions.Function1 _function;
        List usages;
        Usage usage;
        Package nearestPack;
        Element _owner = this.m_operation.getOwner();
        if (_owner instanceof NamedElement && (nearestPack = this.m_operation.getNearestPackage()) != null && (usage = (Usage)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)(usages = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)nearestPack.getOwnedElements(), Usage.class))), (Functions.Function1)(_function = it -> it.getClients().contains((Object)this.m_operation.getOwner()) && it.getSuppliers().contains((Object)supplier))))) == null) {
            Element _owner_1 = this.m_operation.getOwner();
            ((NamedElement)_owner_1).createUsage(supplier);
        }
    }

    private void analyzeStatement(IASTDefaultStatement statement) {
    }

    private void analyzeStatement(IASTDoStatement statement) {
        this.analyzeStatement(statement.getBody());
    }

    private void analyzeStatement(IASTExpressionStatement statement) {
        IASTExpression expression = statement.getExpression();
        this.analyzeExpression(expression);
    }

    private Type getTypeOfVariableOrAttribute(String attributeName) {
        Type type = this.localVaribaleList.get(attributeName);
        if (type == null) {
            Functions.Function1 _function = it -> it.getName().equals(attributeName);
            Property attribute = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)this.m_classifier.getAllAttributes(), (Functions.Function1)_function));
            if (attribute != null) {
                type = attribute.getType();
            }
        }
        return type;
    }

    private boolean isSameSignature(Operation op, List<Type> l2) {
        Functions.Function1 _function = it -> {
            ParameterDirectionKind _direction = it.getDirection();
            return !Objects.equals(_direction, ParameterDirectionKind.RETURN_LITERAL);
        };
        Functions.Function1 _function_1 = it -> it.getType();
        List params = ListExtensions.map((List)IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)op.getOwnedParameters(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
        return this.isSameTypeList(params, l2);
    }

    private boolean isSameTypeList(List<Type> l1, List<Type> l2) {
        int _size_1;
        boolean _notEquals;
        int _size = l1.size();
        boolean bl = _notEquals = _size != (_size_1 = l2.size());
        if (_notEquals) {
            return false;
        }
        int i = 0;
        while (i < l1.size()) {
            Type _get_1;
            boolean _notEquals_1;
            Type _get = l1.get(i);
            boolean bl2 = _notEquals_1 = !Objects.equals(_get, _get_1 = l2.get(i));
            if (_notEquals_1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Type analyzeExpression(IASTExpression expression) {
        if (expression == null) {
            return null;
        }
        Type ret = null;
        if (expression instanceof ICPPASTFunctionCallExpression) {
            IASTExpression nameExpression = ((ICPPASTFunctionCallExpression)expression).getFunctionNameExpression();
            IASTInitializerClause[] arguments = ((ICPPASTFunctionCallExpression)expression).getArguments();
            Parameter returnParam = null;
            if (nameExpression instanceof IASTFieldReference) {
                String _rawSignature;
                boolean _equals;
                IASTName functionName = ((IASTFieldReference)nameExpression).getFieldName();
                IASTExpression fieldOwner = ((IASTFieldReference)nameExpression).getFieldOwner();
                Classifier targetClass = null;
                if (fieldOwner instanceof IASTIdExpression) {
                    Type type = this.getTypeOfVariableOrAttribute(((IASTIdExpression)fieldOwner).getName().toString());
                    if (type instanceof Classifier) {
                        targetClass = (Classifier)type;
                    }
                } else if (fieldOwner instanceof IASTLiteralExpression && (_equals = Objects.equals(_rawSignature = ((IASTLiteralExpression)fieldOwner).getRawSignature(), "this"))) {
                    targetClass = this.m_classifier;
                }
                if (targetClass != null) {
                    boolean _greaterThan;
                    Functions.Function1 _function = it -> it.getName().equals(functionName.toString());
                    List sameNameOps = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)targetClass.getAllOperations(), (Functions.Function1)_function));
                    int _size = sameNameOps.size();
                    boolean bl = _greaterThan = _size > 1;
                    if (_greaterThan) {
                        IASTInitializerClause[] _converted_arguments = arguments;
                        Functions.Function1 _function_1 = it -> this.getArgumentType((IASTInitializerClause)it);
                        List currentArgumentTypes = IterableExtensions.toList((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_converted_arguments)), (Functions.Function1)_function_1));
                        Functions.Function1 _function_2 = it -> this.isSameSignature((Operation)it, currentArgumentTypes);
                        Operation targetOp = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)sameNameOps, (Functions.Function1)_function_2));
                        if (targetOp != null) {
                            this.createDependency((NamedElement)targetOp);
                            Functions.Function1 _function_3 = it -> {
                                ParameterDirectionKind _direction = it.getDirection();
                                return Objects.equals(_direction, ParameterDirectionKind.RETURN_LITERAL);
                            };
                            returnParam = (Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)targetOp.getOwnedParameters(), (Functions.Function1)_function_3));
                        }
                    } else {
                        boolean _tripleNotEquals;
                        Operation _head = (Operation)IterableExtensions.head((Iterable)sameNameOps);
                        boolean bl2 = _tripleNotEquals = _head != null;
                        if (_tripleNotEquals) {
                            this.createDependency((NamedElement)IterableExtensions.head((Iterable)sameNameOps));
                            Functions.Function1 _function_4 = it -> {
                                ParameterDirectionKind _direction = it.getDirection();
                                return Objects.equals(_direction, ParameterDirectionKind.RETURN_LITERAL);
                            };
                            returnParam = (Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)((Operation)IterableExtensions.head((Iterable)sameNameOps)).getOwnedParameters(), (Functions.Function1)_function_4));
                        }
                    }
                }
            }
            if (returnParam != null) {
                ret = returnParam.getType();
            }
        } else if (!(expression instanceof IASTFunctionCallExpression)) {
            if (expression instanceof ICPPASTNewExpression) {
                String typeName = ASTUtils.getCppTypeName(((ICPPASTNewExpression)expression).getTypeId().getDeclSpecifier());
                ret = ReverseUtils.getUMLType(typeName, (ICElement)this.m_itu);
            } else if (!(expression instanceof ICPPASTSimpleTypeConstructorExpression)) {
                if (expression instanceof IASTCastExpression) {
                    String typeName_1 = ASTUtils.getCppTypeName(((IASTCastExpression)expression).getTypeId().getDeclSpecifier());
                    ret = ReverseUtils.getUMLType(typeName_1, (ICElement)this.m_itu);
                } else if (expression instanceof IASTExpressionList) {
                    Consumer<IASTExpression> _function_5 = it -> this.analyzeExpression((IASTExpression)it);
                    ((List)Conversions.doWrapArray((Object)((IASTExpressionList)expression).getExpressions())).forEach(_function_5);
                } else if (expression.getChildren() != null && ((List)Conversions.doWrapArray((Object)expression.getChildren())).size() > 0) {
                    Consumer<IASTNode> _function_6 = it -> {
                        if (it instanceof IASTExpression) {
                            this.analyzeExpression((IASTExpression)it);
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)expression.getChildren())).forEach(_function_6);
                }
            }
        }
        return ret;
    }

    private Type getArgumentType(IASTInitializerClause argument) {
        Type argType = null;
        if (argument instanceof IASTExpression) {
            argType = this.analyzeExpression((IASTExpression)argument);
        }
        return argType;
    }

    private void analyzeStatement(IASTForStatement statement) {
    }

    private void analyzeStatement(IASTReturnStatement statement) {
    }

    private void analyzeStatement(IASTSwitchStatement statement) {
        IASTStatement body = statement.getBody();
        this.analyzeStatement(body);
    }

    private void analyzeStatement(IASTWhileStatement statement) {
        this.analyzeStatement(statement.getBody());
    }

    private void analyzeStatement(IASTIfStatement statement) {
        IASTStatement _elseClause;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        this.analyzeExpression(statement.getConditionExpression());
        IASTStatement _thenClause = statement.getThenClause();
        boolean bl = _tripleNotEquals = _thenClause != null;
        if (_tripleNotEquals) {
            this.analyzeStatement(statement.getThenClause());
        }
        boolean bl2 = _tripleNotEquals_1 = (_elseClause = statement.getElseClause()) != null;
        if (_tripleNotEquals_1) {
            this.analyzeStatement(statement.getElseClause());
        }
    }
}

