/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;

public class AddProfileAndModelLibsHandler {
    static final String CPP_PROFILE_URI = "pathmap://CPP_PROFILES/C_Cpp.profile.uml";
    static final String ANSIC_LIBRARY_URI = "pathmap://CPP_LIBRARIES/Ansi_C.library.uml";

    public PackageImport getModelLibraryImportFromURI(URI uri, EditingDomain domain) {
        Element root = AddProfileAndModelLibsHandler.getContent(uri, domain);
        if (root instanceof Package) {
            Package libToImport = (Package)root;
            PackageImport modelLibImport = UMLFactory.eINSTANCE.createPackageImport();
            modelLibImport.setImportedPackage(libToImport);
            return modelLibImport;
        }
        return null;
    }

    public static Element getContent(URI uri, EditingDomain domain) {
        Resource resource = domain.getResourceSet().getResource(uri, true);
        return AddProfileAndModelLibsHandler.getContent(resource);
    }

    public static Element getContent(Resource resource) {
        EList contentObj = resource.getContents();
        if (contentObj.size() > 0 && contentObj.get(0) instanceof Element) {
            return (Element)contentObj.get(0);
        }
        return null;
    }

    boolean isAlreadyImported(Package selectedPkg, PackageImport pi) {
        for (PackageImport existingPI : selectedPkg.getPackageImports()) {
            if (existingPI.getImportedPackage() == null || pi.getImportedPackage() == null || existingPI.getImportedPackage().getName() == null || pi.getImportedPackage().getName() == null || !existingPI.getImportedPackage().getName().equals(pi.getImportedPackage().getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfileAndImport(final Package selectedPkg) throws ExecutionException {
        final TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)selectedPkg);
        CommandStack stack = domain.getCommandStack();
        stack.execute((Command)new RecordingCommand(domain, "Add C++ profile & ANSI-C library"){

            public void doExecute() {
                PackageImport pi = AddProfileAndModelLibsHandler.this.getModelLibraryImportFromURI(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"), (EditingDomain)domain);
                selectedPkg.getPackageImports().add((Object)pi);
                AddProfileAndModelLibsHandler.addCppProfile(selectedPkg, domain);
            }
        });
    }

    public static void addCppProfile(Package selectedPkg, TransactionalEditingDomain domain) {
        Profile profile;
        Profile cppProfile = (Profile)AddProfileAndModelLibsHandler.getContent(URI.createURI((String)CPP_PROFILE_URI), (EditingDomain)domain);
        if (cppProfile instanceof Profile && (profile = selectedPkg.getAppliedProfile(cppProfile.getQualifiedName())) == null && !cppProfile.getOwnedStereotypes().isEmpty()) {
            selectedPkg.applyProfile(cppProfile);
        }
    }
}

