/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.container;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.designer.components.FCM.Connector;
import org.eclipse.papyrus.designer.components.FCM.ContainerRule;
import org.eclipse.papyrus.designer.components.FCM.ContainerRuleKind;
import org.eclipse.papyrus.designer.components.FCM.InteractionComponent;
import org.eclipse.papyrus.designer.components.FCM.InterceptionKind;
import org.eclipse.papyrus.designer.components.FCM.InterceptionRule;
import org.eclipse.papyrus.designer.components.FCM.Singleton;
import org.eclipse.papyrus.designer.components.fcm.profile.utils.FCMUtil;
import org.eclipse.papyrus.designer.components.transformation.Messages;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.extensions.AbstractContainerTrafo;
import org.eclipse.papyrus.designer.components.transformation.templates.ComponentTemplateUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.MapUtil;
import org.eclipse.papyrus.designer.transformation.base.utils.PartsUtil;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.templates.PkgTemplateUtils;
import org.eclipse.papyrus.designer.transformation.core.templates.TemplateInstantiation;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.TemplateUtils;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ContainerTrafo
extends AbstractContainerTrafo {
    public static final String executorPartName = "_executor";
    public static final String interceptorName = "intercept ";
    public static final String containerPostfix = "_cc";
    public static final String hwContainerPostfix = "_hwcc";
    protected Property executorPart;
    protected InstanceSpecification executorIS;
    protected Class tmContainerImpl;
    protected int counter;
    protected Map<Property, Port> portInfo;
    public static InstanceSpecification instance;
    public static Port port;

    public ContainerTrafo(LazyCopier copier, Package tmCDP, InstanceSpecification executorIS) {
        this.copier = copier;
        this.tmCDP = tmCDP;
        this.executorIS = executorIS;
        this.portInfo = new HashMap<Property, Port>();
    }

    @Override
    public void createContainer(Class smComponent, Class tmComponent) throws TransformationException {
        Package tmPkgOwner = tmComponent.eResource() == this.tmCDP.eResource() ? tmComponent.getNearestPackage() : MapUtil.getAndCreate((Package)PackageUtil.getRootPackage((Package)this.tmCDP), (EList)tmComponent.allNamespaces(), (boolean)true);
        this.tmContainerImpl = tmPkgOwner.createOwnedClass(String.valueOf(tmComponent.getName()) + containerPostfix, false);
        boolean isSingleton = StereotypeUtil.isApplied((Element)smComponent, Singleton.class);
        if (isSingleton) {
            StereotypeUtil.apply((Element)this.tmContainerImpl, Singleton.class);
        }
        CopyUtils.copyID((EObject)tmComponent, (EObject)this.tmContainerImpl, (String)containerPostfix);
        this.executorPart = this.tmContainerImpl.createOwnedAttribute(executorPartName, (Type)tmComponent);
        CopyUtils.copyID((EObject)tmComponent, (EObject)this.executorPart, (String)"e");
        this.executorPart.setIsComposite(true);
        for (Port port : PortUtils.getAllPorts((EncapsulatedClassifier)tmComponent)) {
            if (port.getVisibility() != VisibilityKind.PUBLIC_LITERAL) continue;
            Port newPort = (Port)EcoreUtil.copy((EObject)port);
            this.tmContainerImpl.getOwnedAttributes().add((Object)newPort);
            StUtils.copyStereotypes((Element)port, (Element)newPort);
            org.eclipse.uml2.uml.Connector containerDelegation = this.tmContainerImpl.createOwnedConnector("delegation " + port.getName());
            CopyUtils.copyID((EObject)this.tmContainerImpl, (EObject)containerDelegation);
            ConnectorEnd end1 = containerDelegation.createEnd();
            end1.setRole((ConnectableElement)newPort);
            ConnectorEnd end2 = containerDelegation.createEnd();
            end2.setPartWithPort(this.executorPart);
            end2.setRole((ConnectableElement)port);
        }
        containers.put(tmComponent, this);
    }

    public void createHwContainer(Class tmComponent) throws TransformationException {
        Package tmPkgOwner = (Package)tmComponent.getOwner();
        this.tmContainerImpl = tmPkgOwner.createOwnedClass(String.valueOf(tmComponent.getName()) + hwContainerPostfix, false);
        CopyUtils.copyID((EObject)tmComponent, (EObject)this.tmContainerImpl, (String)hwContainerPostfix);
        containers.put(tmComponent, this);
    }

    @Override
    public InstanceSpecification createContainerInstance(Class tmComponent, InstanceSpecification tmIS) throws TransformationException {
        InstanceSpecification containerIS = (InstanceSpecification)this.tmCDP.createPackagedElement(tmIS.getName(), UMLPackage.eINSTANCE.getInstanceSpecification());
        tmIS.setName(String.valueOf(tmIS.getName()) + "." + executorPartName);
        containerIS.getClassifiers().add((Object)this.tmContainerImpl);
        DepCreation.createSlot((InstanceSpecification)containerIS, (InstanceSpecification)tmIS, (Property)this.executorPart);
        this.counter = 0;
        BasicEList connectorSlots = new BasicEList();
        this.executorIS = tmIS;
        for (Property extensionPart : this.tmContainerImpl.getAttributes()) {
            Type tmContainerExtImpl = extensionPart.getType();
            if (!(tmContainerExtImpl instanceof Class) || DepUtils.getSlot((InstanceSpecification)containerIS, (Property)extensionPart) != null) continue;
            InstanceSpecification containerExtIS = null;
            String isName = String.valueOf(containerIS.getName()) + "." + extensionPart.getName();
            if (containerExtIS == null) {
                containerExtIS = DepCreation.createDepPlan((Package)this.tmCDP, (Class)((Class)tmContainerExtImpl), (String)isName, (boolean)false);
            }
            Slot partSlot = DepCreation.createSlot((InstanceSpecification)containerIS, containerExtIS, (Property)extensionPart);
            if (!StereotypeUtil.isApplied((Element)tmContainerExtImpl, InteractionComponent.class)) continue;
            connectorSlots.add((Object)partSlot);
        }
        this.moveSlots(this.executorIS);
        return containerIS;
    }

    public InstanceSpecification createHwContainerInstance(Class tmComponent, InstanceSpecification tmNode) {
        InstanceSpecification containerIS = (InstanceSpecification)this.tmCDP.createPackagedElement(String.valueOf(tmNode.getName()) + hwContainerPostfix, UMLPackage.eINSTANCE.getInstanceSpecification());
        containerIS.getClassifiers().add((Object)this.tmContainerImpl);
        this.counter = 0;
        this.executorIS = tmNode;
        for (Slot slot : tmNode.getSlots()) {
            Slot slotCopy = containerIS.createSlot();
            slotCopy.setDefiningFeature(slot.getDefiningFeature());
            for (ValueSpecification value : slot.getValues()) {
                CopyUtils.copyValue((ValueSpecification)value, (Slot)slotCopy);
            }
        }
        return containerIS;
    }

    public Class getContainer() {
        return this.tmContainerImpl;
    }

    @Override
    public void applyRule(ContainerRule smContainerRule, Class smComponent, Class tmComponent) throws TransformationException {
        HashMap<Property, EList<Property>> interceptorPartsMap = new HashMap<Property, EList<Property>>();
        for (Property part : smContainerRule.getBase_Class().getAllAttributes()) {
            Type type = part.getType();
            if (type == null) {
                String ruleName = smContainerRule.getBase_Class() != null ? smContainerRule.getBase_Class().getName() : "undefined";
                throw new TransformationException(String.format(Messages.ContainerTrafo_CannotApplyRule, ruleName));
            }
            if (part instanceof Port) {
                Port newPort = this.tmContainerImpl.createOwnedPort(part.getName(), part.getType());
                StUtils.copyStereotypes((Element)part, (Element)newPort);
                continue;
            }
            if (!(type instanceof Class)) continue;
            Class extOrInterceptor = (Class)type;
            if (StereotypeUtil.isApplied((Element)part, InterceptionRule.class)) {
                if (StereotypeUtil.isApplied((Element)extOrInterceptor, InteractionComponent.class)) {
                    InterceptionRule interceptionRule = (InterceptionRule)UMLUtil.getStereotypeApplication((Element)part, InterceptionRule.class);
                    InterceptionKind interceptionKind = interceptionRule.getInterceptionKind();
                    EList interceptFeatures = interceptionRule.getInterceptionSet();
                    EList<Property> interceptorParts = this.expandInterceptorExtension(interceptionKind, (EList<Feature>)interceptFeatures, extOrInterceptor, tmComponent);
                    interceptorPartsMap.put(part, interceptorParts);
                    continue;
                }
                throw new TransformationException(String.format(Messages.ContainerTrafo_InterceptionRuleButNoInterceptor, part.getName(), smContainerRule.getBase_Class().getName()));
            }
            Property extensionPart = this.expandAggregationExtension(part, extOrInterceptor, tmComponent);
            this.copier.put((Object)smContainerRule.getBase_Class(), (Object)this.tmContainerImpl);
            this.copier.putPair((EObject)part, (EObject)extensionPart);
        }
        this.createConnectorForAssociations();
        for (org.eclipse.uml2.uml.Connector connector : smContainerRule.getBase_Class().getOwnedConnectors()) {
            Property ruleInterceptorPart = null;
            for (Property part : interceptorPartsMap.keySet()) {
                if (!ConnectorUtil.connectsPart((org.eclipse.uml2.uml.Connector)connector, (Property)part)) continue;
                ruleInterceptorPart = part;
                break;
            }
            if (ruleInterceptorPart != null) {
                for (Property interceptorPart : (EList)interceptorPartsMap.get(ruleInterceptorPart)) {
                    this.copier.putPair((EObject)ruleInterceptorPart, (EObject)interceptorPart);
                    this.copier.getCopy((Element)connector);
                }
                continue;
            }
            Connector fcmConn = (Connector)UMLUtil.getStereotypeApplication((Element)connector, Connector.class);
            if (fcmConn != null) continue;
            this.copier.remove((Object)connector);
            this.copier.getCopy((Element)connector);
        }
        ComponentTemplateUtils.retargetConnectors((StructuredClassifier)this.tmContainerImpl);
    }

    Property expandAggregationExtension(Property smExtensionPart, Class smContainerExtImpl, Class tmComponent) throws TransformationException {
        String name = smExtensionPart.getName();
        Class tmContainerExtImpl = null;
        TemplateSignature signature = TemplateUtils.getSignature((TemplateableElement)smContainerExtImpl);
        if (signature == null) {
            tmContainerExtImpl = (Class)this.copier.getCopy((Element)smContainerExtImpl);
        } else {
            Class actual = tmComponent;
            TemplateBinding binding = PkgTemplateUtils.fixedBinding((Package)this.copier.target, (TemplateableElement)smContainerExtImpl, (Classifier)actual);
            TemplateInstantiation ti = new TemplateInstantiation(binding);
            tmContainerExtImpl = (Class)ti.bindElement((Element)smContainerExtImpl);
        }
        EList rules = FCMUtil.getAllContainerRules((Element)smContainerExtImpl);
        AbstractContainerTrafo containerTrafo = AbstractContainerTrafo.get(tmContainerExtImpl);
        if (containerTrafo == null) {
            for (ContainerRule rule : rules) {
                if (containerTrafo == null) {
                    if (rule.getKind() == ContainerRuleKind.LIGHT_WEIGHT_OO_RULE) {
                        throw new TransformationException(Messages.ContainerTrafo_RecursiveLWnotSupported);
                    }
                    containerTrafo = new ContainerTrafo(this.copier, this.tmCDP, null);
                    containerTrafo.createContainer(smContainerExtImpl, tmContainerExtImpl);
                }
                containerTrafo.applyRule(rule, smContainerExtImpl, tmContainerExtImpl);
            }
            if (containerTrafo != null) {
                containerTrafo.finalize();
                tmContainerExtImpl = ((ContainerTrafo)containerTrafo).getContainer();
            }
        }
        Property extensionPart = this.tmContainerImpl.createOwnedAttribute(name, (Type)tmContainerExtImpl);
        extensionPart.setAggregation(smExtensionPart.getAggregation());
        CopyUtils.copyMultElemModifiers((MultiplicityElement)smExtensionPart, (MultiplicityElement)extensionPart);
        CopyUtils.copyFeatureModifiers((Feature)smExtensionPart, (Feature)extensionPart);
        return extensionPart;
    }

    EList<Property> expandInterceptorExtension(InterceptionKind extKind, EList<Feature> featureList, Class smContainerConnImpl, Class tmComponent) throws TransformationException {
        BasicEList connectorParts = new BasicEList();
        for (Port port : PortUtils.getAllPorts((EncapsulatedClassifier)tmComponent)) {
            boolean match = true;
            if (extKind == InterceptionKind.INTERCEPT_ALL_IN) {
                match = PortUtils.getProvided(port) != null;
            } else if (extKind == InterceptionKind.INTERCEPT_ALL_OUT) {
                match = PortUtils.getRequired(port) != null;
            } else if (extKind == InterceptionKind.INTERCEPT_SOME) {
                match = ElementUtils.getNamedElementFromList(featureList, (String)port.getName()) != null;
            } else if (extKind == InterceptionKind.INTERCEPT_MATCHING) {
                EList<Port> interceptorPorts = PortUtils.getAllPorts((EncapsulatedClassifier)smContainerConnImpl);
                match = false;
                for (Port interceptorPort : interceptorPorts) {
                    if (!(interceptorPort.getType().getOwner() instanceof TemplateParameter)) continue;
                    match = PortUtils.getKind(port) == PortUtils.getKind(interceptorPort);
                    break;
                }
            }
            if (!match) continue;
            String interceptionName = interceptorName + port.getName() + this.counter;
            org.eclipse.uml2.uml.Connector interceptionConnector = null;
            for (org.eclipse.uml2.uml.Connector connector : this.tmContainerImpl.getOwnedConnectors()) {
                if (!ConnectorUtil.connectsPort((org.eclipse.uml2.uml.Connector)connector, (Port)port)) continue;
                interceptionConnector = connector;
                break;
            }
            if (interceptionConnector == null) {
                throw new TransformationException(Messages.ContainerTrafo_CannotFindDelegationConn);
            }
            interceptionConnector.setName(interceptionName);
            Connector fcmConn = (Connector)StereotypeUtil.applyApp(interceptionConnector, Connector.class);
            InteractionComponent fcmConnType = (InteractionComponent)UMLUtil.getStereotypeApplication((Element)smContainerConnImpl, InteractionComponent.class);
            fcmConn.setIc(fcmConnType);
            instance = this.executorIS;
            ContainerTrafo.port = port;
            Object connectorPart = null;
            connectorParts.add(connectorPart);
            ContainerTrafo.port = null;
            this.portInfo.put((Property)connectorPart, port);
            interceptionConnector.destroy();
        }
        ++this.counter;
        return connectorParts;
    }

    public void moveSlots(InstanceSpecification containerIS) {
        Classifier mainCl = DepUtils.getClassifier((InstanceSpecification)this.executorIS);
        Iterator slotIt = this.executorIS.getSlots().iterator();
        block0: while (slotIt.hasNext()) {
            Slot slot = (Slot)slotIt.next();
            String featureName = slot.getDefiningFeature().getName();
            if (mainCl.getAllAttributes().contains((Object)slot.getDefiningFeature())) continue;
            for (InstanceSpecification is : DepUtils.getContainedInstances((InstanceSpecification)containerIS)) {
                Classifier containedCl = DepUtils.getClassifier((InstanceSpecification)is);
                if (ElementUtils.getNamedElementFromList((EList)containedCl.getAllAttributes(), (String)featureName) == null || this.executorIS == is) continue;
                slotIt.remove();
                is.getSlots().add((Object)slot);
                continue block0;
            }
        }
    }

    public void createConnectorForAssociations() {
        for (Property part : PartsUtil.getParts((Class)this.tmContainerImpl)) {
            if (part.getType() == null) continue;
            for (Association association : part.getType().getAssociations()) {
                for (Property end : association.getMemberEnds()) {
                    Type type = end.getType();
                    if (type == null || type == part.getType()) continue;
                    for (Property checkPart : PartsUtil.getParts((Class)this.tmContainerImpl)) {
                        if (type != checkPart.getType() || ConnectorUtil.existsConnector((Class)this.tmContainerImpl, (Property)part, (Property)checkPart)) continue;
                        org.eclipse.uml2.uml.Connector conn = this.tmContainerImpl.createOwnedConnector(String.valueOf(part.getName()) + "_" + checkPart.getName());
                        conn.setType(association);
                        conn.createEnd().setRole((ConnectableElement)part);
                        conn.createEnd().setRole((ConnectableElement)checkPart);
                    }
                }
            }
        }
    }

    @Override
    public void finalize() {
        this.discoverServices();
    }

    public void discoverServices() {
        Type executorType = this.executorPart.getType();
        if (!(executorType instanceof EncapsulatedClassifier)) {
            return;
        }
        EncapsulatedClassifier ec = (EncapsulatedClassifier)executorType;
        for (Port executorPort : ec.getOwnedPorts()) {
            for (Property svcPart : this.tmContainerImpl.getOwnedAttributes()) {
                Type containerSvcType;
                if (svcPart == this.executorPart || !((containerSvcType = svcPart.getType()) instanceof EncapsulatedClassifier)) continue;
                EncapsulatedClassifier containerSvc = (EncapsulatedClassifier)containerSvcType;
                for (Port svcPort : containerSvc.getOwnedPorts()) {
                    if (!PortUtils.matches(executorPort, svcPort, true)) continue;
                    org.eclipse.uml2.uml.Connector c = this.tmContainerImpl.createOwnedConnector(String.format("auto from %s to %s", this.executorPart.getName(), svcPart.getName()));
                    ConnectorEnd ce1 = c.createEnd();
                    ConnectorEnd ce2 = c.createEnd();
                    ce1.setPartWithPort(this.executorPart);
                    ce1.setRole((ConnectableElement)executorPort);
                    ce2.setPartWithPort(svcPart);
                    ce2.setRole((ConnectableElement)svcPort);
                }
            }
        }
    }

    public static ContainerTrafo getContainerTrafo(InstanceSpecification containerInstance) {
        AbstractContainerTrafo containerTrafo;
        Classifier containerCandidate = DepUtils.getClassifier((InstanceSpecification)containerInstance);
        Property executorPart = containerCandidate.getAttribute(executorPartName, null);
        if (executorPart != null && executorPart.getType() instanceof Class && (containerTrafo = AbstractContainerTrafo.get((Class)executorPart.getType())) instanceof ContainerTrafo) {
            return (ContainerTrafo)containerTrafo;
        }
        return null;
    }

    public static Slot getExecutorSlot(InstanceSpecification containerInstance) {
        for (Slot slot : containerInstance.getSlots()) {
            if (!slot.getDefiningFeature().getName().equals(executorPartName)) continue;
            return slot;
        }
        return null;
    }

    public Port getInterceptedPort(Property containerPart) {
        return this.portInfo.get(containerPart);
    }
}

