/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public final class TestCaseAppender
extends ConsoleAppender {
    private static Logger rootLogger = Logger.getRootLogger();
    public static TestCaseAppender INSTANCE = new TestCaseAppender();
    private boolean installed = false;

    private TestCaseAppender() {
        super((Layout)new SimpleLayout(), "System.out");
        this.setName("TestCaseAppender");
    }

    public void append(LoggingEvent event) {
        if (event.getLevel().isGreaterOrEqual((Priority)Level.INFO)) {
            String renderedMessage = event.getRenderedMessage();
            ThrowableInformation throwableInformation = event.getThrowableInformation();
            Throwable throwable = throwableInformation != null ? throwableInformation.getThrowable() : null;
            throw new Error(renderedMessage, throwable);
        }
    }

    public void install() {
        if (!this.installed) {
            rootLogger.addAppender((Appender)this);
            this.installed = true;
        }
    }

    public void uninstall() {
        rootLogger.removeAppender((Appender)this);
        this.installed = false;
    }
}

