/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.internal.xtend.util.ProfileCollector;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ExpressionFacade;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.Variable;

public class XtendComponent
extends AbstractExpressionsUsingWorkflowComponent {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    String extensionFile = null;
    private List<String> extensionAdvices = new ArrayList<String>();
    private String invokeExpression;
    private String expression = null;
    private String collectProfileSummary = null;
    private String verboseProfileFilename = null;
    private String outputSlot = "default";

    public void addExtensionAdvice(String extensionAdvices) {
        if (!this.extensionAdvices.contains(extensionAdvices)) {
            this.extensionAdvices.add(extensionAdvices);
        }
    }

    public void setCollectProfileSummary(String c) {
        this.collectProfileSummary = c;
    }

    public void setVerboseProfileFilename(String f) {
        this.verboseProfileFilename = f;
    }

    public String getLogMessage() {
        return "executing '" + this.extensionFile + "'";
    }

    public void setInvoke(String invoke) {
        this.invokeExpression = invoke;
        int i = invoke.lastIndexOf("::");
        if (i != -1) {
            this.extensionFile = invoke.substring(0, i);
            this.expression = invoke.substring(i + 2);
        } else {
            this.expression = invoke;
        }
    }

    public void setOutputSlot(String outputSlot) {
        this.outputSlot = outputSlot;
    }

    public void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        InputStream in = this.getExtFileIS();
        if (in == null) {
            issues.addError("Cannot find extension file: " + this.extensionFile);
            return;
        }
        BufferedOutputStream verboseProfileOutputStream = null;
        if (this.verboseProfileFilename != null) {
            try {
                verboseProfileOutputStream = new BufferedOutputStream(new FileOutputStream(this.verboseProfileFilename));
                ProfileCollector.getInstance().setDetailedLoggingWriter(verboseProfileOutputStream);
            }
            catch (IOException exc) {
                this.log.warn((Object)"could not open profiling log file", (Throwable)exc);
            }
        }
        ExecutionContextImpl ec = this.getExecutionContext(ctx);
        for (String advice : this.extensionAdvices) {
            String[] allAdvices = advice.split(",");
            int i = 0;
            while (i < allAdvices.length) {
                String string = allAdvices[i];
                ec.registerExtensionAdvices(string.trim());
                ++i;
            }
        }
        ec = (ExecutionContextImpl)ec.cloneWithResource(new Resource(){
            private String name = "noName";

            public String getFullyQualifiedName() {
                return this.name;
            }

            public void setFullyQualifiedName(String fqn) {
                this.name = fqn;
            }

            public String[] getImportedNamespaces() {
                return new String[0];
            }

            public String[] getImportedExtensions() {
                return new String[]{XtendComponent.this.extensionFile};
            }
        });
        String[] slots = ctx.getSlotNames();
        int i = 0;
        while (i < slots.length) {
            ec = (ExecutionContextImpl)ec.cloneWithVariable(new Variable(slots[i], ctx.get(slots[i])));
            ++i;
        }
        if (monitor != null) {
            ec.setMonitor(monitor);
        }
        Object result = new ExpressionFacade(ec).evaluate(this.expression);
        ctx.set(this.outputSlot, result);
        ProfileCollector.getInstance().finish();
        if ("true".equalsIgnoreCase(this.collectProfileSummary)) {
            this.log.info((Object)("profiling info: \n" + ProfileCollector.getInstance().toString()));
        }
        if (verboseProfileOutputStream != null) {
            try {
                ((OutputStream)verboseProfileOutputStream).close();
            }
            catch (IOException exc) {
                this.log.warn((Object)"problem closing profile log file", (Throwable)exc);
            }
        }
    }

    private InputStream getExtFileIS() {
        InputStream in = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(String.valueOf(this.extensionFile.replace("::", "/")) + ".ext");
        return in;
    }

    public void checkConfiguration(Issues issues) {
        String compPrefix;
        super.checkConfiguration(issues);
        String string = compPrefix = this.getId() != null ? String.valueOf(this.getId()) + ": " : "";
        if (this.invokeExpression == null || this.invokeExpression.trim().length() == 0) {
            issues.addError(String.valueOf(compPrefix) + "Property 'invoke' not specified.");
            return;
        }
        if (this.extensionFile == null) {
            issues.addError(String.valueOf(compPrefix) + "Error parsing property 'invoke': Could not extract name of the extension file.");
            return;
        }
        if (this.getExtFileIS() == null || this.expression == null) {
            issues.addError(String.valueOf(compPrefix) + "Property 'invoke' not specified properly. AbstractExtension file '" + this.extensionFile + "' not found.");
            return;
        }
        if (this.expression == null) {
            issues.addError(String.valueOf(compPrefix) + "Error parsing property 'invoke': Could not extract the expression to invoke in extension file '" + this.extensionFile + "'.");
            return;
        }
    }
}

