/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.ast.NodeSetExpr;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public class NodeSetCast
extends NodeSetExpr {
    private final ExprNode left;

    public NodeSetCast(ExprNode left) {
        this.left = left;
    }

    public NodeSet evalAsNodeSet(Context context) {
        NodeSet result;
        Object leftVal = this.left.evalAsObject(context);
        if (leftVal instanceof String || leftVal instanceof Boolean || leftVal instanceof Number) {
            result = NodeSetImpl.EMPTY_SET;
        } else {
            if (leftVal instanceof NodeSet) {
                return (NodeSet)leftVal;
            }
            INodeInspector inspector = InspectorManager.getInstance().getInspector(leftVal);
            if (inspector != null && inspector.getNodeKind(leftVal) != null) {
                NodeSetImpl nodeSet = new NodeSetImpl(1);
                nodeSet.add(leftVal);
                result = nodeSet;
            } else {
                result = new NodeSetImpl();
            }
        }
        return result;
    }

    public String toString() {
        return this.left.toString();
    }
}

