/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.java;

import java.util.ArrayList;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.java.JavaActionsUtil;
import org.eclipse.jface.text.Position;

public class ImportsLocationTag
extends AbstractEmptyTag {
    public static final String IMPORTS_POSITION_CATEGORY = "org.eclipse.jet.internal.taglib.java.imports";
    private static final String IMPORTS_LISTENER_CATEGORY = "org.eclipse.jet.internal.taglib.java.imports";

    public void doAction(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        this.ensureNoEarlierImportsLocation(out);
        String compilationUnitPackage = this.getAttribute("package");
        int importsOffset = out.getLength();
        out.write(" ");
        ImportsPosition importsPosition = new ImportsPosition(importsOffset, compilationUnitPackage, out.getDocument().get());
        out.addPositionCategory("org.eclipse.jet.internal.taglib.java.imports");
        out.addPosition("org.eclipse.jet.internal.taglib.java.imports", importsPosition);
        out.addEventListener("org.eclipse.jet.internal.taglib.java.imports", new WriterEventListener());
    }

    private void ensureNoEarlierImportsLocation(JET2Writer writer) throws JET2TagException {
        writer.addPositionCategory("org.eclipse.jet.internal.taglib.java.imports");
        Position[] positions = writer.getPositions("org.eclipse.jet.internal.taglib.java.imports");
        if (positions.length > 0) {
            throw new JET2TagException(JET2Messages.ImportsLocationTag_AllowedOnlyOnce);
        }
        if (writer.getParentWriter() != null) {
            this.ensureNoEarlierImportsLocation(writer.getParentWriter());
        }
    }

    public static ImportManager getImportManager(JET2Writer writer) throws JET2TagException {
        return JavaActionsUtil.getImportManager(writer);
    }

    private static final class WriterEventListener
    implements IWriterListener {
        private WriterEventListener() {
        }

        public void finalizeContent(JET2Writer writer, Object file) {
            Position[] importLocations = writer.getPositions("org.eclipse.jet.internal.taglib.java.imports");
            if (importLocations.length > 0) {
                ImportsPosition position = (ImportsPosition)importLocations[0];
                writer.replace(position.offset, position.length, position.getImportManager().computeSortedImports());
            }
        }

        public void postCommitContent(JET2Writer writer, Object file) {
        }
    }

    public static final class ImportsPosition
    extends Position {
        private final ImportManager importManager;

        public ImportsPosition(int start, String compilationUnitPackage, String preceedingContents) {
            super(start);
            this.importManager = new ImportManager(compilationUnitPackage);
            this.importManager.addJavaLangImports(new ArrayList(CodeGenUtil.getJavaDefaultTypes()));
            this.importManager.addCompilationUnitImports(preceedingContents);
        }

        public final ImportManager getImportManager() {
            return this.importManager;
        }
    }
}

