/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.inspectors.jdt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jet.internal.xpath.inspectors.jdt.ASTNodeDocumentRoot;
import org.eclipse.jet.internal.xpath.inspectors.jdt.NonDescriptorAttribute;
import org.eclipse.jet.internal.xpath.inspectors.jdt.SimplePropertyDescriptorAttribute;
import org.eclipse.jet.xpath.inspector.AddElementException;
import org.eclipse.jet.xpath.inspector.CopyElementException;
import org.eclipse.jet.xpath.inspector.ExpandedName;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.INodeInspectorExtension1;
import org.eclipse.jet.xpath.inspector.InvalidChildException;
import org.eclipse.jet.xpath.inspector.SimpleElementRequiresValueException;

public class InspectASTNode
implements INodeInspector,
IElementInspector,
INodeInspectorExtension1 {
    private static final Map propertyDescriptorByType = new HashMap(50);
    private static final Map attributePropertyDescriptorByType = new HashMap(50);
    private static final Map childPropertyDescriptorByType = new HashMap(50);

    private StructuralPropertyDescriptor getPropertyDescriptor(ASTNode node, String id) {
        List propsList = this.getPropertyDescriptors(node);
        Iterator i = propsList.iterator();
        while (i.hasNext()) {
            StructuralPropertyDescriptor spd = (StructuralPropertyDescriptor)i.next();
            if (!spd.getId().equals(id)) continue;
            return spd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getPropertyDescriptors(ASTNode node) {
        Integer nodeType = new Integer(node.getNodeType());
        List propsList = (List)propertyDescriptorByType.get(nodeType);
        if (propsList == null) {
            Map map = propertyDescriptorByType;
            synchronized (map) {
                propsList = (List)propertyDescriptorByType.get(nodeType);
                if (propsList == null) {
                    propsList = node.structuralPropertiesForType();
                    propertyDescriptorByType.put(nodeType, propsList);
                }
            }
        }
        return propsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getAttributePropertyDescriptors(ASTNode node) {
        Integer nodeType = new Integer(node.getNodeType());
        ArrayList<StructuralPropertyDescriptor> propsList = (ArrayList<StructuralPropertyDescriptor>)attributePropertyDescriptorByType.get(nodeType);
        if (propsList == null) {
            Map map = attributePropertyDescriptorByType;
            synchronized (map) {
                propsList = (List)attributePropertyDescriptorByType.get(nodeType);
                if (propsList == null) {
                    List allPropsList = node.structuralPropertiesForType();
                    propsList = new ArrayList<StructuralPropertyDescriptor>(allPropsList.size());
                    Iterator i = allPropsList.iterator();
                    while (i.hasNext()) {
                        StructuralPropertyDescriptor spd = (StructuralPropertyDescriptor)i.next();
                        if (!spd.isSimpleProperty()) continue;
                        propsList.add(spd);
                    }
                    attributePropertyDescriptorByType.put(nodeType, propsList);
                }
            }
        }
        return propsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getElementPropertyDescriptors(ASTNode node) {
        Integer nodeType = new Integer(node.getNodeType());
        ArrayList<StructuralPropertyDescriptor> propsList = (ArrayList<StructuralPropertyDescriptor>)childPropertyDescriptorByType.get(nodeType);
        if (propsList == null) {
            Map map = childPropertyDescriptorByType;
            synchronized (map) {
                propsList = (List)childPropertyDescriptorByType.get(nodeType);
                if (propsList == null) {
                    List allPropsList = node.structuralPropertiesForType();
                    propsList = new ArrayList<StructuralPropertyDescriptor>(allPropsList.size());
                    Iterator i = allPropsList.iterator();
                    while (i.hasNext()) {
                        StructuralPropertyDescriptor spd = (StructuralPropertyDescriptor)i.next();
                        if (spd.isSimpleProperty()) continue;
                        propsList.add(spd);
                    }
                    childPropertyDescriptorByType.put(nodeType, propsList);
                }
            }
        }
        return propsList;
    }

    public ExpandedName expandedNameOf(Object node) {
        return new ExpandedName(this.nameOf(node));
    }

    public Object[] getChildren(Object node) {
        ASTNode astNode = (ASTNode)node;
        List spds = this.getElementPropertyDescriptors(astNode);
        ArrayList<Object> children = new ArrayList<Object>(spds.size());
        Iterator i = spds.iterator();
        while (i.hasNext()) {
            StructuralPropertyDescriptor spd = (StructuralPropertyDescriptor)i.next();
            Object structuralProperty = astNode.getStructuralProperty(spd);
            if (spd.isChildProperty() && structuralProperty != null) {
                children.add(structuralProperty);
                continue;
            }
            if (!spd.isChildListProperty() || structuralProperty == null) continue;
            List spList = (List)structuralProperty;
            children.addAll(spList);
        }
        return children.toArray();
    }

    public Object getDocumentRoot(Object node) {
        ASTNode astNode = (ASTNode)node;
        return ASTNodeDocumentRoot.documentRootFor(astNode);
    }

    public INodeInspector.NodeKind getNodeKind(Object node) {
        return INodeInspector.NodeKind.ELEMENT;
    }

    public Object getParent(Object node) {
        ASTNode astNode = (ASTNode)node;
        ASTNode parent = astNode.getParent();
        return parent == null ? ASTNodeDocumentRoot.documentRootFor(astNode) : parent;
    }

    public String nameOf(Object node) {
        ASTNode astNode = (ASTNode)node;
        StructuralPropertyDescriptor locationInParent = astNode.getLocationInParent();
        if (locationInParent != null) {
            return locationInParent.getId();
        }
        String fullyQualifiedName = ASTNode.nodeClassForType((int)astNode.getNodeType()).getName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        StringBuffer simpleName = new StringBuffer(lastDot >= 0 ? fullyQualifiedName.substring(lastDot + 1) : fullyQualifiedName);
        simpleName.setCharAt(0, Character.toLowerCase(simpleName.charAt(0)));
        return simpleName.toString();
    }

    public String stringValueOf(Object node) {
        ASTNode astNode = (ASTNode)node;
        return this.getSource(astNode);
    }

    private String getSource(ASTNode astNode) {
        ASTNodeDocumentRoot documentRoot = ASTNodeDocumentRoot.documentRootFor(astNode);
        int start = astNode.getStartPosition();
        int end = start + astNode.getLength();
        return documentRoot.stringValue().substring(start, end);
    }

    public boolean testExpandedName(Object node, ExpandedName testName) {
        return testName.equals(this.expandedNameOf(node));
    }

    public Object addElement(Object node, ExpandedName elementName, Object addBeforeThisSibling) throws SimpleElementRequiresValueException, InvalidChildException {
        throw new UnsupportedOperationException();
    }

    public Object addTextElement(Object parentElement, String name, String bodyContent, boolean asCData) throws AddElementException {
        throw new UnsupportedOperationException();
    }

    public Object copyElement(Object tgtParent, Object srcElement, String name, boolean recursive) throws CopyElementException {
        throw new UnsupportedOperationException();
    }

    public boolean createAttribute(Object node, String attributeName, String value) {
        return false;
    }

    public Object[] getAttributes(Object node) {
        ASTNode astNode = (ASTNode)node;
        List spds = this.getAttributePropertyDescriptors(astNode);
        List nonspds = NonDescriptorAttribute.getAttributes(astNode);
        ArrayList<SimplePropertyDescriptorAttribute> result = new ArrayList<SimplePropertyDescriptorAttribute>(spds.size() + nonspds.size());
        result.addAll(nonspds);
        Iterator i = spds.iterator();
        while (i.hasNext()) {
            SimplePropertyDescriptor spd = (SimplePropertyDescriptor)i.next();
            if (astNode.getStructuralProperty((StructuralPropertyDescriptor)spd) == null) continue;
            result.add(new SimplePropertyDescriptorAttribute(astNode, spd));
        }
        return result.toArray();
    }

    public Object getNamedAttribute(Object node, ExpandedName nameTestExpandedName) {
        ASTNode astNode = (ASTNode)node;
        String propertyName = nameTestExpandedName.getLocalPart();
        NonDescriptorAttribute attribute = NonDescriptorAttribute.getAttribute(astNode, propertyName);
        if (attribute != null) {
            return attribute;
        }
        StructuralPropertyDescriptor spd = this.getPropertyDescriptor(astNode, propertyName);
        if (spd != null && spd.isSimpleProperty() && astNode.getStructuralProperty(spd) != null) {
            return new SimplePropertyDescriptorAttribute(astNode, (SimplePropertyDescriptor)spd);
        }
        return null;
    }

    public void removeAttribute(Object node, String name) {
        throw new UnsupportedOperationException();
    }

    public void removeElement(Object node) {
        throw new UnsupportedOperationException();
    }

    public Object[] getNamedChildren(Object node, ExpandedName nameTestExpandedName) {
        ASTNode astNode = (ASTNode)node;
        String propertyName = nameTestExpandedName.getLocalPart();
        StructuralPropertyDescriptor spd = this.getPropertyDescriptor(astNode, propertyName);
        if (spd == null) {
            return new Object[0];
        }
        Object structuralProperty = astNode.getStructuralProperty(spd);
        if (spd.isChildProperty()) {
            Object[] objectArray;
            if (structuralProperty != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = structuralProperty;
            } else {
                objectArray = null;
            }
            return objectArray;
        }
        if (spd.isChildListProperty()) {
            return structuralProperty != null ? ((List)structuralProperty).toArray() : null;
        }
        return new Object[0];
    }
}

