/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.ecore.edit.parts.EPackageEditPart;
import org.eclipse.gmf.ecore.expressions.EcoreAbstractExpression;
import org.eclipse.gmf.ecore.expressions.EcoreOCLFactory;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class EcoreVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(EcoreDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";
    private static final Matcher EDataType_3006 = new Matcher(EcoreOCLFactory.getExpression("not oclIsKindOf(ecore::EEnum)", (EClassifier)EcorePackage.eINSTANCE.getEDataType()));
    private static final Matcher EDataType_2004 = new Matcher(EcoreOCLFactory.getExpression("not oclIsKindOf(ecore::EEnum)", (EClassifier)EcorePackage.eINSTANCE.getEDataType()));
    private static final Matcher EReference_4002 = new Matcher(EcoreOCLFactory.getExpression("not containment and not container", (EClassifier)EcorePackage.eINSTANCE.getEReference()));
    private static final Matcher EReference_4003 = new Matcher(EcoreOCLFactory.getExpression("containment", (EClassifier)EcorePackage.eINSTANCE.getEReference()));

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if (EPackageEditPart.MODEL_ID.equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return EcoreVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                EcoreDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return EcoreVisualIDRegistry.getDiagramVisualID(domainElement, domainElementMetaclass);
    }

    private static int getDiagramVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElementMetaclass) && EcoreVisualIDRegistry.isDiagramEPackage_1000((EPackage)domainElement)) {
            return 1000;
        }
        return EcoreVisualIDRegistry.getUnrecognizedDiagramID(domainElement);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return EcoreVisualIDRegistry.getNodeVisualID(containerView, domainElement, domainElementMetaclass, null);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement, EClass domainElementMetaclass, String semanticHint) {
        int containerVisualID;
        String containerModelID = EcoreVisualIDRegistry.getModelID(containerView);
        if (!EPackageEditPart.MODEL_ID.equals(containerModelID) && !"ecore".equals(containerModelID)) {
            return -1;
        }
        if (EPackageEditPart.MODEL_ID.equals(containerModelID)) {
            containerVisualID = EcoreVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        int nodeVisualID = semanticHint != null ? EcoreVisualIDRegistry.getVisualID(semanticHint) : -1;
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return 5001;
                }
                if (7001 == nodeVisualID) {
                    return 7001;
                }
                if (7002 == nodeVisualID) {
                    return 7002;
                }
                if (7003 == nodeVisualID) {
                    return 7003;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEClass_2001ChildNodeID(domainElement, semanticHint);
            }
            case 2002: {
                if (5002 == nodeVisualID) {
                    return 5002;
                }
                if (7004 == nodeVisualID) {
                    return 7004;
                }
                if (7005 == nodeVisualID) {
                    return 7005;
                }
                if (7006 == nodeVisualID) {
                    return 7006;
                }
                if (7007 == nodeVisualID) {
                    return 7007;
                }
                if (7008 == nodeVisualID) {
                    return 7008;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEPackage_2002ChildNodeID(domainElement, semanticHint);
            }
            case 2003: {
                if (5003 == nodeVisualID) {
                    return 5003;
                }
                if (7009 == nodeVisualID) {
                    return 7009;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEAnnotation_2003ChildNodeID(domainElement, semanticHint);
            }
            case 2004: {
                if (5004 == nodeVisualID) {
                    return 5004;
                }
                if (7010 == nodeVisualID) {
                    return 7010;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEDataType_2004ChildNodeID(domainElement, semanticHint);
            }
            case 2005: {
                if (5005 == nodeVisualID) {
                    return 5005;
                }
                if (7011 == nodeVisualID) {
                    return 7011;
                }
                if (7012 == nodeVisualID) {
                    return 7012;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEEnum_2005ChildNodeID(domainElement, semanticHint);
            }
            case 3001: {
                return EcoreVisualIDRegistry.getUnrecognizedEAttribute_3001ChildNodeID(domainElement, semanticHint);
            }
            case 3002: {
                return EcoreVisualIDRegistry.getUnrecognizedEOperation_3002ChildNodeID(domainElement, semanticHint);
            }
            case 3003: {
                return EcoreVisualIDRegistry.getUnrecognizedEAnnotation_3003ChildNodeID(domainElement, semanticHint);
            }
            case 3004: {
                return EcoreVisualIDRegistry.getUnrecognizedEClass_3004ChildNodeID(domainElement, semanticHint);
            }
            case 3005: {
                return EcoreVisualIDRegistry.getUnrecognizedEPackage_3005ChildNodeID(domainElement, semanticHint);
            }
            case 3006: {
                return EcoreVisualIDRegistry.getUnrecognizedEDataType_3006ChildNodeID(domainElement, semanticHint);
            }
            case 3007: {
                return EcoreVisualIDRegistry.getUnrecognizedEEnum_3007ChildNodeID(domainElement, semanticHint);
            }
            case 3008: {
                return EcoreVisualIDRegistry.getUnrecognizedEStringToStringMapEntry_3008ChildNodeID(domainElement, semanticHint);
            }
            case 3009: {
                return EcoreVisualIDRegistry.getUnrecognizedEEnumLiteral_3009ChildNodeID(domainElement, semanticHint);
            }
            case 7001: {
                if ((semanticHint == null || 3001 == nodeVisualID) && EcorePackage.eINSTANCE.getEAttribute().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEAttribute_3001((EAttribute)domainElement))) {
                    return 3001;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEClassAttributes_7001ChildNodeID(domainElement, semanticHint);
            }
            case 7002: {
                if ((semanticHint == null || 3002 == nodeVisualID) && EcorePackage.eINSTANCE.getEOperation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEOperation_3002((EOperation)domainElement))) {
                    return 3002;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEClassOperations_7002ChildNodeID(domainElement, semanticHint);
            }
            case 7003: {
                if ((semanticHint == null || 3003 == nodeVisualID) && EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEAnnotation_3003((EAnnotation)domainElement))) {
                    return 3003;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEClassClassAnnotations_7003ChildNodeID(domainElement, semanticHint);
            }
            case 7004: {
                if ((semanticHint == null || 3004 == nodeVisualID) && EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEClass_3004((EClass)domainElement))) {
                    return 3004;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEPackageClasses_7004ChildNodeID(domainElement, semanticHint);
            }
            case 7005: {
                if ((semanticHint == null || 3005 == nodeVisualID) && EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEPackage_3005((EPackage)domainElement))) {
                    return 3005;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEPackagePackages_7005ChildNodeID(domainElement, semanticHint);
            }
            case 7006: {
                if ((semanticHint == null || 3006 == nodeVisualID) && EcorePackage.eINSTANCE.getEDataType().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEDataType_3006((EDataType)domainElement))) {
                    return 3006;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEPackageDataTypes_7006ChildNodeID(domainElement, semanticHint);
            }
            case 7007: {
                if ((semanticHint == null || 3007 == nodeVisualID) && EcorePackage.eINSTANCE.getEEnum().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEEnum_3007((EEnum)domainElement))) {
                    return 3007;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEPackageEnums_7007ChildNodeID(domainElement, semanticHint);
            }
            case 7008: {
                if ((semanticHint == null || 3003 == nodeVisualID) && EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEAnnotation_3003((EAnnotation)domainElement))) {
                    return 3003;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEPackagePackageAnnotations_7008ChildNodeID(domainElement, semanticHint);
            }
            case 7009: {
                if ((semanticHint == null || 3008 == nodeVisualID) && EcorePackage.eINSTANCE.getEStringToStringMapEntry().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEStringToStringMapEntry_3008((Map.Entry)domainElement))) {
                    return 3008;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEAnnotationDetails_7009ChildNodeID(domainElement, semanticHint);
            }
            case 7010: {
                if ((semanticHint == null || 3003 == nodeVisualID) && EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEAnnotation_3003((EAnnotation)domainElement))) {
                    return 3003;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEDataTypeDataTypeAnnotations_7010ChildNodeID(domainElement, semanticHint);
            }
            case 7011: {
                if ((semanticHint == null || 3009 == nodeVisualID) && EcorePackage.eINSTANCE.getEEnumLiteral().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEEnumLiteral_3009((EEnumLiteral)domainElement))) {
                    return 3009;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEEnumLiterals_7011ChildNodeID(domainElement, semanticHint);
            }
            case 7012: {
                if ((semanticHint == null || 3003 == nodeVisualID) && EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEAnnotation_3003((EAnnotation)domainElement))) {
                    return 3003;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEEnumEnumAnnotations_7012ChildNodeID(domainElement, semanticHint);
            }
            case 1000: {
                if ((semanticHint == null || 2001 == nodeVisualID) && EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEClass_2001((EClass)domainElement))) {
                    return 2001;
                }
                if ((semanticHint == null || 2002 == nodeVisualID) && EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEPackage_2002((EPackage)domainElement))) {
                    return 2002;
                }
                if ((semanticHint == null || 2003 == nodeVisualID) && EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEAnnotation_2003((EAnnotation)domainElement))) {
                    return 2003;
                }
                if ((semanticHint == null || 2004 == nodeVisualID) && EcorePackage.eINSTANCE.getEDataType().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEDataType_2004((EDataType)domainElement))) {
                    return 2004;
                }
                if ((semanticHint == null || 2005 == nodeVisualID) && EcorePackage.eINSTANCE.getEEnum().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isNodeEEnum_2005((EEnum)domainElement))) {
                    return 2005;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEPackage_1000ChildNodeID(domainElement, semanticHint);
            }
            case 4002: {
                if (6001 == nodeVisualID) {
                    return 6001;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEReference_4002LinkLabelID(semanticHint);
            }
            case 4003: {
                if (6002 == nodeVisualID) {
                    return 6002;
                }
                return EcoreVisualIDRegistry.getUnrecognizedEReference_4003LinkLabelID(semanticHint);
            }
        }
        return -1;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return EcoreVisualIDRegistry.getLinkWithClassVisualID(domainElement, domainElementMetaclass);
    }

    public static int getLinkWithClassVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (EcorePackage.eINSTANCE.getEReference().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isLinkWithClassEReference_4002((EReference)domainElement))) {
            return 4002;
        }
        if (EcorePackage.eINSTANCE.getEReference().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || EcoreVisualIDRegistry.isLinkWithClassEReference_4003((EReference)domainElement))) {
            return 4003;
        }
        return EcoreVisualIDRegistry.getUnrecognizedLinkWithClassID(domainElement);
    }

    private static boolean isDiagramEPackage_1000(EPackage element) {
        return true;
    }

    private static int getUnrecognizedDiagramID(EObject domainElement) {
        return -1;
    }

    private static boolean isNodeEClass_2001(EClass element) {
        return true;
    }

    private static boolean isNodeEPackage_2002(EPackage element) {
        return true;
    }

    private static boolean isNodeEAnnotation_2003(EAnnotation element) {
        return true;
    }

    private static boolean isNodeEDataType_2004(EDataType element) {
        return EDataType_2004.matches((EObject)element);
    }

    private static boolean isNodeEEnum_2005(EEnum element) {
        return true;
    }

    private static boolean isNodeEAttribute_3001(EAttribute element) {
        return true;
    }

    private static boolean isNodeEOperation_3002(EOperation element) {
        return true;
    }

    private static boolean isNodeEAnnotation_3003(EAnnotation element) {
        return true;
    }

    private static boolean isNodeEClass_3004(EClass element) {
        return true;
    }

    private static boolean isNodeEPackage_3005(EPackage element) {
        return true;
    }

    private static boolean isNodeEDataType_3006(EDataType element) {
        return EDataType_3006.matches((EObject)element);
    }

    private static boolean isNodeEEnum_3007(EEnum element) {
        return true;
    }

    private static boolean isNodeEStringToStringMapEntry_3008(Map.Entry element) {
        return true;
    }

    private static boolean isNodeEEnumLiteral_3009(EEnumLiteral element) {
        return true;
    }

    private static int getUnrecognizedEClass_2001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEPackage_2002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEAnnotation_2003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEDataType_2004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEEnum_2005ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEAttribute_3001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEOperation_3002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEAnnotation_3003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEClass_3004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEPackage_3005ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEDataType_3006ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEEnum_3007ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEStringToStringMapEntry_3008ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEEnumLiteral_3009ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEClassAttributes_7001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEClassOperations_7002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEClassClassAnnotations_7003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEPackageClasses_7004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEPackagePackages_7005ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEPackageDataTypes_7006ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEPackageEnums_7007ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEPackagePackageAnnotations_7008ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEAnnotationDetails_7009ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEDataTypeDataTypeAnnotations_7010ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEEnumLiterals_7011ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEEnumEnumAnnotations_7012ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEPackage_1000ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEReference_4002LinkLabelID(String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEReference_4003LinkLabelID(String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLinkWithClassID(EObject domainElement) {
        return -1;
    }

    private static boolean isLinkWithClassEReference_4002(EReference element) {
        return EReference_4002.matches((EObject)element);
    }

    private static boolean isLinkWithClassEReference_4003(EReference element) {
        return EReference_4003.matches((EObject)element);
    }

    static class Matcher {
        private EcoreAbstractExpression condition;

        Matcher(EcoreAbstractExpression conditionExpression) {
            this.condition = conditionExpression;
        }

        boolean matches(EObject object) {
            Object result = this.condition.evaluate(object);
            return result instanceof Boolean && (Boolean)result != false;
        }
    }
}

