/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.notation;

import java.io.IOException;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class NotationTest
extends TestCase {
    private static final String PROJECT_NAME = "tests";
    private static final String NOTATION_RESOURCE_NAME = "/tests/tests.notation";
    private static final String WELCOME = "org.eclipse.ui.internal.introview";
    private static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";

    public static void main(String[] args) {
        TestRunner.run((Test)NotationTest.suite());
    }

    public static Test suite() {
        return new TestSuite(NotationTest.class);
    }

    public NotationTest(String name) {
        super(name);
    }

    public void test_notation() throws Exception {
        IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int i = 0;
        while (i < pages.length) {
            IViewReference[] viewRefs = pages[i].getViewReferences();
            int j = 0;
            while (j < viewRefs.length) {
                if (WELCOME.equals(viewRefs[j].getId())) {
                    pages[i].hideView(viewRefs[j]);
                }
                ++j;
            }
            ++i;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!project.exists()) {
            project.create(null);
        }
        project.open(null);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)new Path(NOTATION_RESOURCE_NAME));
        String fullPath = file.getFullPath().toOSString();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)fullPath, (boolean)true));
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.setName(this.getName());
        resource.getContents().add((Object)diagram);
        ShapeStyle style = NotationFactory.eINSTANCE.createShapeStyle();
        EList styles = diagram.getStyles();
        styles.add((Object)style);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor defaultEditor = PlatformUI.getWorkbench().getEditorRegistry().findEditor(DEFAULT_TEXT_EDITOR_ID);
        page.openEditor((IEditorInput)new FileEditorInput(file), defaultEditor.getId());
    }
}

