/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.util.ArrayList;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelIdentifier {
    private static final String DEFAULT_EXTENSION = "ecore";
    private final String namespace;
    private final String contentType;
    private final String extension;

    public ModelIdentifier(Resource ... resources) {
        ArrayList<URI> uris = new ArrayList<URI>();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null) {
                uris.add(resources[i].getURI());
            }
            ++i;
        }
        URI[] uriArray = uris.toArray(new URI[uris.size()]);
        this.namespace = ModelUtils.getCommonNamespace(resources);
        this.contentType = EMFPlugin.IS_ECLIPSE_RUNNING ? EclipseModelUtils.getCommonContentType(uriArray) : null;
        String ext = ModelUtils.getCommonExtension(uriArray);
        this.extension = ext != null ? ext : (this.contentType == null && this.namespace == null ? DEFAULT_EXTENSION : null);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getExtension() {
        return this.extension;
    }
}

