/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.eclipse.emf.cdo.CDOLock;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.DelegatingFeatureMap;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOStore;
import org.eclipse.emf.internal.cdo.NOOPLockImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOLoadable;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOObjectImpl
extends EStoreEObjectImpl
implements InternalCDOObject {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOObjectImpl.class);
    private CDOID id;
    private CDOState state = CDOState.TRANSIENT;
    private InternalCDOView view;
    private InternalCDORevision revision;
    private transient Object[] cdoSettings;

    public CDOObjectImpl() {
        this.eContainer = null;
        this.cdoSettings = null;
    }

    @Override
    public CDOID cdoID() {
        return this.id;
    }

    @Override
    public CDOState cdoState() {
        return this.state;
    }

    @Override
    public InternalCDORevision cdoRevision() {
        return this.revision;
    }

    @Override
    public InternalCDOView cdoView() {
        return this.view;
    }

    @Override
    public CDOResourceImpl cdoResource() {
        Resource resource = this.eResource();
        if (resource instanceof CDOResourceImpl) {
            return (CDOResourceImpl)resource;
        }
        return null;
    }

    @Override
    public CDOResourceImpl cdoDirectResource() {
        Resource.Internal resource = this.eDirectResource();
        if (resource instanceof CDOResourceImpl) {
            return (CDOResourceImpl)resource;
        }
        return null;
    }

    @Override
    public void cdoReload() {
        CDOStateMachine.INSTANCE.reload(this);
    }

    @Override
    public boolean cdoConflict() {
        return FSMUtil.isConflict(this);
    }

    @Override
    public boolean cdoInvalid() {
        return FSMUtil.isInvalid(this);
    }

    @Override
    public CDOLock cdoReadLock() {
        if (FSMUtil.isTransient(this) || FSMUtil.isNew(this)) {
            return NOOPLockImpl.INSTANCE;
        }
        return new CDOLockImpl(RWLockManager.LockType.READ);
    }

    @Override
    public CDOLock cdoWriteLock() {
        if (FSMUtil.isTransient(this) || FSMUtil.isNew(this)) {
            return NOOPLockImpl.INSTANCE;
        }
        return new CDOLockImpl(RWLockManager.LockType.WRITE);
    }

    @Override
    public void cdoInternalSetID(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0}", new Object[]{id});
        }
        this.id = id;
    }

    @Override
    public CDOState cdoInternalSetState(CDOState state) {
        if (this.state != state) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} for {1}", new Object[]{state, this});
            }
            try {
                CDOState cDOState = this.state;
                return cDOState;
            }
            finally {
                this.state = state;
            }
        }
        return null;
    }

    @Override
    public void cdoInternalSetRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revision: {0}", new Object[]{revision});
        }
        this.revision = (InternalCDORevision)revision;
    }

    @Override
    public void cdoInternalSetView(CDOView view) {
        this.view = (InternalCDOView)view;
        if (this.view != null) {
            this.eSetStore(this.view.getStore());
        } else {
            this.eSetStore(null);
        }
    }

    public void cdoInternalSetResource(CDOResource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cdoInternalPreLoad() {
    }

    @Override
    public void cdoInternalPostLoad() {
        if (this.eSettings != null) {
            EClass eClass = this.eClass();
            int i = 0;
            while (i < eClass.getFeatureCount()) {
                EStructuralFeature eFeature = this.cdoInternalDynamicFeature(i);
                if (!eFeature.isTransient() && this.eSettings[i] instanceof InternalCDOLoadable) {
                    ((InternalCDOLoadable)this.eSettings[i]).cdoInternalPostLoad();
                }
                ++i;
            }
        }
    }

    @Override
    public void cdoInternalPostInvalidate() {
    }

    @Override
    public void cdoInternalPostAttach() {
        if (TRACER.isEnabled()) {
            TRACER.format("Populating revision for {0}", new Object[]{this});
        }
        InternalCDOView view = this.cdoView();
        this.revision.setContainerID(this.eContainer == null ? CDOID.NULL : this.cdoView().convertObjectToID(this.eContainer, true));
        this.revision.setContainingFeatureID(this.eContainerFeatureID);
        Resource.Internal directResource = this.eDirectResource();
        if (directResource instanceof CDOResource) {
            CDOResource cdoResource = (CDOResource)directResource;
            this.revision.setResourceID(cdoResource.cdoID());
        }
        EClass eClass = this.eClass();
        int i = 0;
        while (i < eClass.getFeatureCount()) {
            EStructuralFeature eFeature = this.cdoInternalDynamicFeature(i);
            if (!eFeature.isTransient()) {
                Object setting = this.cdoBasicSettings() != null ? this.cdoSettings()[i] : null;
                CDOObjectImpl.instanceToRevisionFeature(view, this.revision, eFeature, setting);
            }
            ++i;
        }
        this.cdoSettings = null;
    }

    @Override
    public void cdoInternalPostDetach(boolean remote) {
        if (remote) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Depopulating revision for {0}", new Object[]{this});
        }
        super.eSetDirectResource((Resource.Internal)this.cdoStore().getResource(this));
        CDOStore store = this.cdoStore();
        this.eContainer = store.getContainer(this);
        this.eContainerFeatureID = store.getContainingFeatureID(this);
        if (this.eContainer != null && this.eContainmentFeature().isResolveProxies()) {
            CDOObjectImpl.adjustOppositeReference(this, this.eContainer, this.eContainmentFeature());
        }
        this.resetSettings();
        EClass eClass = this.eClass();
        int i = 0;
        while (i < eClass.getFeatureCount()) {
            EStructuralFeature eFeature = this.cdoInternalDynamicFeature(i);
            if (!eFeature.isTransient()) {
                CDOObjectImpl.revisionToInstanceFeature(this, this.revision, eFeature);
            }
            ++i;
        }
    }

    @Override
    public void cdoInternalPreCommit() {
    }

    @Override
    public void cdoInternalCleanup() {
    }

    @Override
    public InternalEObject cdoInternalInstance() {
        return this;
    }

    @Override
    public EStructuralFeature cdoInternalDynamicFeature(int dynamicFeatureID) {
        return this.eDynamicFeature(dynamicFeatureID);
    }

    public synchronized EList<Adapter> eAdapters() {
        if (this.eAdapters == null) {
            this.eAdapters = new BasicNotifierImpl.EAdapterList<Adapter>((Notifier)this){
                private static final long serialVersionUID = 1L;

                protected void didAdd(int index, Adapter newObject) {
                    super.didAdd(index, (Object)newObject);
                    if (!FSMUtil.isTransient(CDOObjectImpl.this)) {
                        CDOObjectImpl.this.cdoView().handleAddAdapter(CDOObjectImpl.this, newObject);
                    }
                }

                protected void didRemove(int index, Adapter oldObject) {
                    super.didRemove(index, (Object)oldObject);
                    if (!FSMUtil.isTransient(CDOObjectImpl.this)) {
                        CDOObjectImpl.this.cdoView().handleRemoveAdapter(CDOObjectImpl.this, oldObject);
                    }
                }
            };
        }
        return this.eAdapters;
    }

    public Resource.Internal eDirectResource() {
        if (FSMUtil.isTransient(this)) {
            return super.eDirectResource();
        }
        return (Resource.Internal)this.cdoStore().getResource(this);
    }

    public void dynamicSet(int dynamicFeatureID, Object value) {
        EStructuralFeature eStructuralFeature = this.eDynamicFeature(dynamicFeatureID);
        if (eStructuralFeature.isTransient()) {
            this.eSettings[dynamicFeatureID] = value;
        } else {
            this.eStore().set((InternalEObject)this, eStructuralFeature, -1, value);
            if (this.eIsCaching()) {
                this.eSettings[dynamicFeatureID] = value;
            }
        }
    }

    public void dynamicUnset(int dynamicFeatureID) {
        EStructuralFeature eStructuralFeature = this.eDynamicFeature(dynamicFeatureID);
        if (eStructuralFeature.isTransient()) {
            this.eSettings[dynamicFeatureID] = null;
        } else {
            this.eStore().unset((InternalEObject)this, this.eDynamicFeature(dynamicFeatureID));
            if (this.eIsCaching()) {
                this.eSettings[dynamicFeatureID] = null;
            }
        }
    }

    public InternalEObject.EStore eStore() {
        if (FSMUtil.isTransient(this)) {
            return CDOStoreSettingsImpl.INSTANCE;
        }
        return this.cdoStore();
    }

    public InternalEObject eInternalContainer() {
        InternalEObject container = FSMUtil.isTransient(this) ? this.eContainer : this.cdoStore().getContainer(this);
        return container;
    }

    public int eContainerFeatureID() {
        if (FSMUtil.isTransient(this)) {
            return this.eContainerFeatureID;
        }
        return this.cdoStore().getContainingFeatureID(this);
    }

    public NotificationChain eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID, NotificationChain msgs) {
        boolean moved;
        boolean isResourceRoot = this instanceof CDOResource && ((CDOResource)((Object)this)).isRoot();
        InternalEObject oldContainer = this.eInternalContainer();
        Resource.Internal oldResource = this.eDirectResource();
        Resource.Internal newResource = null;
        if (oldResource != null) {
            if (newContainer != null && !CDOObjectImpl.eContainmentFeature((EObject)this, (EObject)newContainer, (int)newContainerFeatureID).isResolveProxies()) {
                msgs = ((InternalEList)oldResource.getContents()).basicRemove((Object)this, msgs);
                this.eSetDirectResource(null);
                newResource = newContainer.eInternalResource();
            } else {
                oldResource = null;
            }
        } else {
            if (oldContainer != null) {
                oldResource = oldContainer.eInternalResource();
            }
            if (newContainer != null) {
                newResource = newContainer.eInternalResource();
            }
        }
        InternalCDOView oldView = this.view;
        CDOView newView = newResource != null && newResource instanceof CDOResource ? ((CDOResource)newResource).cdoView() : null;
        boolean bl = moved = oldView != null && oldView == newView;
        if (!moved && oldResource != null && !isResourceRoot) {
            oldResource.detached((EObject)this);
        }
        int oldContainerFeatureID = this.eContainerFeatureID();
        this.eBasicSetContainer(newContainer, newContainerFeatureID);
        if (!moved && oldResource != newResource && newResource != null) {
            newResource.attached((EObject)this);
        }
        if (this.eNotificationRequired()) {
            ENotificationImpl notification;
            if (oldContainer != null && oldContainerFeatureID >= 0 && oldContainerFeatureID != newContainerFeatureID) {
                notification = new ENotificationImpl((InternalEObject)this, 1, oldContainerFeatureID, (Object)oldContainer, null);
                if (msgs == null) {
                    msgs = notification;
                } else {
                    msgs.add((Notification)notification);
                }
            }
            if (newContainerFeatureID >= 0) {
                notification = new ENotificationImpl((InternalEObject)this, 1, newContainerFeatureID, oldContainerFeatureID == newContainerFeatureID ? oldContainer : null, (Object)newContainer);
                if (msgs == null) {
                    msgs = notification;
                } else {
                    msgs.add((Notification)notification);
                }
            }
        }
        return msgs;
    }

    public NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications) {
        InternalEObject oldContainer;
        boolean isSameView;
        Resource.Internal oldResource = this.eDirectResource();
        InternalCDOView oldView = this.view;
        CDOView newView = resource != null && resource instanceof CDOResource ? ((CDOResource)resource).cdoView() : null;
        boolean bl = isSameView = oldView != null && oldView == newView;
        if (oldResource != null) {
            notifications = ((InternalEList)oldResource.getContents()).basicRemove((Object)this, notifications);
            if (!isSameView && resource != null) {
                oldResource.detached((EObject)this);
            }
        }
        if ((oldContainer = this.eInternalContainer()) != null && !isSameView) {
            if (this.eContainmentFeature().isResolveProxies()) {
                Resource.Internal oldContainerResource = oldContainer.eInternalResource();
                if (oldContainerResource != null) {
                    if (resource == null) {
                        oldContainerResource.attached((EObject)this);
                    } else if (oldResource == null) {
                        oldContainerResource.detached((EObject)this);
                    }
                }
            } else {
                notifications = this.eBasicRemoveFromContainer(notifications);
                notifications = this.eBasicSetContainer(null, -1, notifications);
            }
        }
        this.eSetDirectResource(resource);
        return notifications;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        if (this.id == null) {
            return String.valueOf(this.eClass().getName()) + "?";
        }
        return String.valueOf(this.eClass().getName()) + "@" + this.id;
    }

    protected Object[] cdoSettings() {
        if (this.cdoSettings == null) {
            int size = this.eClass().getFeatureCount() - this.eStaticFeatureCount();
            this.cdoSettings = size == 0 ? ENO_SETTINGS : new Object[size];
        }
        return this.cdoSettings;
    }

    protected Object[] cdoBasicSettings() {
        return this.cdoSettings;
    }

    protected FeatureMap createFeatureMap(EStructuralFeature eStructuralFeature) {
        return new CDOStoreFeatureMap(eStructuralFeature);
    }

    protected EList<?> createList(EStructuralFeature eStructuralFeature) {
        EClassifier eType = eStructuralFeature.getEType();
        if (eType.getInstanceClassName() == "java.util.Map$Entry") {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class EStoreEcoreEMap
            extends EcoreEMap<Object, Object>
            implements InternalCDOLoadable {
                private static final long serialVersionUID = 1L;

                public EStoreEcoreEMap(EClassifier eClassifier, EStructuralFeature eStructuralFeature) {
                    super((EClass)eClassifier, BasicEMap.Entry.class, null);
                    this.delegateEList = new EStoreEObjectImpl.BasicEStoreEList<BasicEMap.Entry<Object, Object>>((InternalEObject)CDOObjectImpl.this, eStructuralFeature){
                        private static final long serialVersionUID = 1L;

                        protected void didAdd(int index, BasicEMap.Entry<Object, Object> newObject) {
                            this.doPut(newObject);
                        }

                        protected void didSet(int index, BasicEMap.Entry<Object, Object> newObject, BasicEMap.Entry<Object, Object> oldObject) {
                            this.didRemove(index, oldObject);
                            this.didAdd(index, newObject);
                        }

                        protected void didRemove(int index, BasicEMap.Entry<Object, Object> oldObject) {
                            this.doRemove(oldObject);
                        }

                        protected void didClear(int size, Object[] oldObjects) {
                            this.doClear();
                        }

                        protected void didMove(int index, BasicEMap.Entry<Object, Object> movedObject, int oldIndex) {
                            this.doMove(movedObject);
                        }
                    };
                    this.size = this.delegateEList.size();
                }

                private void checkListForReading() {
                    if (!FSMUtil.isTransient(CDOObjectImpl.this)) {
                        CDOStateMachine.INSTANCE.read(CDOObjectImpl.this);
                    }
                }

                protected synchronized void ensureEntryDataExists() {
                    this.checkListForReading();
                    super.ensureEntryDataExists();
                }

                public int size() {
                    this.checkListForReading();
                    return this.size;
                }

                public boolean isEmpty() {
                    this.checkListForReading();
                    return this.size == 0;
                }

                public boolean contains(Object object) {
                    this.checkListForReading();
                    return super.contains(object);
                }

                public boolean containsAll(Collection<?> collection) {
                    this.checkListForReading();
                    return super.containsAll(collection);
                }

                public boolean containsKey(Object key) {
                    this.checkListForReading();
                    return super.containsKey(key);
                }

                public boolean containsValue(Object value) {
                    this.checkListForReading();
                    return super.containsValue(value);
                }

                @Override
                public void cdoInternalPostLoad() {
                    this.entryData = null;
                    this.size = this.delegateEList.size();
                }

                @Override
                public void cdoInternalPreLoad() {
                }
            }
            return new EStoreEcoreEMap(eType, eStructuralFeature);
        }
        return super.createList(eStructuralFeature);
    }

    protected void eInitializeContainer() {
        throw new ImplementationError();
    }

    protected void eSetDirectResource(Resource.Internal resource) {
        if (FSMUtil.isTransient(this)) {
            super.eSetDirectResource(resource);
        } else if (resource instanceof CDOResourceImpl || resource == null) {
            this.cdoStore().setContainer(this, (CDOResourceImpl)resource, this.eInternalContainer(), this.eContainerFeatureID());
        } else {
            throw new IllegalArgumentException(Messages.getString("CDOObjectImpl.8"));
        }
    }

    protected boolean eDynamicIsSet(int dynamicFeatureID, EStructuralFeature eFeature) {
        return dynamicFeatureID < 0 ? this.eOpenIsSet(eFeature) : this.eSettingDelegate(eFeature).dynamicIsSet((InternalEObject)this, this.eSettings(), dynamicFeatureID);
    }

    protected boolean eIsCaching() {
        return false;
    }

    protected void eBasicSetContainer(InternalEObject newEContainer, int newContainerFeatureID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting container: {0}, featureID={1}", new Object[]{newEContainer, newContainerFeatureID});
        }
        if (FSMUtil.isTransient(this)) {
            super.eBasicSetContainer(newEContainer, newContainerFeatureID);
        } else {
            this.cdoStore().setContainer(this, this.cdoDirectResource(), newEContainer, newContainerFeatureID);
        }
    }

    private CDOStore cdoStore() {
        return this.cdoView().getStore();
    }

    private void resetSettings() {
        this.cdoSettings = null;
        this.cdoSettings();
    }

    private static void adjustOppositeReference(InternalCDOObject instance, InternalEObject object, EReference feature) {
        if (object != null) {
            InternalCDOObject cdoObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)object);
            if (cdoObject != null && !FSMUtil.isTransient(cdoObject)) {
                if (feature.isMany()) {
                    int index = cdoObject.eStore().indexOf((InternalEObject)cdoObject, (EStructuralFeature)feature, (Object)instance.cdoID());
                    if (index != -1) {
                        cdoObject.eStore().set((InternalEObject)cdoObject, (EStructuralFeature)feature, index, (Object)instance);
                    }
                } else {
                    cdoObject.eStore().set((InternalEObject)cdoObject, (EStructuralFeature)feature, 0, (Object)instance);
                }
            } else if (feature.isResolveProxies()) {
                if (feature.isMany()) {
                    InternalEList list = (InternalEList)object.eGet((EStructuralFeature)feature);
                    int index = list.indexOf((Object)instance);
                    if (index != -1) {
                        list.set(index, (Object)instance);
                    }
                } else {
                    object.eSet((EStructuralFeature)feature, (Object)instance);
                }
            }
        }
    }

    public static void revisionToInstanceFeature(InternalCDOObject instance, InternalCDORevision revision, EStructuralFeature eFeature) {
        if (TRACER.isEnabled()) {
            TRACER.format("Depopulating feature {0}", new Object[]{eFeature});
        }
        EStructuralFeature.Internal internalFeature = (EStructuralFeature.Internal)eFeature;
        EReference oppositeReference = instance.cdoID().isTemporary() ? null : internalFeature.getEOpposite();
        CDOStore cdoStore = instance.cdoView().getStore();
        InternalEObject.EStore eStore = instance.eStore();
        if (eFeature.isMany()) {
            int size = cdoStore.size(instance, eFeature);
            int index = 0;
            while (index < size) {
                Object object = cdoStore.get(instance, eFeature, index);
                eStore.add((InternalEObject)instance, eFeature, index, object);
                if (oppositeReference != null) {
                    CDOObjectImpl.adjustOppositeReference(instance, (InternalEObject)object, oppositeReference);
                }
                ++index;
            }
        } else {
            Object object = cdoStore.get(instance, eFeature, -1);
            eStore.set((InternalEObject)instance, eFeature, -1, object);
            if (oppositeReference != null) {
                CDOObjectImpl.adjustOppositeReference(instance, (InternalEObject)object, oppositeReference);
            }
        }
    }

    public static void instanceToRevisionFeature(InternalCDOView view, InternalCDORevision revision, EStructuralFeature feature, Object setting) {
        if (TRACER.isEnabled()) {
            TRACER.format("Populating feature {0}", new Object[]{feature});
        }
        CDOStore cdoStore = view.getStore();
        if (feature.isMany()) {
            if (setting != null) {
                int index = 0;
                EList list = (EList)setting;
                for (Object value : list) {
                    value = cdoStore.convertToCDO(feature, value);
                    revision.add(feature, index++, value);
                }
            }
        } else {
            setting = cdoStore.convertToCDO(feature, setting);
            revision.set(feature, 0, setting);
        }
    }

    private final class CDOLockImpl
    implements CDOLock {
        private RWLockManager.LockType type;

        public CDOLockImpl(RWLockManager.LockType type) {
            this.type = type;
        }

        public RWLockManager.LockType getType() {
            return this.type;
        }

        public boolean isLocked() {
            return CDOObjectImpl.this.cdoView().isObjectLocked(CDOObjectImpl.this, this.type, false);
        }

        public boolean isLockedByOthers() {
            return CDOObjectImpl.this.cdoView().isObjectLocked(CDOObjectImpl.this, this.type, true);
        }

        public void lock() {
            try {
                CDOObjectImpl.this.cdoView().lockObjects(Collections.singletonList(CDOObjectImpl.this), this.type, 0L);
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }

        public void lockInterruptibly() throws InterruptedException {
            this.lock();
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock() {
            try {
                CDOObjectImpl.this.cdoView().lockObjects(Collections.singletonList(CDOObjectImpl.this), this.type, 1L);
                return true;
            }
            catch (TimeoutRuntimeException timeoutRuntimeException) {
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            try {
                CDOObjectImpl.this.cdoView().lockObjects(Collections.singletonList(CDOObjectImpl.this), this.type, unit.toMillis(time));
                return true;
            }
            catch (TimeoutRuntimeException timeoutRuntimeException) {
                return false;
            }
        }

        public void unlock() {
            CDOObjectImpl.this.cdoView().unlockObjects(Collections.singletonList(CDOObjectImpl.this), this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CDOStoreFeatureMap
    extends DelegatingFeatureMap {
        private static final long serialVersionUID = 1L;

        public CDOStoreFeatureMap(EStructuralFeature eStructuralFeature) {
            super((InternalEObject)CDOObjectImpl.this, eStructuralFeature);
        }

        protected List<FeatureMap.Entry> delegateList() {
            throw new UnsupportedOperationException();
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        protected void delegateAdd(int index, FeatureMap.Entry object) {
            CDOObjectImpl.this.eStore().add(this.owner, this.eStructuralFeature, index, (Object)object);
        }

        protected void delegateAdd(FeatureMap.Entry object) {
            this.delegateAdd(this.delegateSize(), object);
        }

        protected List<FeatureMap.Entry> delegateBasicList() {
            int size = this.delegateSize();
            if (size == 0) {
                return ECollections.emptyEList();
            }
            Object[] data = CDOObjectImpl.this.cdoStore().toArray(this.owner, this.eStructuralFeature);
            return new EcoreEList.UnmodifiableEList(this.owner, this.eStructuralFeature, data.length, data);
        }

        protected void delegateClear() {
            CDOObjectImpl.this.eStore().clear(this.owner, this.eStructuralFeature);
        }

        protected boolean delegateContains(Object object) {
            return CDOObjectImpl.this.eStore().contains(this.owner, this.eStructuralFeature, object);
        }

        protected boolean delegateContainsAll(Collection<?> collection) {
            for (Object o : collection) {
                if (this.delegateContains(o)) continue;
                return false;
            }
            return true;
        }

        protected FeatureMap.Entry delegateGet(int index) {
            return (FeatureMap.Entry)CDOObjectImpl.this.eStore().get(this.owner, this.eStructuralFeature, index);
        }

        protected int delegateHashCode() {
            return CDOObjectImpl.this.eStore().hashCode(this.owner, this.eStructuralFeature);
        }

        protected int delegateIndexOf(Object object) {
            return CDOObjectImpl.this.eStore().indexOf(this.owner, this.eStructuralFeature, object);
        }

        protected boolean delegateIsEmpty() {
            return CDOObjectImpl.this.eStore().isEmpty(this.owner, this.eStructuralFeature);
        }

        protected Iterator<FeatureMap.Entry> delegateIterator() {
            return this.iterator();
        }

        protected int delegateLastIndexOf(Object object) {
            return CDOObjectImpl.this.eStore().lastIndexOf(this.owner, this.eStructuralFeature, object);
        }

        protected ListIterator<FeatureMap.Entry> delegateListIterator() {
            return this.listIterator();
        }

        protected FeatureMap.Entry delegateRemove(int index) {
            return (FeatureMap.Entry)CDOObjectImpl.this.eStore().remove(this.owner, this.eStructuralFeature, index);
        }

        protected FeatureMap.Entry delegateSet(int index, FeatureMap.Entry object) {
            return (FeatureMap.Entry)CDOObjectImpl.this.eStore().set(this.owner, this.eStructuralFeature, index, (Object)object);
        }

        protected int delegateSize() {
            return CDOObjectImpl.this.eStore().size(this.owner, this.eStructuralFeature);
        }

        protected Object[] delegateToArray() {
            return CDOObjectImpl.this.eStore().toArray(this.owner, this.eStructuralFeature);
        }

        protected <T> T[] delegateToArray(T[] array) {
            return CDOObjectImpl.this.eStore().toArray(this.owner, this.eStructuralFeature, (Object[])array);
        }

        protected FeatureMap.Entry delegateMove(int targetIndex, int sourceIndex) {
            return (FeatureMap.Entry)CDOObjectImpl.this.eStore().move(this.owner, this.eStructuralFeature, targetIndex, sourceIndex);
        }

        protected String delegateToString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            int i = 0;
            int size = this.size();
            while (i < size) {
                FeatureMap.Entry value = this.delegateGet(i);
                stringBuffer.append(String.valueOf(value));
                if (++i >= size) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CDOStoreSettingsImpl
    implements InternalEObject.EStore {
        public static CDOStoreSettingsImpl INSTANCE = new CDOStoreSettingsImpl();

        private CDOStoreSettingsImpl() {
        }

        protected Object getValue(InternalEObject eObject, int dynamicFeatureID) {
            return ((CDOObjectImpl)eObject).cdoSettings()[dynamicFeatureID];
        }

        protected EList<Object> getValueAsList(InternalEObject eObject, int dynamicFeatureID) {
            EList result = (EList)this.getValue(eObject, dynamicFeatureID);
            if (result == null) {
                result = new BasicEList();
                ((CDOObjectImpl)eObject).cdoSettings()[dynamicFeatureID] = result;
            }
            return result;
        }

        protected Object setValue(InternalEObject eObject, int dynamicFeatureID, Object newValue) {
            Object[] eSettings = ((CDOObjectImpl)eObject).cdoSettings();
            try {
                Object object = eSettings[dynamicFeatureID];
                return object;
            }
            finally {
                eSettings[dynamicFeatureID] = newValue;
            }
        }

        protected int eDynamicFeatureID(InternalEObject eObject, EStructuralFeature feature) {
            return ((CDOObjectImpl)eObject).eDynamicFeatureID(feature);
        }

        public Object get(InternalEObject eObject, EStructuralFeature feature, int index) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            if (index != -1) {
                return this.getValueAsList(eObject, dynamicFeatureID).get(index);
            }
            return this.getValue(eObject, dynamicFeatureID);
        }

        public Object set(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            if (index != -1) {
                return this.getValueAsList(eObject, dynamicFeatureID).set(index, value);
            }
            return this.setValue(eObject, dynamicFeatureID, value);
        }

        public void add(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            this.getValueAsList(eObject, dynamicFeatureID).add(index, value);
        }

        public Object remove(InternalEObject eObject, EStructuralFeature feature, int index) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).remove(index);
        }

        public Object move(InternalEObject eObject, EStructuralFeature feature, int targetIndex, int sourceIndex) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).move(targetIndex, sourceIndex);
        }

        public void clear(InternalEObject eObject, EStructuralFeature feature) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            if (feature.isMany()) {
                this.getValueAsList(eObject, dynamicFeatureID).clear();
            }
            this.setValue(eObject, dynamicFeatureID, null);
        }

        public int size(InternalEObject eObject, EStructuralFeature feature) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).size();
        }

        public int indexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).indexOf(value);
        }

        public int lastIndexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).lastIndexOf(value);
        }

        public Object[] toArray(InternalEObject eObject, EStructuralFeature feature) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).toArray();
        }

        public <T> T[] toArray(InternalEObject eObject, EStructuralFeature feature, T[] array) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).toArray((Object[])array);
        }

        public boolean isEmpty(InternalEObject eObject, EStructuralFeature feature) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).isEmpty();
        }

        public boolean contains(InternalEObject eObject, EStructuralFeature feature, Object value) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).contains(value);
        }

        public int hashCode(InternalEObject eObject, EStructuralFeature feature) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValueAsList(eObject, dynamicFeatureID).hashCode();
        }

        public InternalEObject getContainer(InternalEObject eObject) {
            return null;
        }

        public EStructuralFeature getContainingFeature(InternalEObject eObject) {
            throw new UnsupportedOperationException();
        }

        public EObject create(EClass eClass) {
            return new EStoreEObjectImpl(eClass, (InternalEObject.EStore)this);
        }

        public boolean isSet(InternalEObject eObject, EStructuralFeature feature) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            return this.getValue(eObject, dynamicFeatureID) != null;
        }

        public void unset(InternalEObject eObject, EStructuralFeature feature) {
            int dynamicFeatureID = this.eDynamicFeatureID(eObject, feature);
            this.setValue(eObject, dynamicFeatureID, null);
        }
    }
}

