/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.InternalCDORevisionDelta;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionDeltaImpl
implements InternalCDORevisionDelta {
    private CDOID cdoID;
    private CDOClass cdoClass;
    private int dirtyVersion;
    private int originVersion;
    private Map<CDOFeature, CDOFeatureDelta> featureDeltas = new HashMap<CDOFeature, CDOFeatureDelta>();

    public CDORevisionDeltaImpl(CDORevision revision) {
        this.cdoID = revision.getID();
        this.cdoClass = revision.getCDOClass();
        this.dirtyVersion = revision.getVersion();
        this.originVersion = this.dirtyVersion - 1;
    }

    public CDORevisionDeltaImpl(CDORevision originRevision, CDORevision dirtyRevision) {
        if (originRevision.getCDOClass() != dirtyRevision.getCDOClass()) {
            throw new IllegalArgumentException();
        }
        this.cdoID = originRevision.getID();
        this.cdoClass = originRevision.getCDOClass();
        this.dirtyVersion = dirtyRevision.getVersion();
        this.originVersion = originRevision.getVersion();
        this.compare(originRevision, dirtyRevision);
        CDORevisionData originData = originRevision.getData();
        CDORevisionData dirtyData = dirtyRevision.getData();
        if (!this.compare(originData.getContainerID(), dirtyData.getContainerID()) || !this.compare(originData.getContainingFeatureID(), dirtyData.getContainingFeatureID())) {
            this.addFeatureDelta(new CDOContainerFeatureDeltaImpl(dirtyData.getContainerID(), dirtyData.getContainingFeatureID()));
        }
    }

    public CDORevisionDeltaImpl(ExtendedDataInput in, CDOPackageManager packageManager) throws IOException {
        CDOClassRef classRef = CDOModelUtil.readClassRef(in);
        this.cdoClass = classRef.resolve(packageManager);
        this.cdoID = CDOIDUtil.read(in, packageManager.getCDOIDObjectFactory());
        this.originVersion = in.readInt();
        this.dirtyVersion = in.readInt();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            CDOFeatureDeltaImpl featureDelta = CDOFeatureDeltaImpl.read(in, this.cdoClass);
            this.featureDeltas.put(featureDelta.getFeature(), featureDelta);
            ++i;
        }
    }

    @Override
    public void write(ExtendedDataOutput out, CDOIDProvider idProvider) throws IOException {
        CDOClassRef classRef = this.cdoClass.createClassRef();
        CDOModelUtil.writeClassRef(out, classRef);
        CDOIDUtil.write(out, this.cdoID);
        out.writeInt(this.originVersion);
        out.writeInt(this.dirtyVersion);
        out.writeInt(this.featureDeltas.size());
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).write(out, this.cdoClass, idProvider);
        }
    }

    @Override
    public CDOID getID() {
        return this.cdoID;
    }

    @Override
    public int getOriginVersion() {
        return this.originVersion;
    }

    @Override
    public int getDirtyVersion() {
        return this.dirtyVersion;
    }

    @Override
    public List<CDOFeatureDelta> getFeatureDeltas() {
        return new ArrayList<CDOFeatureDelta>(this.featureDeltas.values());
    }

    @Override
    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).setVersion(this.dirtyVersion);
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).apply(revision);
        }
    }

    @Override
    public void addFeatureDelta(CDOFeatureDelta delta) {
        CDOFeature feature = delta.getFeature();
        if (feature.isMany()) {
            CDOListFeatureDeltaImpl lookupDelta = (CDOListFeatureDeltaImpl)this.featureDeltas.get(feature);
            if (lookupDelta == null) {
                lookupDelta = new CDOListFeatureDeltaImpl(feature);
                this.featureDeltas.put(lookupDelta.getFeature(), lookupDelta);
            }
            if (delta instanceof CDOClearFeatureDelta) {
                lookupDelta.getListChanges().clear();
            }
            lookupDelta.add(delta);
        } else {
            this.featureDeltas.put(feature, delta);
        }
    }

    @Override
    public void adjustReferences(Map<CDOIDTemp, CDOID> idMappings) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).adjustReferences(idMappings);
        }
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).accept(visitor);
        }
    }

    private void compare(CDORevision originRevision, CDORevision dirtyRevision) {
        CDOFeature[] features = this.cdoClass.getAllFeatures();
        int count = this.cdoClass.getFeatureCount();
        int i = 0;
        while (i < count) {
            CDOFeature feature = features[i];
            if (feature.isMany()) {
                int originSize = originRevision.getData().size(feature);
                int dirtySize = dirtyRevision.getData().size(feature);
                if (dirtySize == 0 && originSize > 0) {
                    this.addFeatureDelta(new CDOClearFeatureDeltaImpl(feature));
                } else {
                    Object dirtyValue;
                    int originIndex = 0;
                    int dirtyIndex = 0;
                    if (originSize == dirtySize) {
                        while (originIndex < originSize && dirtyIndex < dirtySize) {
                            Object originValue = originRevision.getData().get(feature, originIndex);
                            if (!this.compare(originValue, dirtyValue = dirtyRevision.getData().get(feature, dirtyIndex))) {
                                dirtyIndex = 0;
                                break;
                            }
                            ++dirtyIndex;
                            ++originIndex;
                        }
                    }
                    if (originIndex != originSize || dirtyIndex != dirtySize) {
                        if (originSize > 0) {
                            this.addFeatureDelta(new CDOClearFeatureDeltaImpl(feature));
                        }
                        int k = 0;
                        while (k < dirtySize) {
                            dirtyValue = dirtyRevision.getData().get(feature, k);
                            this.addFeatureDelta(new CDOAddFeatureDeltaImpl(feature, k, dirtyValue));
                            ++k;
                        }
                    }
                }
            } else {
                Object dirtyValue;
                Object originValue = originRevision.getData().get(feature, 0);
                if (!this.compare(originValue, dirtyValue = dirtyRevision.getData().get(feature, 0))) {
                    if (dirtyValue == null) {
                        this.addFeatureDelta(new CDOUnsetFeatureDeltaImpl(feature));
                    } else {
                        this.addFeatureDelta(new CDOSetFeatureDeltaImpl(feature, 0, dirtyValue));
                    }
                }
            }
            ++i;
        }
    }

    private boolean compare(Object originValue, Object dirtyValue) {
        return originValue == dirtyValue || originValue != null && dirtyValue != null && originValue.equals(dirtyValue);
    }
}

