/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.common.revision.DLRevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.LRURevisionList;

public class LRURevisionHolder
extends DLRevisionHolder {
    private long usedStamp = System.currentTimeMillis();

    public LRURevisionHolder(LRURevisionList list, CDORevision revision) {
        super(list, revision);
    }

    public LRURevisionList getDLList() {
        return (LRURevisionList)super.getDLList();
    }

    public long getUsedStamp() {
        return this.usedStamp;
    }

    public CDORevision getRevision(boolean loadOnDemand) {
        if (loadOnDemand) {
            this.stamp();
        }
        return super.getRevision(loadOnDemand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stamp() {
        this.usedStamp = System.currentTimeMillis();
        LRURevisionList list = this.getDLList();
        if (list != null) {
            LRURevisionList lRURevisionList = list;
            synchronized (lRURevisionList) {
                list.remove(this);
                list.addHead(this);
            }
        }
    }
}

