/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.analyzer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOFetchRule {
    private CDOClass cdoClass;
    private List<CDOFeature> features = new ArrayList<CDOFeature>(0);

    public CDOFetchRule(CDOClass cdoClass) {
        this.cdoClass = cdoClass;
    }

    public CDOFetchRule(ExtendedDataInput in, CDOPackageManager packageManager) throws IOException {
        CDOClassRef classRef = CDOModelUtil.readClassRef(in);
        this.cdoClass = classRef.resolve(packageManager);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            int featureID = in.readInt();
            CDOFeature feature = this.cdoClass.lookupFeature(featureID);
            this.features.add(feature);
            ++i;
        }
    }

    public void write(ExtendedDataOutput out) throws IOException {
        CDOModelUtil.writeClassRef(out, this.cdoClass.createClassRef());
        out.writeInt(this.features.size());
        for (CDOFeature feature : this.features) {
            out.writeInt(feature.getFeatureID());
        }
    }

    public CDOClass getCDOClass() {
        return this.cdoClass;
    }

    public List<CDOFeature> getFeatures() {
        return this.features;
    }

    public void addFeature(CDOFeature feature) {
        this.features.add(feature);
    }

    public void removeFeature(CDOFeature feature) {
        this.features.remove(feature);
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }
}

