/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.epatch.diff;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.epatch.AbstractEpatchBuilder;
import org.eclipse.emf.compare.epatch.AssignmentValue;
import org.eclipse.emf.compare.epatch.CreatedObject;
import org.eclipse.emf.compare.epatch.Epatch;
import org.eclipse.emf.compare.epatch.ListAssignment;
import org.eclipse.emf.compare.epatch.NamedObject;
import org.eclipse.emf.compare.epatch.NamedResource;
import org.eclipse.emf.compare.epatch.ObjectRef;
import org.eclipse.emf.compare.epatch.SingleAssignment;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffEpatchService
extends AbstractEpatchBuilder {
    protected DiffModel diff;
    protected MatchModel match;
    protected Map<EObject, Match2Elements> matchMap = new HashMap<EObject, Match2Elements>();
    protected NamedResource res;
    protected Set<EObject> unmatches = new HashSet<EObject>();

    public static Epatch createEpatch(MatchModel match, DiffModel diff, String name) {
        DiffEpatchService dt = new DiffEpatchService(match, diff, name);
        return dt.convert();
    }

    protected DiffEpatchService(MatchModel match, DiffModel diff, String name) {
        this.match = match;
        this.diff = diff;
        this.epatch = this.createEpatch(name);
    }

    protected Epatch convert() {
        this.res = this.createResource();
        this.epatch.getResources().add((Object)this.res);
        this.fillMatchMap((EList<MatchElement>)this.match.getMatchedElements());
        this.fillUnmatchSet((EList<UnmatchElement>)this.match.getUnmatchedElements());
        TreeIterator i = this.diff.eAllContents();
        while (i.hasNext()) {
            EObject o = (EObject)i.next();
            if (o instanceof ModelElementChangeLeftTarget) {
                this.handleEleChangeLeft((ModelElementChangeLeftTarget)o);
                continue;
            }
            if (o instanceof ModelElementChangeRightTarget) {
                this.handleEleChangeRight((ModelElementChangeRightTarget)o);
                continue;
            }
            if (o instanceof MoveModelElement) {
                this.handleEleMove((MoveModelElement)o);
                continue;
            }
            if (o instanceof AttributeChangeLeftTarget) {
                this.handleAttrChangeLeft((AttributeChangeLeftTarget)o);
                continue;
            }
            if (o instanceof AttributeChangeRightTarget) {
                this.handleAttrChangeRight((AttributeChangeRightTarget)o);
                continue;
            }
            if (o instanceof UpdateAttribute) {
                this.handleAttrUpdate((UpdateAttribute)o);
                continue;
            }
            if (o instanceof ReferenceChangeRightTarget) {
                this.handleRefChangeRight((ReferenceChangeRightTarget)o);
                continue;
            }
            if (o instanceof ReferenceChangeLeftTarget) {
                this.handleRefChangeLeft((ReferenceChangeLeftTarget)o);
                continue;
            }
            if (o instanceof UpdateReference) {
                this.handleRefUpdate((UpdateReference)o);
                continue;
            }
            if (o instanceof ReferenceOrderChange) {
                this.handleRefOrderChange((ReferenceOrderChange)o);
                continue;
            }
            if (o instanceof DiffGroup) continue;
            throw new RuntimeException("Warning: Didn't handle " + o.eClass().getName() + ": " + o);
        }
        this.generateNames();
        this.sortLists();
        return this.epatch;
    }

    protected ObjectRef createObjectRef(EObject left, EObject right) {
        ObjectRef r = fc.createObjectRef();
        this.objMap.put(left, r);
        String lfrag = this.getFragment(left);
        String rfrag = this.getFragment(right);
        if (!lfrag.equals(rfrag)) {
            r.setRightFrag(rfrag);
            r.setRightRes(this.res);
        }
        r.setLeftRes(this.res);
        r.setLeftFrag(lfrag);
        this.epatch.getObjects().add((Object)r);
        return r;
    }

    protected NamedResource createResource() {
        NamedResource r = fc.createNamedResource();
        r.setLeftUri(((EObject)this.diff.getLeftRoots().get(0)).eResource().getURI().lastSegment());
        r.setRightUri(((EObject)this.diff.getRightRoots().get(0)).eResource().getURI().lastSegment());
        r.setName("res0");
        return r;
    }

    protected void doAdd(EObject left, EObject right, EStructuralFeature feat, Object val) {
        if (feat.isMany()) {
            if (this.ignoreFeature(feat)) {
                return;
            }
            NamedObject o = this.getNamedObject(left, right);
            ListAssignment ass = this.getListAssignment(o, feat);
            EList list = (EList)right.eGet(feat);
            int index = list.indexOf(val);
            ass.getRightValues().add((Object)this.getListAssignmentValue(feat, val, index));
        } else {
            this.doSet(left, right, feat);
        }
    }

    protected void doRemove(EObject left, EObject right, EStructuralFeature feat, Object value) {
        if (feat.isMany()) {
            if (this.ignoreFeature(feat)) {
                return;
            }
            NamedObject o = this.getNamedObject(left, right);
            ListAssignment ass = this.getListAssignment(o, feat);
            EList list = (EList)left.eGet(feat);
            int index = list.indexOf(value);
            ass.getLeftValues().add((Object)this.getListAssignmentValue(feat, value, index));
        } else {
            this.doSet(left, right, feat);
        }
    }

    protected void doSet(EObject left, EObject right, EStructuralFeature feat) {
        if (this.ignoreFeature(feat)) {
            return;
        }
        NamedObject o = this.getNamedObject(left, right);
        SingleAssignment ass = this.getSingleAssignment(o, feat);
        Object lobj = left.eGet(feat);
        Object robj = right.eGet(feat);
        ass.setLeftValue(this.getAssignmentValue(feat, lobj));
        ass.setRightValue(this.getAssignmentValue(feat, robj));
    }

    protected void fillMatchMap(EList<MatchElement> elements) {
        for (MatchElement e : elements) {
            if (e instanceof Match2Elements) {
                Match2Elements e2 = (Match2Elements)e;
                this.matchMap.put(e2.getLeftElement(), e2);
                this.matchMap.put(e2.getRightElement(), e2);
            }
            this.fillMatchMap((EList<MatchElement>)e.getSubMatchElements());
        }
    }

    protected void fillUnmatchSet(EList<UnmatchElement> elements) {
        for (UnmatchElement e : elements) {
            this.unmatches.add(e.getElement());
            TreeIterator i = e.getElement().eAllContents();
            while (i.hasNext()) {
                this.unmatches.add((EObject)i.next());
            }
        }
    }

    @Override
    protected AssignmentValue getAssignmentValueEObject(EReference ref, EObject eobj) {
        AssignmentValue ass = fc.createAssignmentValue();
        NamedObject no = this.getNamedObject(eobj);
        if (no != null) {
            if (ref.isContainment()) {
                if (no instanceof CreatedObject) {
                    ass.setNewObject((CreatedObject)no);
                } else {
                    ass.setRefObject(no);
                }
            } else {
                ass.setRefObject(no);
            }
        } else {
            ass.setImport(this.getImportRef(eobj));
            ass.setImpFrag(this.getFragment(eobj));
        }
        return ass;
    }

    protected NamedObject getNamedObject(EObject object) {
        NamedObject o = (NamedObject)this.objMap.get(object);
        if (o != null) {
            return o;
        }
        Match2Elements m = this.matchMap.get(object);
        if (m != null) {
            if (object != m.getLeftElement() && (o = (NamedObject)this.objMap.get(m.getLeftElement())) != null) {
                return o;
            }
            return this.createObjectRef(m.getLeftElement(), m.getRightElement());
        }
        if (this.unmatches.contains(object)) {
            return this.createObjectNew(object);
        }
        return o;
    }

    protected NamedObject getNamedObject(EObject left, EObject right) {
        NamedObject o = (NamedObject)this.objMap.get(left);
        if (o == null) {
            return this.createObjectRef(left, right);
        }
        return o;
    }

    protected void handleAttrChangeLeft(AttributeChangeLeftTarget ele) {
        this.doRemove(ele.getLeftElement(), ele.getRightElement(), (EStructuralFeature)ele.getAttribute(), ele.getLeftTarget());
    }

    protected void handleAttrChangeRight(AttributeChangeRightTarget ele) {
        this.doAdd(ele.getLeftElement(), ele.getRightElement(), (EStructuralFeature)ele.getAttribute(), ele.getRightTarget());
    }

    protected void handleAttrUpdate(UpdateAttribute ele) {
        this.doSet(ele.getLeftElement(), ele.getRightElement(), (EStructuralFeature)ele.getAttribute());
    }

    protected void handleEleChangeLeft(ModelElementChangeLeftTarget ele) {
        EObject leftParent = ele.getLeftElement().eContainer();
        EReference ref = ele.getLeftElement().eContainmentFeature();
        this.doRemove(leftParent, ele.getRightParent(), (EStructuralFeature)ref, ele.getLeftElement());
    }

    protected void handleEleChangeRight(ModelElementChangeRightTarget ele) {
        EObject rightParent = ele.getRightElement().eContainer();
        EReference ref = ele.getRightElement().eContainmentFeature();
        this.doAdd(ele.getLeftParent(), rightParent, (EStructuralFeature)ref, ele.getRightElement());
    }

    protected void handleEleMove(MoveModelElement ele) {
        EReference remRef = ele.getRightElement().eContainmentFeature();
        EObject remLeft = this.matchMap.get(ele.getRightTarget()).getLeftElement();
        EObject remRight = ele.getRightTarget();
        this.doRemove(remLeft, remRight, (EStructuralFeature)remRef, ele.getLeftElement());
        EReference addRef = ele.getLeftElement().eContainmentFeature();
        EObject addLeft = ele.getLeftTarget();
        EObject addRight = this.matchMap.get(ele.getLeftTarget()).getRightElement();
        this.doAdd(addLeft, addRight, (EStructuralFeature)addRef, ele.getRightElement());
    }

    protected void handleRefChangeLeft(ReferenceChangeLeftTarget ele) {
        this.doRemove(ele.getLeftElement(), ele.getRightElement(), (EStructuralFeature)ele.getReference(), ele.getLeftTarget());
    }

    protected void handleRefChangeRight(ReferenceChangeRightTarget ele) {
        this.doAdd(ele.getLeftElement(), ele.getRightElement(), (EStructuralFeature)ele.getReference(), ele.getRightTarget());
    }

    protected void handleRefUpdate(UpdateReference ele) {
        this.doSet(ele.getLeftElement(), ele.getRightElement(), (EStructuralFeature)ele.getReference());
    }

    protected void handleRefOrderChange(ReferenceOrderChange ele) {
        if (this.ignoreFeature((EStructuralFeature)ele.getReference())) {
            return;
        }
        NamedObject o = this.getNamedObject(ele.getLeftElement(), ele.getRightElement());
        ListAssignment ass = this.getListAssignment(o, (EStructuralFeature)ele.getReference());
        int l = 0;
        while (l < ele.getLeftTarget().size()) {
            int r;
            Match2Elements m = this.matchMap.get(l);
            if (m != null && (r = ele.getRightTarget().indexOf((Object)m.getRightElement())) >= 0) {
                ass.getLeftValues().add((Object)this.getListAssignmentValue((EStructuralFeature)ele.getReference(), m.getLeftElement(), l));
                ass.getRightValues().add((Object)this.getListAssignmentValue((EStructuralFeature)ele.getReference(), m.getRightElement(), r));
            }
            ++l;
        }
    }
}

