/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.admin.actions;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.admin.CDOAdminClient;
import org.eclipse.emf.cdo.ui.internal.admin.actions.AdminAction;
import org.eclipse.emf.cdo.ui.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.ui.internal.admin.messages.Messages;
import org.eclipse.emf.cdo.ui.internal.admin.wizards.CreateRepositoryWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class CreateRepositoryAction
extends AdminAction<CDOAdminClient> {
    private String repositoryName;
    private Map<String, Object> repositoryProperties;

    public CreateRepositoryAction(CDOAdminClient admin) {
        super(Messages.CreateRepositoryAction_0, Messages.CreateRepositoryAction_1, OM.getImageDescriptor("icons/full/ctool16/create_repo.gif"), admin);
    }

    protected void preRun() throws Exception {
        CreateRepositoryWizard wizard = new CreateRepositoryWizard();
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            this.repositoryName = wizard.getRepositoryName();
            this.repositoryProperties = wizard.getRepositoryProperties();
        } else {
            this.cancel();
        }
    }

    @Override
    protected void safeRun(IProgressMonitor progressMonitor) throws Exception {
        try {
            ((CDOAdminClient)this.target).createRepository(this.repositoryName, "default", this.repositoryProperties);
        }
        finally {
            this.repositoryName = null;
            this.repositoryProperties = null;
        }
    }

    @Override
    protected String getErrorPattern() {
        return Messages.CreateRepositoryAction_2;
    }
}

