/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.ws.jetty;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.internal.net4j.buffer.Buffer;
import org.eclipse.internal.net4j.buffer.BufferUtil;
import org.eclipse.jetty.ee8.websocket.api.Session;
import org.eclipse.jetty.ee8.websocket.api.WebSocketListener;
import org.eclipse.jetty.ee8.websocket.api.WriteCallback;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.internal.ws.WSAcceptor;
import org.eclipse.net4j.internal.ws.WSAcceptorManager;
import org.eclipse.net4j.internal.ws.WSConnector;
import org.eclipse.net4j.internal.ws.bundle.OM;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ISynchronizer;
import org.eclipse.net4j.util.concurrent.SynchronizingCorrelator;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.net4j.ws.IWSConnector;
import org.eclipse.spi.net4j.InternalChannel;

public class Net4jWebSocket
implements WebSocketListener {
    public static final short CONTROL_CHANNEL_ID = 0;
    public static final byte OPCODE_NEGOTIATION = 1;
    public static final byte OPCODE_REGISTRATION = 2;
    public static final byte OPCODE_REGISTRATION_ACK = 3;
    public static final byte OPCODE_DEREGISTRATION = 4;
    private static final long SESSION_IDLE_TIMEOUT = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.ws.jetty.Net4jWebSocket.sessionIdleTimeout", 30000);
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, Net4jWebSocket.class);
    private static final String SUCCESS = "Success";
    private static Timer timer;
    private static int timerClients;
    private final SynchronizingCorrelator<Short, String> acknowledgements = new SynchronizingCorrelator();
    private volatile WSConnector connector;
    private volatile Session session;
    private TimerTask pongTask;

    public Net4jWebSocket() {
    }

    public Net4jWebSocket(IWSConnector connector) {
        this.connector = (WSConnector)connector;
    }

    public IWSConnector getConnector() {
        return this.connector;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isClient() {
        return this.pongTask != null;
    }

    public void onWebSocketConnect(Session session) {
        boolean client;
        this.session = session;
        session.setIdleTimeout(Duration.ofMillis(SESSION_IDLE_TIMEOUT));
        boolean bl = client = this.connector != null;
        if (client) {
            this.pongTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Session session = Net4jWebSocket.this.getSession();
                        if (session != null) {
                            session.getRemote().sendPong(null);
                        }
                    }
                    catch (IOException ex) {
                        OM.LOG.warn((Throwable)ex);
                    }
                }
            };
            this.acquireTimer().scheduleAtFixedRate(this.pongTask, 20000L, 20000L);
            this.connector.leaveConnecting();
        } else {
            String acceptorName = session.getUpgradeRequest().getHeader("Net4jAcceptor");
            WSAcceptor acceptor = WSAcceptorManager.INSTANCE.getAcceptor(acceptorName);
            if (acceptor == null) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Acceptor {0} not found", new Object[]{acceptorName});
                }
                session.close(1011, "Acceptor not found");
                return;
            }
            this.connector = acceptor.handleAccept(this);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Connection established: {0}", new Object[]{this.connector});
        }
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.session = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Connection closed: {0}", new Object[]{this.connector});
        }
        if (this.pongTask != null) {
            this.pongTask.cancel();
            this.pongTask = null;
            this.releaseTimer();
        }
        if (this.connector != null) {
            this.connector.inverseClose();
            this.connector = null;
        }
    }

    private synchronized Timer acquireTimer() {
        if (timer == null) {
            timer = new Timer(true);
        }
        ++timerClients;
        return timer;
    }

    private synchronized void releaseTimer() {
        if (--timerClients == 0) {
            timer.cancel();
            timer = null;
        }
    }

    private synchronized void sendBytes(final IBuffer buffer) {
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        this.session.getRemote().sendBytes(byteBuffer, new WriteCallback(){

            public void writeSuccess() {
                buffer.release();
            }

            public void writeFailed(Throwable ex) {
                OM.LOG.error(ex);
                buffer.release();
                Net4jWebSocket.this.connector.deactivate();
            }
        });
    }

    public void registerChannel(short channelID, long timeout, IProtocol<?> protocol) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering channel {0} with protocol {1}", new Object[]{channelID, protocol});
        }
        this.assertValidChannelID(channelID);
        ISynchronizer acknowledgement = this.acknowledgements.correlate((Object)channelID);
        int protocolVersion = Net4jUtil.getProtocolVersion(protocol);
        String protocolID = Net4jUtil.getProtocolID(protocol);
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put((byte)2);
        byteBuffer.putShort(channelID);
        byteBuffer.putInt(protocolVersion);
        BufferUtil.putString((ByteBuffer)byteBuffer, (String)protocolID, (boolean)false);
        this.sendBuffer(buffer);
        String error = (String)acknowledgement.get(timeout);
        if (error == null) {
            throw new TimeoutRuntimeException(MessageFormat.format("Registration timeout after {0} milliseconds", timeout));
        }
        if (error != SUCCESS) {
            throw new ChannelException("Failed to register channel with peer: " + error);
        }
    }

    private void onRegistration(short channelID, int protocolVersion, String protocolID) {
        String error;
        block4: {
            this.assertConnected();
            this.assertValidChannelID(channelID);
            error = "";
            try {
                InternalChannel channel = this.connector.inverseOpenChannel(channelID, protocolID, protocolVersion);
                if (channel == null) {
                    throw new ConnectorException("Could not open channel");
                }
            }
            catch (Exception ex) {
                error = ex.getMessage();
                if (error == null) {
                    error = "Unknown error";
                }
                if (!TRACER.isEnabled()) break block4;
                TRACER.trace("Problem during channel registration", (Throwable)ex);
            }
        }
        this.acknowledgeRegistration(channelID, error);
    }

    private void acknowledgeRegistration(short channelID, String error) {
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put((byte)3);
        byteBuffer.putShort(channelID);
        BufferUtil.putString((ByteBuffer)byteBuffer, (String)error, (boolean)true);
        this.sendBuffer(buffer);
    }

    private void onRegistrationAck(short channelID, String error) {
        this.assertConnected();
        this.assertValidChannelID(channelID);
        if (error != null && error.isEmpty()) {
            error = SUCCESS;
        }
        this.acknowledgements.put((Object)channelID, (Object)error);
    }

    public void deregisterChannel(short channelID) throws IOException {
        if (this.session == null) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Deregistering channel {0}", new Object[]{channelID});
        }
        this.assertValidChannelID(channelID);
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put((byte)4);
        byteBuffer.putShort(channelID);
        this.sendBuffer(buffer);
    }

    private void onDeregistration(short channelID) {
        block2: {
            try {
                this.assertConnected();
                this.assertValidChannelID(channelID);
                this.connector.inverseCloseChannel(channelID);
            }
            catch (Throwable ex) {
                if (!TRACER.isEnabled()) break block2;
                TRACER.trace("Problem during channel deregistration", ex);
            }
        }
    }

    public void sendBuffer(IBuffer buffer) {
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = byteBuffer.position();
        if (position < 4) {
            buffer.release();
            throw new IllegalArgumentException("Illegal buffer size: " + position);
        }
        int payloadSize = position - 4;
        if (buffer.isEOS()) {
            payloadSize = -payloadSize;
        }
        byteBuffer.putShort(0, buffer.getChannelID());
        byteBuffer.putShort(2, (short)payloadSize);
        byteBuffer.flip();
        this.sendBytes(buffer);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        if (len < 4) {
            if (len != 0) {
                throw new IllegalArgumentException("Payload length: " + len);
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Received empty buffer!");
            }
            return;
        }
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        byteBuffer.put(payload, offset, len);
        byteBuffer.flip();
        short channelID = byteBuffer.getShort();
        if (channelID == 0) {
            byteBuffer.position(4);
            try {
                try {
                    byte opcode = byteBuffer.get();
                    switch (opcode) {
                        case 1: {
                            this.assertNegotiating();
                            INegotiationContext negotiationContext = this.connector.getNegotiationContext();
                            while (negotiationContext == null) {
                                ConcurrencyUtil.sleep((long)20L);
                                negotiationContext = this.connector.getNegotiationContext();
                            }
                            INegotiationContext.Receiver receiver = negotiationContext.getReceiver();
                            receiver.receiveBuffer(negotiationContext, buffer.getByteBuffer());
                            break;
                        }
                        case 2: {
                            channelID = buffer.getShort();
                            int protocolVersion = buffer.getInt();
                            String protocolID = buffer.getString();
                            this.onRegistration(channelID, protocolVersion, protocolID);
                            break;
                        }
                        case 3: {
                            channelID = buffer.getShort();
                            String error = buffer.getString();
                            this.onRegistrationAck(channelID, error);
                            break;
                        }
                        case 4: {
                            channelID = buffer.getShort();
                            this.onDeregistration(channelID);
                            break;
                        }
                    }
                }
                catch (NegotiationException ex) {
                    OM.LOG.error((Throwable)ex);
                    this.connector.setNegotiationException(ex);
                    this.connector.deactivate();
                    buffer.release();
                }
            }
            finally {
                buffer.release();
            }
            return;
        }
        short payloadSize = byteBuffer.getShort();
        if (payloadSize < 0) {
            buffer.setEOS(true);
        }
        ((Buffer)buffer).setChannelID(channelID);
        ((Buffer)buffer).setState(BufferState.PUTTING);
        byteBuffer.position(4);
        InternalChannel channel = this.connector.getChannel(channelID);
        if (channel != null) {
            channel.handleBufferFromMultiplexer(buffer);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.trace("Discarding buffer from unknown channel");
            }
            buffer.release();
        }
    }

    public void onWebSocketText(String message) {
    }

    public void onWebSocketError(Throwable cause) {
        OM.LOG.error(cause);
        if (this.connector != null) {
            this.connector.deactivate();
        }
    }

    private void assertNegotiating() {
        if (!this.connector.isNegotiating()) {
            this.connector.deactivate();
            throw new IllegalStateException("Connector is not negotiating");
        }
    }

    private void assertConnected() {
        if (!this.connector.isConnected()) {
            throw new IllegalStateException("Connector is not connected");
        }
    }

    private void assertValidChannelID(short channelID) {
        if (channelID < 1) {
            throw new IllegalArgumentException("Bad channelID " + channelID);
        }
    }

    private IBuffer provideBuffer() {
        return this.connector.getConfig().getBufferProvider().provideBuffer();
    }
}

