/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db.evolution.phased;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.evolution.IModelEvolutionSupport;
import org.eclipse.emf.cdo.server.db.evolution.phased.Context;
import org.eclipse.emf.cdo.server.db.evolution.phased.DefaultChangeDetector;
import org.eclipse.emf.cdo.server.db.evolution.phased.DefaultSchemaMigrator;
import org.eclipse.emf.cdo.server.db.evolution.phased.FolderContextManager;
import org.eclipse.emf.cdo.server.db.evolution.phased.Phase;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class PhasedModelEvolutionSupport
extends Lifecycle
implements IModelEvolutionSupport {
    public static final String FACTORY_TYPE = "phased";
    private static final EPackage.Registry GLOBAL_PACKAGE_REGISTRY = EPackage.Registry.INSTANCE;
    private static final InternalCDOPackageRegistry.PackageLoader NO_PACKAGE_LOADING = packageUnit -> {
        throw new UnsupportedOperationException("Loading of package units is not supported during model evolution");
    };
    private static final InternalCDOPackageRegistry.PackageProcessor NO_PACKAGE_PROCESSING = null;
    private static final String SUPPORT_PROPERTIES_FILE = "support.properties";
    private static final String PROP_EVOLUTION_ID = "evolution.id";
    private static final String PROP_EVOLUTION_ONGOING = "evolution.ongoing";
    private static final String PROP_PHASE = "phase";
    private static final String PROP_PHASE_ONGOING = "phase.ongoing";
    private final Deque<Pair<String, Long>> logBuffer = new LinkedList<Pair<String, Long>>();
    private final EnumMap<Phase, Phase.Handler> phaseHandlers = new EnumMap(Phase.class);
    private Context.Manager contextManager;
    private File rootFolder;
    private IDBStore store;
    private Mode mode;
    private int evolutionID;
    private boolean evolutionOngoing;
    private Phase phase;
    private boolean phaseOngoing;
    private Context context;
    private InternalCDOPackageRegistry oldPackageRegistry;
    private InternalCDOPackageRegistry newPackageRegistry;

    public File getRootFolder() {
        return this.rootFolder;
    }

    @AnnotationFactory.InjectAttribute(name="rootFolder")
    public void setRootFolder(File rootFolder) {
        this.checkInactive();
        this.rootFolder = rootFolder;
    }

    @Override
    public IDBStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IDBStore store) {
        this.checkInactive();
        this.store = store;
    }

    public Mode getMode() {
        return this.mode;
    }

    @AnnotationFactory.InjectAttribute(name="mode")
    public void setMode(Mode mode) {
        this.checkInactive();
        this.mode = mode;
    }

    public Context.Manager getContextManager() {
        return this.contextManager;
    }

    @AnnotationFactory.InjectElement(name="contextManager", productGroup="org.eclipse.emf.cdo.server.db.evolution.contextManagers", defaultFactoryType="folder")
    public void setContextManager(Context.Manager contextManager) {
        this.checkInactive();
        this.contextManager = contextManager;
    }

    public Phase.Handler getPhaseHandler(Phase phase) {
        return phase == null ? null : this.phaseHandlers.get((Object)phase);
    }

    @AnnotationFactory.InjectElement(name="changeDetector", productGroup="org.eclipse.emf.cdo.server.db.evolution.phaseHandlers", defaultFactoryType="default", factoryTypeSuffix="-change-detector")
    public void setChangeDetector(Phase.Handler changeDetector) {
        this.setPhaseHandler(Phase.ChangeDetection, changeDetector);
    }

    @AnnotationFactory.InjectElement(name="repositoryExporter", productGroup="org.eclipse.emf.cdo.server.db.evolution.phaseHandlers", defaultFactoryType="default", factoryTypeSuffix="-repository-exporter")
    public void setRepositoryExporter(Phase.Handler repositoryExporter) {
        this.setPhaseHandler(Phase.RepositoryExport, repositoryExporter);
    }

    @AnnotationFactory.InjectElement(name="schemaMigrator", productGroup="org.eclipse.emf.cdo.server.db.evolution.phaseHandlers", defaultFactoryType="default", factoryTypeSuffix="-schema-migrator")
    public void setSchemaMigrator(Phase.Handler schemaMigrator) {
        this.setPhaseHandler(Phase.SchemaMigration, schemaMigrator);
    }

    @AnnotationFactory.InjectElement(name="storeProcessor", productGroup="org.eclipse.emf.cdo.server.db.evolution.phaseHandlers", factoryTypeSuffix="-store-processor")
    public void setStorePostProcessor(Phase.Handler storeProcessor) {
        this.setPhaseHandler(Phase.StoreProcessing, storeProcessor);
    }

    @AnnotationFactory.InjectElement(name="repositoryProcessor", productGroup="org.eclipse.emf.cdo.server.db.evolution.phaseHandlers", factoryTypeSuffix="-repository-processor")
    public void setRepositoryPostProcessor(Phase.Handler repositoryProcessor) {
        this.setPhaseHandler(Phase.RepositoryProcessing, repositoryProcessor);
    }

    public Phase getPhase() {
        return this.phase;
    }

    public boolean isPhaseOngoing() {
        return this.phaseOngoing;
    }

    public int getEvolutionID() {
        return this.evolutionID;
    }

    public File getEvolutionFolder() {
        return this.evolutionID < 1 ? null : new File(this.rootFolder, Integer.toString(this.evolutionID));
    }

    public File getEvolutionLog() {
        File folder = this.getEvolutionFolder();
        return folder == null ? null : new File(folder, "evolution.log");
    }

    public Context getContext() {
        return this.context;
    }

    public InternalCDOPackageRegistry getOldPackageRegistry() {
        if (this.oldPackageRegistry == null) {
            this.oldPackageRegistry = PhasedModelEvolutionSupport.createPackageRegistry(false);
        }
        return this.oldPackageRegistry;
    }

    public InternalCDOPackageRegistry getNewPackageRegistry() {
        if (this.newPackageRegistry == null) {
            this.newPackageRegistry = PhasedModelEvolutionSupport.createPackageRegistry(true);
        }
        return this.newPackageRegistry;
    }

    public void log(Object message) {
        if (message != null) {
            String string = message.toString();
            try {
                OM.LOG.info("[Model evolution for repository " + this.store.getRepository().getName() + "] " + string);
            }
            catch (Exception ex) {
                OM.LOG.error("Failed to log message: " + message.getClass().getName(), (Throwable)ex);
            }
            this.logBuffer.add((Pair<String, Long>)Pair.create((Object)string, (Object)System.currentTimeMillis()));
            File log = this.getEvolutionLog();
            if (log != null && log.getParentFile().isDirectory()) {
                try {
                    Throwable throwable = null;
                    Object var5_8 = null;
                    try (BufferedWriter writer = IOUtil.buffered((Writer)new FileWriter(log, true));){
                        while (!this.logBuffer.isEmpty()) {
                            Pair<String, Long> line = this.logBuffer.poll();
                            writer.write("[");
                            writer.write(CDOCommonUtil.formatTimeStamp((long)((Long)line.getElement2())));
                            writer.write("] ");
                            writer.write((String)line.getElement1());
                            writer.write(StringUtil.NL);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error("Failed to write to evolution log: " + log, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void trigger(IModelEvolutionSupport.Trigger trigger) throws Exception {
        this.checkActive();
        if (this.mode == Mode.Disabled) {
            if (trigger == IModelEvolutionSupport.Trigger.ActivatingStore) {
                OM.LOG.info("Model evolution support is disabled");
            }
            this.deactivate();
            return;
        }
        if (this.phase == null) {
            this.phase = Phase.ChangeDetection;
        }
        if (this.phase.trigger() != trigger) {
            return;
        }
        this.log("Triggered by " + (Object)((Object)trigger));
        if (this.context == null) {
            this.log("Root folder: " + this.rootFolder);
            if (this.phase.initial()) {
                this.log("Creating new model evolution context");
                this.context = this.contextManager.createContext();
            } else {
                this.log("Loading existing model evolution context");
                this.context = this.contextManager.loadContext();
            }
        }
        this.executePhaseLoop();
    }

    protected void executePhaseLoop() throws IOException, Exception, LifecycleUtil.ReactivationTrigger {
        while (this.phase != null) {
            if (this.phaseOngoing) {
                throw new IllegalStateException("Model evolution was interrupted for repository " + this.store.getRepository().getName() + " during phase " + (Object)((Object)this.phase) + "; manual intervention is required to recover");
            }
            this.phaseOngoing = true;
            if (!this.phase.initial()) {
                this.saveProperties();
            }
            Phase.Handler phaseHandler = this.getCurrentPhaseHandler();
            this.log("Starting phase " + (Object)((Object)this.phase) + " (handler: " + phaseHandler + ")");
            this.executePhaseHandler(phaseHandler);
            if (this.phase.initial()) {
                if (this.context.getChangeInfos().isEmpty()) {
                    this.log("No model changes detected; aborting model evolution process");
                    this.deactivate();
                    return;
                }
                if (this.mode == Mode.Prevent) {
                    this.log("Model changes detected, but model evolution mode is set to PREVENT; aborting model evolution process");
                    throw new IllegalStateException("Model changes detected, but model evolution mode is set to PREVENT");
                }
                ++this.evolutionID;
                this.log("Model changes detected; assigned evolution ID " + this.evolutionID);
                this.contextManager.saveContext(this.context);
            }
            this.log("Completed phase " + (Object)((Object)this.phase));
            Phase nextPhase = this.determineNextPhase();
            Phase.Transition transition = this.phase.transitionTo(nextPhase);
            this.phase = nextPhase;
            this.phaseOngoing = false;
            this.saveProperties();
            if (transition == null) continue;
            switch (transition) {
                case SameTrigger: {
                    break;
                }
                case NextTrigger: {
                    this.log("Moving to next trigger before proceeding to phase " + (Object)((Object)this.phase));
                    return;
                }
                case StoreRestart: {
                    this.log("Restarting store before proceeding to phase " + (Object)((Object)this.phase));
                    throw LifecycleUtil.ReactivationTrigger.createFor((Object)this.store);
                }
                case RepositoryRestart: {
                    this.log("Restarting repository before proceeding to phase " + (Object)((Object)this.phase));
                    throw LifecycleUtil.ReactivationTrigger.createFor((Object)this.store.getRepository());
                }
            }
        }
        this.log("Model evolution process completed successfully");
        this.log("Total row updates: " + this.context.getTotalUpdateCount());
        this.evolutionOngoing = false;
        this.saveProperties();
        this.deactivate();
    }

    protected void executePhaseHandler(Phase.Handler phaseHandler) throws Exception {
        Phase phase = phaseHandler.getPhase();
        phase.init(this.context);
        phaseHandler.execute(this.context);
        phase.done(this.context);
    }

    protected Phase determineNextPhase() {
        Phase nextPhase = this.phase.next();
        while (nextPhase != null && this.getPhaseHandler(nextPhase) == null) {
            nextPhase = nextPhase.next();
        }
        return nextPhase;
    }

    protected Phase.Handler getCurrentPhaseHandler() {
        Phase.Handler phaseHandler = this.getPhaseHandler(this.phase);
        if (phaseHandler == null) {
            throw new IllegalStateException("No phase handler for phase " + (Object)((Object)this.phase));
        }
        return phaseHandler;
    }

    protected void addedChangeInfo(Context.Model model, Object changeInfo) {
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        CheckUtil.checkState((Object)this.store, (String)"store");
        if (this.rootFolder == null) {
            this.rootFolder = new File(OM.BUNDLE.getStateLocation(), "evolution");
        }
        if (this.mode == null) {
            this.mode = Mode.Migrate;
        }
        if (this.contextManager == null) {
            this.contextManager = new FolderContextManager();
        }
        this.contextManager.setSupport(this);
        if (this.getPhaseHandler(Phase.ChangeDetection) == null) {
            this.setPhaseHandler(Phase.ChangeDetection, new DefaultChangeDetector());
        }
        if (this.getPhaseHandler(Phase.SchemaMigration) == null) {
            this.setPhaseHandler(Phase.SchemaMigration, new DefaultSchemaMigrator());
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.contextManager);
        for (Phase.Handler handler : this.phaseHandlers.values()) {
            LifecycleUtil.activate((Object)handler);
        }
        this.loadProperties();
    }

    protected void doDeactivate() throws Exception {
        for (Phase.Handler handler : this.phaseHandlers.values()) {
            LifecycleUtil.deactivate((Object)handler);
        }
        LifecycleUtil.deactivate((Object)this.contextManager);
        this.evolutionID = 0;
        this.evolutionOngoing = false;
        this.phase = null;
        this.phaseOngoing = false;
        this.logBuffer.clear();
        super.doDeactivate();
    }

    private void setPhaseHandler(Phase phase, Phase.Handler handler) {
        this.checkInactive();
        handler.setPhase(phase);
        this.phaseHandlers.put(phase, handler);
    }

    private void loadProperties() throws IOException {
        Properties properties = IOUtil.loadProperties((File)this.getSupportPropertiesFile());
        this.evolutionID = PhasedModelEvolutionSupport.getProperty(properties, PROP_EVOLUTION_ID, 0);
        this.evolutionOngoing = PhasedModelEvolutionSupport.getProperty(properties, PROP_EVOLUTION_ONGOING, false);
        this.phase = Phase.parse(properties.getProperty(PROP_PHASE));
        this.phaseOngoing = PhasedModelEvolutionSupport.getProperty(properties, PROP_PHASE_ONGOING, false);
    }

    private void saveProperties() throws IOException {
        Properties properties = new Properties();
        if (this.evolutionID != 0) {
            properties.setProperty(PROP_EVOLUTION_ID, Integer.toString(this.evolutionID));
        }
        if (this.evolutionOngoing) {
            properties.setProperty(PROP_EVOLUTION_ONGOING, StringUtil.TRUE);
        }
        if (this.phase != null) {
            properties.setProperty(PROP_PHASE, this.phase.name());
        }
        if (this.phaseOngoing) {
            properties.setProperty(PROP_PHASE_ONGOING, StringUtil.TRUE);
        }
        IOUtil.saveProperties((File)this.getSupportPropertiesFile(), (Properties)properties, null);
    }

    private File getSupportPropertiesFile() {
        return new File(this.rootFolder, SUPPORT_PROPERTIES_FILE);
    }

    private static boolean getProperty(Properties properties, String key, boolean defaultValue) {
        String value = properties.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private static int getProperty(Properties properties, String key, int defaultValue) {
        String value = properties.getProperty(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    private static InternalCDOPackageRegistry createPackageRegistry(boolean delegateToGlobal) {
        EPackage.Registry delegateRegistry = delegateToGlobal ? GLOBAL_PACKAGE_REGISTRY : null;
        InternalCDOPackageRegistry packageRegistry = (InternalCDOPackageRegistry)CDOModelUtil.createPackageRegistry((EPackage.Registry)delegateRegistry);
        packageRegistry.setPackageLoader(NO_PACKAGE_LOADING);
        packageRegistry.setPackageProcessor(NO_PACKAGE_PROCESSING);
        packageRegistry.activate();
        return packageRegistry;
    }

    public static enum Mode {
        Disabled,
        Prevent,
        Migrate;


        public static Mode parse(String str) {
            return (Mode)StringUtil.parseEnum(Mode.class, (String)str, (boolean)true);
        }
    }
}

