/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import org.eclipse.emf.cdo.internal.net4j.ReconnectingCDOSessionImpl;
import org.eclipse.emf.cdo.internal.net4j.RecoveringCDOSessionConfigurationImpl;
import org.eclipse.emf.cdo.net4j.ReconnectingCDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.container.IManagedContainer;

public class ReconnectingCDOSessionConfigurationImpl
extends RecoveringCDOSessionConfigurationImpl
implements ReconnectingCDOSessionConfiguration {
    private String hostAndPort;
    private long reconnectInterval = 0L;
    private int maxReconnectAttempts = Integer.MAX_VALUE;

    public ReconnectingCDOSessionConfigurationImpl(String hostAndPort, String repositoryName, IManagedContainer container) {
        super(container);
        this.hostAndPort = hostAndPort;
        this.setRepositoryName(repositoryName);
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    @Override
    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    @Override
    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public void setExceptionHandler(CDOSession.ExceptionHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalCDOSession createSession() {
        ReconnectingCDOSessionImpl session = new ReconnectingCDOSessionImpl();
        super.setExceptionHandler(session.getExceptionHandler());
        return session;
    }

    @Override
    protected void configureSession(InternalCDOSession session) {
        super.configureSession(session);
        ReconnectingCDOSessionImpl sessionImpl = (ReconnectingCDOSessionImpl)session;
        sessionImpl.setRepositoryConnectorDescription(this.hostAndPort);
        sessionImpl.setReconnectInterval(this.reconnectInterval);
        sessionImpl.setMaxReconnectAttempts(this.maxReconnectAttempts);
    }
}

