/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerWriteIndication;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;

public class LockAreaIndication
extends CDOServerWriteIndication {
    private String result;

    public LockAreaIndication(CDOServerProtocol protocol) {
        super(protocol, (short)27);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        InternalLockManager lockManager = this.getRepository().getLockingManager();
        int viewID = in.readXInt();
        InternalView view = this.getView(viewID);
        boolean create = in.readBoolean();
        if (create) {
            CDOLockOwner oldOwner = view.getLockOwner();
            IDurableLockingManager.LockArea area = lockManager.createLockArea(view);
            this.result = area.getDurableLockingID();
            view.setDurableLockingID(this.result);
            CDOLockOwner newOwner = view.getLockOwner();
            if (newOwner != oldOwner) {
                CDOBranch branch = view.getBranch();
                InternalSession session = view.getSession();
                InternalSessionManager manager = session.getManager();
                manager.sendLockOwnerRemappedNotification(session, branch, oldOwner, newOwner);
            }
        } else {
            String durableLockingID = view.getDurableLockingID();
            lockManager.deleteLockArea(durableLockingID);
        }
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        out.writeString(this.result);
    }
}

