/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.checkouts;

import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutImpl;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutManagerImpl;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class OnlineCDOCheckout
extends CDOCheckoutImpl {
    public OnlineCDOCheckout() {
    }

    public OnlineCDOCheckout(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public boolean isOffline() {
        return false;
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public final boolean isDirty() {
        return false;
    }

    public CDOState getState(Object object) {
        return null;
    }

    @Override
    public String getBranchPath() {
        CDOBranch branch;
        CDOView view = this.getView();
        if (view != null && (branch = view.getBranch()) != null) {
            return branch.getPathName();
        }
        return super.getBranchPath();
    }

    @Override
    protected CDOView openView(CDOSession session, ResourceSet resourceSet) {
        CDOBranchManager branchManager = session.getBranchManager();
        CDOBranch branch = branchManager.getBranch(this.getBranchID());
        if (branch.isDeleted() || branch.getBase() == null) {
            throw new CDOException("Branch is deleted");
        }
        this.setBranchPath(branch.getPathName());
        CDOView view = this.openView(session, branch, resourceSet);
        view.addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                CDOCheckoutManagerImpl manager;
                if (event instanceof CDOViewTargetChangedEvent && (manager = OnlineCDOCheckout.this.getManager()) != null) {
                    manager.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.ELEMENT, OnlineCDOCheckout.this);
                }
            }
        });
        return view;
    }

    private CDOView openView(CDOSession session, CDOBranch branch, ResourceSet resourceSet) {
        long timeStamp = this.getTimeStamp();
        return session.openView(branch, timeStamp, resourceSet);
    }

    @Override
    protected void prepareOpen() {
        CDORepository repository = this.getRepository();
        repository.connect();
        super.prepareOpen();
    }
}

